/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import io.airlift.airline.Arguments;
import io.airlift.airline.Cli;
import io.airlift.airline.Command;
import io.airlift.airline.Help;
import io.airlift.airline.Option;
import io.airlift.airline.OptionType;
import java.util.List;

public class Git {
    public static void main(String ... args) {
        Cli.CliBuilder builder = Cli.builder((String)"git").withDescription("the stupid content tracker").withDefaultCommand(Help.class).withCommand(Help.class).withCommand(Add.class);
        builder.withGroup("remote").withDescription("Manage set of tracked repositories").withDefaultCommand(RemoteShow.class).withCommand(RemoteShow.class).withCommand(RemoteAdd.class);
        Cli gitParser = builder.build();
        ((Runnable)gitParser.parse(args)).run();
    }

    @Command(name="add", description="Adds a remote")
    public static class RemoteAdd
    extends GitCommand {
        @Option(name={"-t"}, description="Track only a specific branch")
        public String branch;
        @Arguments(description="Remote repository to add")
        public List<String> remote;
    }

    @Command(name="show", description="Gives some information about the remote <name>")
    public static class RemoteShow
    extends GitCommand {
        @Option(name={"-n"}, description="Do not query remote heads")
        public boolean noQuery;
        @Arguments(description="Remote to show")
        public String remote;
    }

    @Command(name="add", description="Add file contents to the index")
    public static class Add
    extends GitCommand {
        @Arguments(description="Patterns of files to be added")
        public List<String> patterns;
        @Option(name={"-i"}, description="Add modified contents interactively.")
        public boolean interactive;
    }

    public static class GitCommand
    implements Runnable {
        @Option(type=OptionType.GLOBAL, name={"-v"}, description="Verbose mode")
        public boolean verbose;

        @Override
        public void run() {
            System.out.println(this.getClass().getSimpleName());
        }
    }
}

