/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import io.airlift.compress.zstd.XxHash64;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import sun.misc.Unsafe;

public class TestXxHash64 {
    private static final long PRIME = 2654435761L;
    private final byte[] buffer = new byte[101];

    public TestXxHash64() {
        long value = 2654435761L;
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = (byte)(value >> 24);
            value *= value;
        }
    }

    @Test
    public void testSanity() {
        TestXxHash64.assertHash(0L, this.buffer, 0, -1205034819632174695L);
        TestXxHash64.assertHash(0L, this.buffer, 1, 5750596776143442648L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 1, 8329478753618994979L);
        TestXxHash64.assertHash(0L, this.buffer, 4, -7901876112562082063L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 4, 708753852729961291L);
        TestXxHash64.assertHash(0L, this.buffer, 8, -626931337744172849L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 8, -7186417346120842555L);
        TestXxHash64.assertHash(0L, this.buffer, 14, -3460297540090709443L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 14, 6599481375206459851L);
        TestXxHash64.assertHash(0L, this.buffer, 32, -5812084625956540946L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 32, -2545780413506618609L);
        TestXxHash64.assertHash(0L, this.buffer, this.buffer.length, 1057031117799454893L);
        TestXxHash64.assertHash(2654435761L, this.buffer, this.buffer.length, -3844287129753543135L);
    }

    @Test
    public void testMultipleLengths() {
        XXHash64 jpountz = XXHashFactory.fastestInstance().hash64();
        for (int i = 0; i < 20000; ++i) {
            byte[] data = new byte[i];
            long expected = jpountz.hash(data, 0, data.length, 0L);
            TestXxHash64.assertHash(0L, data, data.length, expected);
        }
    }

    private static void assertHash(long seed, byte[] data, int length, long expected) {
        Assert.assertEquals((long)TestXxHash64.hash(seed, data, length), (long)expected);
    }

    private static long hash(long seed, byte[] data, int length) {
        return XxHash64.hash((long)seed, (Object)data, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, (int)length);
    }
}

