/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import io.airlift.compress.zstd.FrameHeader;
import io.airlift.compress.zstd.ZstdFrameCompressor;
import io.airlift.compress.zstd.ZstdFrameDecompressor;
import org.testng.Assert;
import org.testng.annotations.Test;
import sun.misc.Unsafe;

public class TestCompressor {
    @Test
    public void testMagic() {
        byte[] buffer = new byte[4];
        int address = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        ZstdFrameCompressor.writeMagic((Object)buffer, (long)address, (long)(address + buffer.length));
        ZstdFrameDecompressor.verifyMagic((Object)buffer, (long)address, (long)(address + buffer.length));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*buffer too small.*")
    public void testMagicFailsWithSmallBuffer() {
        byte[] buffer = new byte[3];
        ZstdFrameCompressor.writeMagic((Object)buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, (long)(Unsafe.ARRAY_BYTE_BASE_OFFSET + buffer.length));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*buffer too small.*")
    public void testFrameHeaderFailsWithSmallBuffer() {
        byte[] buffer = new byte[13];
        ZstdFrameCompressor.writeFrameHeader((Object)buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, (long)(Unsafe.ARRAY_BYTE_BASE_OFFSET + buffer.length), (int)1000, (int)1024);
    }

    @Test
    public void testFrameHeader() {
        this.verifyFrameHeader(1, 1024, new FrameHeader(2L, -1, 1L, -1L, true));
        this.verifyFrameHeader(256, 1024, new FrameHeader(3L, -1, 256L, -1L, true));
        this.verifyFrameHeader(65792, 1152, new FrameHeader(6L, 1152, 65792L, -1L, true));
        this.verifyFrameHeader(65792, 1280, new FrameHeader(6L, 1280, 65792L, -1L, true));
        this.verifyFrameHeader(65792, 1408, new FrameHeader(6L, 1408, 65792L, -1L, true));
        this.verifyFrameHeader(65792, 1536, new FrameHeader(6L, 1536, 65792L, -1L, true));
        this.verifyFrameHeader(65792, 1664, new FrameHeader(6L, 1664, 65792L, -1L, true));
        this.verifyFrameHeader(65792, 1792, new FrameHeader(6L, 1792, 65792L, -1L, true));
        this.verifyFrameHeader(65792, 1920, new FrameHeader(6L, 1920, 65792L, -1L, true));
        this.verifyFrameHeader(65792, 2048, new FrameHeader(6L, 2048, 65792L, -1L, true));
        this.verifyFrameHeader(65792, 2048, new FrameHeader(6L, 2048, 65792L, -1L, true));
        this.verifyFrameHeader(Integer.MAX_VALUE, 1024, new FrameHeader(6L, 1024, Integer.MAX_VALUE, -1L, true));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Minimum window size is 1024")
    public void testMinimumWindowSize() {
        byte[] buffer = new byte[14];
        int address = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        ZstdFrameCompressor.writeFrameHeader((Object)buffer, (long)address, (long)(address + buffer.length), (int)2000, (int)1023);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="\\QWindow size of magnitude 2^10 must be multiple of 128\\E")
    public void testWindowSizePrecision() {
        byte[] buffer = new byte[14];
        int address = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        ZstdFrameCompressor.writeFrameHeader((Object)buffer, (long)address, (long)(address + buffer.length), (int)2000, (int)1025);
    }

    private void verifyFrameHeader(int inputSize, int windowSize, FrameHeader expected) {
        byte[] buffer = new byte[14];
        int address = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        int size = ZstdFrameCompressor.writeFrameHeader((Object)buffer, (long)address, (long)(address + buffer.length), (int)inputSize, (int)windowSize);
        Assert.assertEquals((long)size, (long)expected.headerSize);
        FrameHeader actual = ZstdFrameDecompressor.readFrameHeader((Object)buffer, (long)address, (long)(address + buffer.length));
        Assert.assertEquals((Object)actual, (Object)expected);
    }
}

