/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.thirdparty;

import com.google.common.base.Preconditions;
import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.anarres.lzo.hadoop.codec.LzoDecompressor;

public class HadoopLzoDecompressor
implements Decompressor {
    private static final int MAX_OUTPUT_BUFFER_SIZE = 0x8000000;
    private final org.apache.hadoop.io.compress.Decompressor decompressor = new LzoDecompressor(LzoDecompressor.CompressionStrategy.LZO1X, 0x8000000);

    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        int offset;
        Preconditions.checkArgument((maxOutputLength < 0x8000000 ? 1 : 0) != 0, (Object)("output size " + maxOutputLength + " exceed maximum size : " + maxOutputLength));
        if (inputLength == 0) {
            return 0;
        }
        this.decompressor.reset();
        this.decompressor.setInput(input, inputOffset, inputLength);
        int outputLimit = outputOffset + maxOutputLength;
        for (offset = outputOffset; !this.decompressor.finished() && offset < outputLimit; offset += this.decompressor.decompress(output, offset, outputLimit - offset)) {
            try {
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return offset - outputOffset;
    }

    public void decompress(ByteBuffer input, ByteBuffer output) throws MalformedInputException {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

