/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.snappy;

import com.google.common.base.Preconditions;
import java.io.OutputStream;

public final class ByteArrayOutputStream
extends OutputStream {
    private final byte[] buffer;
    private final int initialOffset;
    private final int bufferLimit;
    private int offset;

    public ByteArrayOutputStream(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public ByteArrayOutputStream(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.initialOffset = offset;
        this.bufferLimit = offset + length;
        this.offset = offset;
    }

    @Override
    public void write(int value) {
        Preconditions.checkPositionIndex((int)(this.offset + 1), (int)this.bufferLimit);
        this.buffer[this.offset++] = (byte)value;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        Preconditions.checkPositionIndex((int)(this.offset + length), (int)this.bufferLimit);
        System.arraycopy(buffer, offset, this.buffer, this.offset, length);
        this.offset += length;
    }

    public int size() {
        return this.offset - this.initialOffset;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }
}

