/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.lz4;

import io.airlift.compress.lz4.Lz4RawCompressor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.CommandLineOptionException;
import org.openjdk.jmh.runner.options.CommandLineOptions;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import sun.misc.Unsafe;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Measurement(iterations=10)
@Warmup(iterations=5)
@Fork(value=3)
public class BenchmarkCount {
    @Param(value={"1", "3", "7", "15", "127", "511"})
    private int matchLength;
    @Param(value={"0", "1", "3", "7", "50"})
    private int padding;
    private byte[] data;

    @Setup
    public void setup() {
        int size = (this.matchLength + 1) * 2 + this.padding;
        this.data = new byte[size];
        byte[] pattern = new byte[this.matchLength];
        ThreadLocalRandom.current().nextBytes(pattern);
        System.arraycopy(pattern, 0, this.data, 0, this.matchLength);
        this.data[this.matchLength] = 1;
        System.arraycopy(pattern, 0, this.data, this.matchLength + 1, this.matchLength);
        this.data[this.matchLength + 1 + this.matchLength] = 2;
    }

    @Benchmark
    public long count() {
        return Lz4RawCompressor.count((Object)this.data, (long)(Unsafe.ARRAY_BYTE_BASE_OFFSET + this.matchLength + 1), (long)(Unsafe.ARRAY_BYTE_BASE_OFFSET + this.data.length), (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
    }

    public static void main(String[] args) throws RunnerException, CommandLineOptionException {
        CommandLineOptions parsedOptions = new CommandLineOptions(args);
        ChainedOptionsBuilder options = new OptionsBuilder().parent((Options)parsedOptions);
        if (parsedOptions.getIncludes().isEmpty()) {
            options = options.include(".*\\." + BenchmarkCount.class.getSimpleName() + ".*");
        }
        new Runner(options.build()).run();
    }
}

