/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.gzip;

import com.google.common.io.ByteStreams;
import io.airlift.compress.gzip.JdkGzipHadoopStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.zip.GZIPOutputStream;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestJdkGzipHadoopInputStream {
    @Test
    public void testGzipInputStreamBug() throws IOException {
        byte[] part1 = TestJdkGzipHadoopInputStream.zip("hello ".getBytes());
        byte[] part2 = TestJdkGzipHadoopInputStream.zip("world".getBytes());
        SequenceInputStream compressed = new SequenceInputStream(new ByteArrayInputStream(part1), new ByteArrayInputStream(part2));
        byte[] data = ByteStreams.toByteArray((InputStream)new JdkGzipHadoopStreams().createInputStream((InputStream)compressed));
        Assertions.assertThat((byte[])data).isEqualTo((Object)"hello world".getBytes());
    }

    private static byte[] zip(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(out);){
            ((OutputStream)gzipOut).write(data);
        }
        return out.toByteArray();
    }
}

