/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.zstd.ZstdInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ZstdStreamDecompressor
implements Decompressor {
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        ZstdStreamDecompressor.verifyRange(input, inputOffset, inputLength);
        ZstdStreamDecompressor.verifyRange(output, outputOffset, maxOutputLength);
        ZstdInputStream inputStream = new ZstdInputStream((InputStream)new ByteArrayInputStream(input, inputOffset, inputLength));
        try {
            int readSize = inputStream.read(output, outputOffset, maxOutputLength);
            if (inputStream.read() != -1) {
                throw new RuntimeException("All input was not consumed");
            }
            return readSize == -1 ? 0 : readSize;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void decompress(ByteBuffer inputBuffer, ByteBuffer outputBuffer) throws MalformedInputException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

