/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import com.google.common.io.Resources;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.zstd.TestZstd;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import io.airlift.compress.zstd.ZstdPartialDecompressor;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;

public class TestZstdPartial
extends TestZstd {
    @Override
    protected boolean isByteBufferSupported() {
        return false;
    }

    @Override
    protected Compressor getCompressor() {
        return new ZstdCompressor();
    }

    @Override
    protected Decompressor getDecompressor() {
        return new ZstdPartialDecompressor();
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new ZstdCompressor();
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new ZstdDecompressor();
    }

    @Override
    public void testInvalidSequenceOffset() throws IOException {
        byte[] compressed = Resources.toByteArray((URL)Objects.requireNonNull(this.getClass().getClassLoader().getResource("data/zstd/offset-before-start.zst")));
        byte[] output = new byte[compressed.length * 10];
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length)).isInstanceOf(MalformedInputException.class)).hasMessageStartingWith("Input is corrupted: offset=");
    }
}

