/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import com.google.common.io.Resources;
import io.airlift.compress.AbstractTestCompression;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.HadoopCodecCompressor;
import io.airlift.compress.HadoopCodecDecompressor;
import io.airlift.compress.HadoopCodecDecompressorByteAtATime;
import io.airlift.compress.HadoopNative;
import io.airlift.compress.zstd.ZstdCodec;
import io.airlift.compress.zstd.ZstdCompressor;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.ZStandardCodec;
import org.testng.annotations.Test;

public class TestZstdCodecByteAtATime
extends AbstractTestCompression {
    private final CompressionCodec verifyCodec;

    public TestZstdCodecByteAtATime() {
        ZStandardCodec codec = new ZStandardCodec();
        codec.setConf(new Configuration());
        this.verifyCodec = codec;
    }

    @Override
    protected boolean isByteBufferSupported() {
        return false;
    }

    @Override
    protected Compressor getCompressor() {
        return new HadoopCodecCompressor((CompressionCodec)new ZstdCodec(), (Compressor)new ZstdCompressor());
    }

    @Override
    protected Decompressor getDecompressor() {
        return new HadoopCodecDecompressorByteAtATime((CompressionCodec)new ZstdCodec());
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new HadoopCodecCompressor(this.verifyCodec, (Compressor)new ZstdCompressor());
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new HadoopCodecDecompressor(this.verifyCodec);
    }

    @Test
    public void testConcatenatedFrames() throws IOException {
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/multiple-frames.zst"));
        byte[] uncompressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/multiple-frames"));
        byte[] output = new byte[uncompressed.length];
        this.getVerifyDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length);
        TestZstdCodecByteAtATime.assertByteArraysEqual(uncompressed, 0, uncompressed.length, output, 0, output.length);
    }

    static {
        HadoopNative.requireHadoopNative();
    }
}

