/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.lz4;

import io.airlift.compress.AbstractTestCompression;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.airlift.compress.thirdparty.JPountzLz4Compressor;
import io.airlift.compress.thirdparty.JPountzLz4Decompressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Factory;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestLz4
extends AbstractTestCompression {
    @Override
    protected Compressor getCompressor() {
        return new Lz4Compressor();
    }

    @Override
    protected Decompressor getDecompressor() {
        return new Lz4Decompressor();
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new JPountzLz4Compressor(LZ4Factory.fastestInstance());
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new JPountzLz4Decompressor(LZ4Factory.fastestInstance());
    }

    @Test
    public void testLiteralLengthOverflow() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(-16);
        byte[] literalLengthBytes = new byte[0x808081];
        Arrays.fill(literalLengthBytes, (byte)-1);
        buffer.write(literalLengthBytes);
        buffer.write(1);
        buffer.write(new byte[20]);
        byte[] data = buffer.toByteArray();
        Assertions.assertThatThrownBy(() -> new Lz4Decompressor().decompress(data, 0, data.length, new byte[2048], 0, 2048)).isInstanceOf(MalformedInputException.class);
    }

    @Test
    public void testMatchLengthOverflow() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(15);
        buffer.write(new byte[2]);
        byte[] literalLengthBytes = new byte[0x808081];
        Arrays.fill(literalLengthBytes, (byte)-1);
        buffer.write(literalLengthBytes);
        buffer.write(1);
        buffer.write(new byte[10]);
        byte[] data = buffer.toByteArray();
        Assertions.assertThatThrownBy(() -> new Lz4Decompressor().decompress(data, 0, data.length, new byte[2048], 0, 2048)).isInstanceOf(MalformedInputException.class);
    }
}

