/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import com.google.common.io.Resources;
import io.airlift.compress.AbstractTestCompression;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.thirdparty.ZstdJniCompressor;
import io.airlift.compress.thirdparty.ZstdJniDecompressor;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.io.IOException;
import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestZstd
extends AbstractTestCompression {
    @Override
    protected Compressor getCompressor() {
        return new ZstdCompressor();
    }

    @Override
    protected Decompressor getDecompressor() {
        return new ZstdDecompressor();
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new ZstdJniCompressor(3);
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new ZstdJniDecompressor();
    }

    @Test
    public void testDecompressWithOutputPaddingAndChecksum() throws IOException {
        int padding = 1021;
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/with-checksum.zst"));
        byte[] uncompressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/with-checksum"));
        byte[] output = new byte[uncompressed.length + padding * 2];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressed.length, output, padding, output.length);
        TestZstd.assertByteArraysEqual(uncompressed, 0, uncompressed.length, output, padding, decompressedSize);
    }

    @Test
    public void testConcatenatedFrames() throws IOException {
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/multiple-frames.zst"));
        byte[] uncompressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/multiple-frames"));
        byte[] output = new byte[uncompressed.length];
        this.getDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length);
        TestZstd.assertByteArraysEqual(uncompressed, 0, uncompressed.length, output, 0, output.length);
    }

    @Test(expectedExceptions={MalformedInputException.class}, expectedExceptionsMessageRegExp="Input is corrupted: offset=894")
    public void testInvalidSequenceOffset() throws IOException {
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/offset-before-start.zst"));
        byte[] output = new byte[compressed.length * 10];
        this.getDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length);
    }

    @Test
    public void testSmallLiteralsAfterIncompressibleLiterals() throws IOException {
        Compressor compressor = this.getCompressor();
        byte[] original = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/small-literals-after-incompressible-literals"));
        int maxCompressLength = compressor.maxCompressedLength(original.length);
        byte[] compressed = new byte[maxCompressLength];
        int compressedSize = compressor.compress(original, 0, original.length, compressed, 0, compressed.length);
        byte[] decompressed = new byte[original.length];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressedSize, decompressed, 0, decompressed.length);
        TestZstd.assertByteArraysEqual(original, 0, original.length, decompressed, 0, decompressedSize);
    }

    @Test
    public void testLargeRle() throws IOException {
        Compressor compressor = this.getCompressor();
        byte[] original = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/large-rle"));
        int maxCompressLength = compressor.maxCompressedLength(original.length);
        byte[] compressed = new byte[maxCompressLength];
        int compressedSize = compressor.compress(original, 0, original.length, compressed, 0, compressed.length);
        byte[] decompressed = new byte[original.length];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressedSize, decompressed, 0, decompressed.length);
        TestZstd.assertByteArraysEqual(original, 0, original.length, decompressed, 0, decompressedSize);
    }

    @Test
    public void testIncompressibleData() throws IOException {
        Compressor compressor = this.getCompressor();
        byte[] original = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/incompressible"));
        int maxCompressLength = compressor.maxCompressedLength(original.length);
        byte[] compressed = new byte[maxCompressLength];
        int compressedSize = compressor.compress(original, 0, original.length, compressed, 0, compressed.length);
        byte[] decompressed = new byte[original.length];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressedSize, decompressed, 0, decompressed.length);
        TestZstd.assertByteArraysEqual(original, 0, original.length, decompressed, 0, decompressedSize);
    }

    @Test
    public void testMaxCompressedSize() {
        Assert.assertEquals((int)new ZstdCompressor().maxCompressedLength(0), (int)64);
        Assert.assertEquals((int)new ZstdCompressor().maxCompressedLength(65536), (int)65824);
        Assert.assertEquals((int)new ZstdCompressor().maxCompressedLength(131072), (int)131584);
        Assert.assertEquals((int)new ZstdCompressor().maxCompressedLength(131073), (int)131585);
    }
}

