/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.lzo;

import com.google.common.io.Resources;
import io.airlift.compress.AbstractTestCompression;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.HadoopCodecCompressor;
import io.airlift.compress.HadoopCodecDecompressor;
import io.airlift.compress.HadoopNative;
import io.airlift.compress.lzo.LzopCodec;
import io.airlift.compress.thirdparty.HadoopLzoCompressor;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLzopCodec
extends AbstractTestCompression {
    private final CompressionCodec verifyCodec;

    public TestLzopCodec() {
        com.hadoop.compression.lzo.LzopCodec codec = new com.hadoop.compression.lzo.LzopCodec();
        codec.setConf(new Configuration());
        this.verifyCodec = codec;
    }

    @Override
    protected boolean isByteBufferSupported() {
        return false;
    }

    @Override
    protected Compressor getCompressor() {
        return new HadoopCodecCompressor((CompressionCodec)new LzopCodec(), new HadoopLzoCompressor());
    }

    @Override
    protected Decompressor getDecompressor() {
        return new HadoopCodecDecompressor((CompressionCodec)new LzopCodec());
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new HadoopCodecCompressor(this.verifyCodec, new HadoopLzoCompressor());
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new HadoopCodecDecompressor(this.verifyCodec);
    }

    @Test
    public void testDecompressNewerVersion() throws IOException {
        this.assertDecompressed("no-checksum");
        this.assertDecompressed("adler32");
        this.assertDecompressed("adler32-both");
        this.assertDecompressed("crc32");
        this.assertDecompressed("crc32-both");
    }

    private void assertDecompressed(String variant) throws IOException {
        byte[] compressed = Resources.toByteArray((URL)Resources.getResource(this.getClass(), (String)String.format("/data/lzo/test-%s.lzo", variant)));
        byte[] uncompressed = Resources.toByteArray((URL)Resources.getResource(this.getClass(), (String)"/data/lzo/test"));
        byte[] output = new byte[uncompressed.length];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length);
        Assert.assertEquals((int)decompressedSize, (int)output.length);
        TestLzopCodec.assertByteArraysEqual(uncompressed, 0, uncompressed.length, output, 0, output.length);
    }

    static {
        HadoopNative.requireHadoopNative();
    }
}

