/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress;

import io.airlift.compress.Compressor;
import io.airlift.compress.snappy.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;

public class HadoopCodecCompressor
implements Compressor {
    private final CompressionCodec codec;
    private final Compressor blockCompressorForSizeCalculation;

    public HadoopCodecCompressor(CompressionCodec codec, Compressor blockCompressorForSizeCalculation) {
        this.codec = codec;
        this.blockCompressorForSizeCalculation = blockCompressorForSizeCalculation;
    }

    public int maxCompressedLength(int uncompressedSize) {
        return (int)((double)this.blockCompressorForSizeCalculation.maxCompressedLength(uncompressedSize) * 1.1 + 8.0);
    }

    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(output, outputOffset, maxOutputLength);
        try {
            CompressionOutputStream out = this.codec.createOutputStream((OutputStream)byteArrayOutputStream);
            out.write(input, inputOffset, inputLength);
            out.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return byteArrayOutputStream.size();
    }

    public void compress(ByteBuffer input, ByteBuffer output) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

