/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity.examples;

import info.debatty.java.stringsimilarity.CharacterSubstitutionInterface;
import info.debatty.java.stringsimilarity.Cosine;
import info.debatty.java.stringsimilarity.Damerau;
import info.debatty.java.stringsimilarity.Jaccard;
import info.debatty.java.stringsimilarity.JaroWinkler;
import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.stringsimilarity.Levenshtein;
import info.debatty.java.stringsimilarity.LongestCommonSubsequence;
import info.debatty.java.stringsimilarity.NGram;
import info.debatty.java.stringsimilarity.NormalizedLevenshtein;
import info.debatty.java.stringsimilarity.QGram;
import info.debatty.java.stringsimilarity.SorensenDice;
import info.debatty.java.stringsimilarity.WeightedLevenshtein;

public class Examples {
    public static void main(String[] args) {
        Levenshtein levenshtein = new Levenshtein();
        System.out.println(levenshtein.distance("My string", "My $tring"));
        System.out.println(levenshtein.distance("My string", "M string2"));
        System.out.println(levenshtein.distance("My string", "My $tring"));
        Jaccard j2 = new Jaccard(2);
        System.out.println(j2.similarity("ABCDE", "ABCDF"));
        JaroWinkler jw = new JaroWinkler();
        System.out.println(jw.similarity("My string", "My tsring"));
        System.out.println(jw.similarity("My string", "My ntrisg"));
        Cosine cos = new Cosine(3);
        System.out.println(cos.similarity("ABC", "ABCE"));
        cos = new Cosine(2);
        System.out.println(cos.similarity("ABAB", "BAB"));
        Damerau damerau = new Damerau();
        System.out.println(damerau.distance("ABCDEF", "ABDCEF"));
        System.out.println(damerau.distance("ABCDEF", "BACDFE"));
        System.out.println(damerau.distance("ABCDEF", "ABCDE"));
        System.out.println(damerau.distance("ABCDEF", "BCDEF"));
        System.out.println(damerau.distance("ABCDEF", "ABCGDEF"));
        System.out.println(damerau.distance("ABCDEF", "POIU"));
        LongestCommonSubsequence lcs = new LongestCommonSubsequence();
        System.out.println(lcs.distance("AGCAT", "GAC"));
        System.out.println(lcs.distance("AGCAT", "AGCT"));
        NGram twogram = new NGram(2);
        System.out.println(twogram.distance("ABCD", "ABTUIO"));
        String s1 = "Adobe CreativeSuite 5 Master Collection from cheap 4zp";
        String s2 = "Adobe CreativeSuite 5 Master Collection from cheap d1x";
        NGram ngram = new NGram(4);
        System.out.println(ngram.distance(s1, s2));
        NormalizedLevenshtein l = new NormalizedLevenshtein();
        System.out.println(l.distance("My string", "My $tring"));
        System.out.println(l.distance("My string", "M string2"));
        System.out.println(l.distance("My string", "abcd"));
        QGram dig = new QGram(2);
        System.out.println(dig.distance("ABCD", "ABCE"));
        System.out.println(dig.distance("", "QSDFGHJKLM"));
        System.out.println(dig.distance("Best Deal Ever! Viagra50/100mg - $1.85 071", "Best Deal Ever! Viagra50/100mg - $1.85 7z3"));
        SorensenDice sd = new SorensenDice(2);
        System.out.println(sd.similarity("ABCDE", "ABCDFG"));
        WeightedLevenshtein wl = new WeightedLevenshtein(new CharacterSubstitutionInterface(){

            public double cost(char c1, char c2) {
                if (c1 == 't' && c2 == 'r') {
                    return 0.5;
                }
                return 1.0;
            }
        });
        System.out.println(wl.distance("String1", "Srring2"));
        s1 = "my string,  \n  my song";
        s2 = "another string, from a song";
        KShingling ks = new KShingling(4);
        System.out.println(ks.getProfile(s1));
        System.out.println(ks.getProfile(s2));
        ks = new KShingling(2);
        System.out.println(ks.getProfile("ABCAB"));
    }
}

