/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view.persistence;

import com.google.common.base.Optional;
import com.google.inject.Binder;
import com.google.inject.Module;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ControllerModule;
import id.onyx.obdp.server.orm.PersistenceType;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.view.persistence.SchemaManagerFactory;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.Map;
import java.util.Properties;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class DataStoreModule
implements Module,
SchemaManagerFactory {
    private final ViewInstanceEntity viewInstanceEntity;
    private final DynamicClassLoader classLoader;
    private final EntityManagerFactory entityManagerFactory;
    private final JPADynamicHelper jpaDynamicHelper;
    private static final String VIEWS_PERSISTENCE_UNIT_NAME = "ambari-views";
    private Optional<String> puName = Optional.absent();

    public DataStoreModule(ViewInstanceEntity viewInstanceEntity) {
        ViewEntity view = viewInstanceEntity.getViewEntity();
        this.viewInstanceEntity = viewInstanceEntity;
        this.classLoader = new DynamicClassLoader(view.getClassLoader());
        this.entityManagerFactory = this.getEntityManagerFactory(view.getAmbariConfiguration());
        this.jpaDynamicHelper = new JPADynamicHelper(this.entityManagerFactory.createEntityManager());
    }

    public DataStoreModule(ViewInstanceEntity viewInstanceEntity, String puName) {
        this.puName = Optional.of((Object)puName);
        ViewEntity view = viewInstanceEntity.getViewEntity();
        this.viewInstanceEntity = viewInstanceEntity;
        this.classLoader = new DynamicClassLoader(view.getClassLoader());
        this.entityManagerFactory = this.getEntityManagerFactory(view.getAmbariConfiguration());
        this.jpaDynamicHelper = new JPADynamicHelper(this.entityManagerFactory.createEntityManager());
    }

    public void configure(Binder binder) {
        binder.bind(ViewInstanceEntity.class).toInstance((Object)this.viewInstanceEntity);
        binder.bind(DynamicClassLoader.class).toInstance((Object)this.classLoader);
        binder.bind(EntityManagerFactory.class).toInstance((Object)this.entityManagerFactory);
        binder.bind(JPADynamicHelper.class).toInstance((Object)this.jpaDynamicHelper);
        binder.bind(SchemaManagerFactory.class).toInstance((Object)this);
    }

    public void close() {
        this.entityManagerFactory.close();
    }

    @Override
    public SchemaManager getSchemaManager(DatabaseSession session) {
        return new SchemaManager(session);
    }

    private EntityManagerFactory getEntityManagerFactory(Configuration configuration) {
        Properties persistenceMap = ControllerModule.getPersistenceProperties(configuration);
        if (!configuration.getPersistenceType().equals((Object)PersistenceType.IN_MEMORY)) {
            persistenceMap.put("jakarta.persistence.jdbc.user", configuration.getDatabaseUser());
            persistenceMap.put("jakarta.persistence.jdbc.password", configuration.getDatabasePassword());
            persistenceMap.put("eclipselink.classloader", this.classLoader);
            persistenceMap.put("eclipselink.weaving", "static");
        }
        return Persistence.createEntityManagerFactory((String)(this.puName.isPresent() ? (String)this.puName.get() : VIEWS_PERSISTENCE_UNIT_NAME), (Map)persistenceMap);
    }
}

