/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view.persistence;

import id.onyx.obdp.server.orm.entities.ViewEntityEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.view.persistence.SchemaManagerFactory;
import id.onyx.obdp.view.DataStore;
import id.onyx.obdp.view.PersistenceException;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreImpl
implements DataStore {
    @Inject
    EntityManagerFactory entityManagerFactory;
    @Inject
    DynamicClassLoader classLoader;
    @Inject
    JPADynamicHelper jpaDynamicHelper;
    @Inject
    SchemaManagerFactory schemaManagerFactory;
    @Inject
    ViewInstanceEntity viewInstanceEntity;
    private final Map<Class, String> entityClassMap = new LinkedHashMap<Class, String>();
    private final Map<String, ViewEntityEntity> entityMap = new LinkedHashMap<String, ViewEntityEntity>();
    private final Map<String, JPADynamicTypeBuilder> typeBuilderMap = new LinkedHashMap<String, JPADynamicTypeBuilder>();
    private volatile boolean initialized = false;
    private static final Logger LOG = LoggerFactory.getLogger(DataStoreImpl.class);
    protected static final int MAX_ENTITY_STRING_FIELD_LENGTH = 3000;
    protected static final int MAX_ENTITY_FIELD_LENGTH_TOTAL = 65000;
    private static final String NAME_PREFIX = "DS_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Object entity) throws PersistenceException {
        this.checkInitialize();
        try (EntityManager em = this.getEntityManager();){
            em.getTransaction().begin();
            try {
                DynamicEntity dynamicEntity = this.persistEntity(entity, em, new HashSet<DynamicEntity>());
                em.getTransaction().commit();
                Map<String, Object> props = this.getEntityProperties(entity);
                ArrayList<String> keys = new ArrayList<String>(props.keySet());
                for (String key : keys) {
                    String attribute = this.getAttributeName(key);
                    try {
                        props.put(key, dynamicEntity.get(attribute));
                    }
                    catch (DynamicException de) {
                        LOG.debug("Error occurred while copying entity property : {} : {}", (Object)key, (Object)de);
                    }
                }
                this.setEntityProperties(entity, props);
            }
            catch (Exception e) {
                DataStoreImpl.rollbackTransaction(em.getTransaction());
                DataStoreImpl.throwPersistenceException("Caught exception trying to store view entity " + entity, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) throws PersistenceException {
        block7: {
            this.checkInitialize();
            try (EntityManager em = this.getEntityManager();){
                Class<?> clazz = entity.getClass();
                String id = this.getIdFieldName(clazz);
                DynamicType type = this.getDynamicEntityType(clazz);
                if (type == null) break block7;
                try {
                    Map<String, Object> properties = this.getEntityProperties(entity);
                    DynamicEntity dynamicEntity = (DynamicEntity)em.getReference(type.getJavaClass(), properties.get(id));
                    if (dynamicEntity == null) break block7;
                    em.getTransaction().begin();
                    try {
                        em.remove((Object)dynamicEntity);
                        em.getTransaction().commit();
                    }
                    catch (Exception e) {
                        DataStoreImpl.rollbackTransaction(em.getTransaction());
                        DataStoreImpl.throwPersistenceException("Caught exception trying to remove view entity " + entity, e);
                    }
                }
                catch (Exception e) {
                    DataStoreImpl.throwPersistenceException("Caught exception trying to remove view entity " + entity, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> clazz, Object primaryKey) throws PersistenceException {
        this.checkInitialize();
        try (EntityManager em = this.getEntityManager();){
            DynamicEntity dynamicEntity = null;
            DynamicType type = this.getDynamicEntityType(clazz);
            if (type != null) {
                dynamicEntity = (DynamicEntity)em.find(type.getJavaClass(), primaryKey);
            }
            T t = dynamicEntity == null ? null : (T)this.toEntity(clazz, type, dynamicEntity);
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> findAll(Class<T> clazz, String whereClause) throws PersistenceException {
        this.checkInitialize();
        try (EntityManager em = this.getEntityManager();){
            HashSet<T> resources = new HashSet<T>();
            DynamicType type = this.getDynamicEntityType(clazz);
            if (type != null) {
                try {
                    Query query = em.createQuery(this.getSelectStatement(clazz, whereClause));
                    List dynamicEntities = query.getResultList();
                    for (Object dynamicEntity : dynamicEntities) {
                        resources.add(this.toEntity(clazz, type, (DynamicEntity)dynamicEntity));
                    }
                }
                catch (Exception e) {
                    DataStoreImpl.throwPersistenceException("Caught exception trying to find " + clazz.getName() + " where " + whereClause, e);
                }
            }
            HashSet<T> hashSet = resources;
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialize() throws PersistenceException {
        if (!this.initialized) {
            DataStoreImpl dataStoreImpl = this;
            synchronized (dataStoreImpl) {
                if (!this.initialized) {
                    try {
                        for (ViewEntityEntity viewEntityEntity : this.viewInstanceEntity.getEntities()) {
                            String className = viewEntityEntity.getClassName();
                            Class clazz = this.classLoader.loadClass(className);
                            String name = this.getEntityName(viewEntityEntity);
                            this.entityMap.put(name, viewEntityEntity);
                            this.entityClassMap.put(clazz, name);
                        }
                        this.configureTypes(this.jpaDynamicHelper, this.classLoader);
                        this.initialized = true;
                    }
                    catch (Exception e) {
                        DataStoreImpl.throwPersistenceException("Can't initialize data store for view " + this.viewInstanceEntity.getViewName() + "." + this.viewInstanceEntity.getName(), e);
                    }
                }
            }
        }
    }

    private void configureTypes(JPADynamicHelper helper, DynamicClassLoader dcl) throws IntrospectionException, PersistenceException, NoSuchFieldException {
        String entityName;
        Class clazz;
        JPADynamicTypeBuilder typeBuilder;
        for (Map.Entry<Class, String> entry : this.entityClassMap.entrySet()) {
            String entityName2 = entry.getValue();
            Class javaType = dcl.createDynamicClass(entityName2);
            String tableName = this.getTableName(this.entityMap.get(entityName2));
            typeBuilder = new JPADynamicTypeBuilder(javaType, null, new String[]{tableName});
            this.typeBuilderMap.put(entityName2, typeBuilder);
        }
        ServerSession session = JpaHelper.getEntityManager((EntityManager)this.getEntityManager()).getServerSession();
        for (Map.Entry<Class, String> entry : this.entityClassMap.entrySet()) {
            clazz = entry.getKey();
            entityName = entry.getValue();
            typeBuilder = this.typeBuilderMap.get(entityName);
            String seqName = new String(entityName + "_id_seq").toLowerCase();
            TableSequence tableSequence = new TableSequence(seqName, 50, "ambari_sequences", "sequence_name", "sequence_value");
            session.getLogin().addSequence((Sequence)tableSequence);
            Map<String, PropertyDescriptor> descriptorMap = DataStoreImpl.getDescriptorMap(clazz);
            long totalLength = 0L;
            for (Map.Entry<String, PropertyDescriptor> descriptorEntry : descriptorMap.entrySet()) {
                Class<?> propertyType;
                String fieldName = descriptorEntry.getKey();
                String attributeName = this.getAttributeName(fieldName);
                PropertyDescriptor descriptor = descriptorEntry.getValue();
                if (fieldName.equals(this.entityMap.get(entityName).getIdProperty())) {
                    typeBuilder.setPrimaryKeyFields(new String[]{attributeName});
                    typeBuilder.configureSequencing((Sequence)tableSequence, seqName, attributeName);
                }
                if (!this.isDirectMappingType(propertyType = descriptor.getPropertyType())) continue;
                DirectToFieldMapping mapping = typeBuilder.addDirectMapping(attributeName, propertyType, attributeName);
                DatabaseField field = mapping.getField();
                if (String.class.isAssignableFrom(propertyType)) {
                    field.setLength(3000);
                }
                if ((totalLength += (long)field.getLength()) <= 65000L) continue;
                String msg = String.format("The total length of the fields of the %s entity can not exceed %d characters.", clazz.getSimpleName(), 65000);
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
        }
        for (Map.Entry<Class, String> entry : this.entityClassMap.entrySet()) {
            clazz = entry.getKey();
            entityName = entry.getValue();
            typeBuilder = this.typeBuilderMap.get(entityName);
            Map<String, PropertyDescriptor> descriptorMap = DataStoreImpl.getDescriptorMap(clazz);
            for (Map.Entry<String, PropertyDescriptor> descriptorEntry : descriptorMap.entrySet()) {
                String fieldName = descriptorEntry.getKey();
                String attributeName = this.getAttributeName(fieldName);
                PropertyDescriptor descriptor = descriptorEntry.getValue();
                Class<?> propertyType = descriptor.getPropertyType();
                String refEntityName = this.entityClassMap.get(propertyType);
                if (refEntityName == null) {
                    if (!Collection.class.isAssignableFrom(propertyType)) continue;
                    String tableName = this.getTableName(this.entityMap.get(entityName)) + "_" + attributeName;
                    Class<?> parameterizedTypeClass = DataStoreImpl.getParameterizedTypeClass(clazz, attributeName);
                    refEntityName = this.entityClassMap.get(parameterizedTypeClass);
                    if (refEntityName == null) {
                        typeBuilder.addDirectCollectionMapping(attributeName, tableName, attributeName, parameterizedTypeClass, new String[]{this.entityMap.get(entityName).getIdProperty()});
                        continue;
                    }
                    DynamicType refType = this.typeBuilderMap.get(refEntityName).getType();
                    typeBuilder.addManyToManyMapping(attributeName, refType, tableName);
                    continue;
                }
                DynamicType refType = this.typeBuilderMap.get(refEntityName).getType();
                typeBuilder.addOneToOneMapping(attributeName, refType, new String[]{attributeName});
            }
        }
        DynamicType[] dynamicTypeArray = new DynamicType[this.typeBuilderMap.size()];
        int i = this.typeBuilderMap.size() - 1;
        for (JPADynamicTypeBuilder typeBuilder2 : this.typeBuilderMap.values()) {
            dynamicTypeArray[i--] = typeBuilder2.getType();
        }
        helper.addTypes(true, true, dynamicTypeArray);
        this.schemaManagerFactory.getSchemaManager(helper.getSession()).extendDefaultTables(true);
    }

    private DynamicEntity persistEntity(Object entity, EntityManager em, Set<DynamicEntity> persistSet) throws PersistenceException, IntrospectionException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        DynamicEntity dynamicEntity = null;
        Class<?> clazz = entity.getClass();
        String id = this.getIdFieldName(clazz);
        Map<String, Object> properties = this.getEntityProperties(entity);
        DynamicType type = this.getDynamicEntityType(clazz);
        if (type != null) {
            boolean create;
            if (null != properties.get(id)) {
                dynamicEntity = (DynamicEntity)em.find(type.getJavaClass(), properties.get(id));
            }
            boolean bl = create = dynamicEntity == null;
            if (create) {
                dynamicEntity = type.newDynamicEntity();
            }
            if (persistSet.contains(dynamicEntity)) {
                return dynamicEntity;
            }
            persistSet.add(dynamicEntity);
            for (String attributeName : type.getPropertiesNames()) {
                Object value;
                String fieldName = this.getFieldName(attributeName);
                if (!properties.containsKey(fieldName) || (value = properties.get(fieldName)) == null) continue;
                Class<?> valueClass = value.getClass();
                if (Collection.class.isAssignableFrom(valueClass)) {
                    Class<?> typeClass = DataStoreImpl.getParameterizedTypeClass(clazz, fieldName);
                    Collection collection = (Collection)dynamicEntity.get(attributeName);
                    collection.clear();
                    for (Object collectionValue : (Collection)value) {
                        if (this.getDynamicEntityType(typeClass) != null) {
                            collectionValue = this.persistEntity(collectionValue, em, persistSet);
                        }
                        if (collectionValue == null) continue;
                        collection.add(collectionValue);
                    }
                    continue;
                }
                if (this.getDynamicEntityType(valueClass) != null) {
                    value = this.persistEntity(value, em, persistSet);
                }
                if (value == null) continue;
                if (String.class.isAssignableFrom(valueClass)) {
                    DataStoreImpl.checkStringValue(entity, fieldName, (String)value);
                }
                dynamicEntity.set(attributeName, value);
            }
            if (create) {
                em.persist((Object)dynamicEntity);
            }
        }
        return dynamicEntity;
    }

    private <T> T toEntity(Class<T> clazz, DynamicType type, DynamicEntity entity) throws IntrospectionException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        T resource = clazz.newInstance();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String attributeName : type.getPropertiesNames()) {
            String fieldName = this.getFieldName(attributeName);
            properties.put(fieldName, entity.get(attributeName));
        }
        this.setEntityProperties(resource, properties);
        return resource;
    }

    private <T> String getSelectStatement(Class<T> clazz, String whereClause) throws IntrospectionException {
        StringBuilder stringBuilder = new StringBuilder();
        String entityName = this.entityClassMap.get(clazz);
        stringBuilder.append("SELECT e FROM ").append(entityName).append(" e");
        if (whereClause != null) {
            stringBuilder.append(" WHERE");
            Set<String> propertyNames = DataStoreImpl.getPropertyNames(clazz);
            StringTokenizer tokenizer = new StringTokenizer(whereClause, " \t\n\r\f+-*/=><()\"", true);
            boolean quoted = false;
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (propertyNames.contains(token) && !(quoted ^= token.equals("\""))) {
                    stringBuilder.append(" e.").append(this.getAttributeName(token));
                    continue;
                }
                stringBuilder.append(token);
            }
        }
        return stringBuilder.toString();
    }

    private Map<String, Object> getEntityProperties(Object entity) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (PropertyDescriptor pd : Introspector.getBeanInfo(entity.getClass()).getPropertyDescriptors()) {
            String name = pd.getName();
            Method readMethod = pd.getReadMethod();
            if (readMethod == null) continue;
            properties.put(name, readMethod.invoke(entity, new Object[0]));
        }
        return properties;
    }

    private void setEntityProperties(Object entity, Map<String, Object> properties) throws IntrospectionException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        for (PropertyDescriptor pd : Introspector.getBeanInfo(entity.getClass()).getPropertyDescriptors()) {
            Method writeMethod;
            String name = pd.getName();
            if (!properties.containsKey(name) || (writeMethod = pd.getWriteMethod()) == null) continue;
            Object value = properties.get(name);
            if (value instanceof Collection) {
                HashSet newCollection = new HashSet();
                for (Object collectionValue : (Collection)value) {
                    if (collectionValue instanceof DynamicEntity) {
                        Class<?> clazz = entity.getClass();
                        Class<?> parameterizedTypeClass = DataStoreImpl.getParameterizedTypeClass(clazz, pd.getName());
                        collectionValue = this.toEntity(parameterizedTypeClass, this.getDynamicEntityType(parameterizedTypeClass), (DynamicEntity)collectionValue);
                    }
                    if (collectionValue == null) continue;
                    newCollection.add(collectionValue);
                }
                writeMethod.invoke(entity, newCollection);
                continue;
            }
            if (value instanceof DynamicEntity) {
                Class<?> clazz = pd.getPropertyType();
                value = this.toEntity(clazz, this.getDynamicEntityType(clazz), (DynamicEntity)value);
            }
            if (value == null) continue;
            writeMethod.invoke(entity, value);
        }
    }

    private boolean isDirectMappingType(Class<?> propertyType) {
        return !Collection.class.isAssignableFrom(propertyType) && this.entityClassMap.get(propertyType) == null;
    }

    private DynamicType getDynamicEntityType(Class clazz) {
        JPADynamicTypeBuilder builder = this.typeBuilderMap.get(this.entityClassMap.get(clazz));
        return builder == null ? null : builder.getType();
    }

    private String getIdFieldName(Class clazz) throws PersistenceException {
        String entityName;
        if (this.entityClassMap.containsKey(clazz) && this.entityMap.containsKey(entityName = this.entityClassMap.get(clazz))) {
            return this.entityMap.get(entityName).getIdProperty();
        }
        throw new PersistenceException("The class " + clazz.getName() + "is not registered as an entity.");
    }

    private static Map<String, PropertyDescriptor> getDescriptorMap(Class<?> clazz) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> descriptorMap = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            String name = pd.getName();
            if (pd.getReadMethod() == null || name.equals("class")) continue;
            descriptorMap.put(name, pd);
        }
        return descriptorMap;
    }

    private static Set<String> getPropertyNames(Class clazz) throws IntrospectionException {
        HashSet<String> propertyNames = new HashSet<String>();
        for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            propertyNames.add(pd.getName());
        }
        return propertyNames;
    }

    private static Class<?> getParameterizedTypeClass(Class clazz, String fieldName) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(fieldName);
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    private static void checkStringValue(Object entity, String fieldName, String value) {
        if (value.length() > 3000) {
            String msg = String.format("The value for the %s field of the %s entity can not exceed %d characters.  Given value = %s", fieldName, entity.getClass().getSimpleName(), 3000, value);
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
    }

    private static void rollbackTransaction(EntityTransaction transaction) {
        if (transaction != null && transaction.isActive()) {
            transaction.rollback();
        }
    }

    private static void throwPersistenceException(String msg, Exception e) throws PersistenceException {
        LOG.error(msg, (Throwable)e);
        throw new PersistenceException(msg, (Throwable)e);
    }

    private String getTableName(ViewEntityEntity entity) {
        return this.getEntityName(entity).toUpperCase();
    }

    private String getFieldName(String attributeName) {
        return this.alterNames() ? attributeName.substring(NAME_PREFIX.length()) : attributeName;
    }

    private String getAttributeName(String fieldName) {
        return this.alterNames() ? NAME_PREFIX + fieldName : fieldName;
    }

    private String getEntityName(ViewEntityEntity entity) {
        String className = entity.getClassName();
        String[] parts = className.split("\\.");
        String simpleClassName = parts[parts.length - 1];
        if (this.alterNames()) {
            return NAME_PREFIX + simpleClassName + "_" + entity.getId();
        }
        return simpleClassName + entity.getId();
    }

    private EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    private boolean alterNames() {
        return this.viewInstanceEntity.alterNames();
    }
}

