/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view.configuration;

import id.onyx.obdp.server.view.DefaultMasker;
import id.onyx.obdp.server.view.configuration.AutoInstanceConfig;
import id.onyx.obdp.server.view.configuration.InstanceConfig;
import id.onyx.obdp.server.view.configuration.ParameterConfig;
import id.onyx.obdp.server.view.configuration.PermissionConfig;
import id.onyx.obdp.server.view.configuration.PersistenceConfig;
import id.onyx.obdp.server.view.configuration.ResourceConfig;
import id.onyx.obdp.view.Masker;
import id.onyx.obdp.view.View;
import id.onyx.obdp.view.migration.ViewDataMigrator;
import id.onyx.obdp.view.validation.Validator;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="view")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ViewConfig {
    private String name;
    private String label;
    private String description;
    private String version;
    private String build;
    @XmlElement(name="min-ambari-version")
    private String minAmbariVersion;
    @XmlElement(name="max-ambari-version")
    private String maxAmbariVersion;
    private String icon;
    private String icon64;
    private boolean system;
    @XmlElementWrapper
    @XmlElement(name="path")
    private List<String> classpath;
    @XmlElement(name="view-class")
    private String view;
    private Class<? extends View> viewClass = null;
    @XmlElement(name="data-migrator-class")
    private String dataMigrator;
    @XmlElement(name="data-version")
    private String dataVersion;
    @XmlElement(name="cluster-config-options")
    private String clusterConfigOptions;
    private Class<? extends ViewDataMigrator> dataMigratorClass = null;
    @XmlElement(name="validator-class")
    private String validator;
    private Class<? extends Validator> validatorClass = null;
    @XmlElement(name="masker-class")
    private String masker;
    private Class<? extends Masker> maskerClass = null;
    @XmlElement(name="parameter")
    private List<ParameterConfig> parameters;
    @XmlElement(name="resource")
    private List<ResourceConfig> resources;
    @XmlElement(name="auto-instance")
    private AutoInstanceConfig autoInstance;
    @XmlElement(name="instance")
    private List<InstanceConfig> instances;
    @XmlElement(name="persistence")
    private PersistenceConfig persistence;
    @XmlElement(name="permission")
    private List<PermissionConfig> permissions;

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    public String getMinAmbariVersion() {
        return this.minAmbariVersion;
    }

    public String getMaxAmbariVersion() {
        return this.maxAmbariVersion;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getIcon64() {
        return this.icon64;
    }

    public boolean isSystem() {
        return this.system;
    }

    public String getExtraClasspath() {
        return this.classpath == null ? null : StringUtils.join(this.classpath, (String)",");
    }

    public String getView() {
        return this.view;
    }

    public Class<? extends View> getViewClass(ClassLoader cl) throws ClassNotFoundException {
        if (this.viewClass == null) {
            this.viewClass = cl.loadClass(this.view).asSubclass(View.class);
        }
        return this.viewClass;
    }

    public String getDataMigrator() {
        return this.dataMigrator;
    }

    public Class<? extends ViewDataMigrator> getDataMigratorClass(ClassLoader cl) throws ClassNotFoundException {
        if (this.dataMigratorClass == null) {
            this.dataMigratorClass = cl.loadClass(this.dataMigrator).asSubclass(ViewDataMigrator.class);
        }
        return this.dataMigratorClass;
    }

    public int getDataVersion() {
        return this.dataVersion == null ? 0 : Integer.parseInt(this.dataVersion);
    }

    public String getValidator() {
        return this.validator;
    }

    public Class<? extends Validator> getValidatorClass(ClassLoader cl) throws ClassNotFoundException {
        if (this.validatorClass == null) {
            this.validatorClass = cl.loadClass(this.validator).asSubclass(Validator.class);
        }
        return this.validatorClass;
    }

    public String getMasker() {
        return this.masker;
    }

    public Class<? extends Masker> getMaskerClass(ClassLoader cl) throws ClassNotFoundException {
        if (this.maskerClass == null) {
            this.maskerClass = StringUtils.isBlank((String)this.masker) ? DefaultMasker.class : cl.loadClass(this.masker).asSubclass(Masker.class);
        }
        return this.maskerClass;
    }

    public List<ParameterConfig> getParameters() {
        return this.parameters == null ? Collections.emptyList() : this.parameters;
    }

    public List<ResourceConfig> getResources() {
        return this.resources == null ? Collections.emptyList() : this.resources;
    }

    public AutoInstanceConfig getAutoInstance() {
        return this.autoInstance;
    }

    public List<InstanceConfig> getInstances() {
        return this.instances == null ? Collections.emptyList() : this.instances;
    }

    public PersistenceConfig getPersistence() {
        return this.persistence;
    }

    public List<PermissionConfig> getPermissions() {
        return this.permissions == null ? Collections.emptyList() : this.permissions;
    }

    public String getClusterConfigOptions() {
        return this.clusterConfigOptions;
    }
}

