/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.proxy.ProxyService;
import id.onyx.obdp.server.view.ViewContextImpl;
import id.onyx.obdp.view.URLConnectionProvider;
import id.onyx.obdp.view.URLStreamProvider;
import id.onyx.obdp.view.ViewContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewURLStreamProvider
implements URLStreamProvider,
URLConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ViewContextImpl.class);
    private static final String DO_AS_PARAM = "doAs";
    private final ViewContext viewContext;
    private final id.onyx.obdp.server.controller.internal.URLStreamProvider streamProvider;
    private HostPortRestrictionHandler hostPortRestrictionHandler;

    protected ViewURLStreamProvider(ViewContext viewContext, id.onyx.obdp.server.controller.internal.URLStreamProvider streamProvider) {
        this.viewContext = viewContext;
        this.streamProvider = streamProvider;
    }

    private HostPortRestrictionHandler getHostPortRestrictionHandler() {
        if (this.hostPortRestrictionHandler == null) {
            HostPortRestrictionHandler hostPortRestrictionHandlerTmp;
            this.hostPortRestrictionHandler = hostPortRestrictionHandlerTmp = new HostPortRestrictionHandler(this.viewContext.getAmbariProperty(Configuration.PROXY_ALLOWED_HOST_PORTS.getKey()));
        }
        return this.hostPortRestrictionHandler;
    }

    public InputStream readFrom(String spec, String requestMethod, String body, Map<String, String> headers) throws IOException {
        return this.getInputStream(spec, requestMethod, headers, body == null ? null : body.getBytes());
    }

    public InputStream readFrom(String spec, String requestMethod, InputStream body, Map<String, String> headers) throws IOException {
        return this.getInputStream(spec, requestMethod, headers, body == null ? null : IOUtils.toByteArray((InputStream)body));
    }

    public InputStream readAs(String spec, String requestMethod, String body, Map<String, String> headers, String userName) throws IOException {
        return this.readFrom(this.addDoAs(spec, userName), requestMethod, body, headers);
    }

    public InputStream readAs(String spec, String requestMethod, InputStream body, Map<String, String> headers, String userName) throws IOException {
        return this.readFrom(this.addDoAs(spec, userName), requestMethod, body, headers);
    }

    public InputStream readAsCurrent(String spec, String requestMethod, String body, Map<String, String> headers) throws IOException {
        return this.readAs(spec, requestMethod, body, headers, this.viewContext.getUsername());
    }

    public InputStream readAsCurrent(String spec, String requestMethod, InputStream body, Map<String, String> headers) throws IOException {
        return this.readAs(spec, requestMethod, body, headers, this.viewContext.getUsername());
    }

    public HttpURLConnection getConnection(String spec, String requestMethod, String body, Map<String, String> headers) throws IOException {
        return this.getHttpURLConnection(spec, requestMethod, headers, body == null ? null : body.getBytes());
    }

    public HttpURLConnection getConnection(String spec, String requestMethod, InputStream body, Map<String, String> headers) throws IOException {
        return this.getHttpURLConnection(spec, requestMethod, headers, body == null ? null : IOUtils.toByteArray((InputStream)body));
    }

    public HttpURLConnection getConnectionAs(String spec, String requestMethod, String body, Map<String, String> headers, String userName) throws IOException {
        return this.getConnection(this.addDoAs(spec, userName), requestMethod, body, headers);
    }

    public HttpURLConnection getConnectionAs(String spec, String requestMethod, InputStream body, Map<String, String> headers, String userName) throws IOException {
        return this.getConnection(this.addDoAs(spec, userName), requestMethod, body, headers);
    }

    public HttpURLConnection getConnectionAsCurrent(String spec, String requestMethod, String body, Map<String, String> headers) throws IOException {
        return this.getConnectionAs(spec, requestMethod, body, headers, this.viewContext.getUsername());
    }

    public HttpURLConnection getConnectionAsCurrent(String spec, String requestMethod, InputStream body, Map<String, String> headers) throws IOException {
        return this.getConnectionAs(spec, requestMethod, body, headers, this.viewContext.getUsername());
    }

    private String addDoAs(String spec, String userName) throws IOException {
        if (spec.toLowerCase().contains(DO_AS_PARAM)) {
            throw new IllegalArgumentException("URL cannot contain \"doAs\" parameter.");
        }
        try {
            URIBuilder builder = new URIBuilder(spec);
            builder.addParameter(DO_AS_PARAM, userName);
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private InputStream getInputStream(String spec, String requestMethod, Map<String, String> headers, byte[] info) throws IOException {
        if (!this.isProxyCallAllowed(spec)) {
            LOG.warn("Call to " + spec + " is not allowed. See obdp.properties proxy.allowed.hostports.");
            throw new IOException("Call to " + spec + " is not allowed. See obdp.properties proxy.allowed.hostports.");
        }
        HttpURLConnection connection = this.getHttpURLConnection(spec, requestMethod, headers, info);
        int responseCode = connection.getResponseCode();
        return responseCode >= ProxyService.HTTP_ERROR_RANGE_START ? connection.getErrorStream() : connection.getInputStream();
    }

    private HttpURLConnection getHttpURLConnection(String spec, String requestMethod, Map<String, String> headers, byte[] info) throws IOException {
        if (!this.isProxyCallAllowed(spec)) {
            LOG.warn("Call to " + spec + " is not allowed. See obdp.properties proxy.allowed.hostports.");
            throw new IOException("Call to " + spec + " is not allowed. See obdp.properties proxy.allowed.hostports.");
        }
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            headerMap.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        return this.streamProvider.processURL(spec, requestMethod, info, headerMap);
    }

    protected boolean isProxyCallAllowed(String spec) {
        if (StringUtils.isNotBlank((String)spec) && this.getHostPortRestrictionHandler().proxyCallRestricted().booleanValue()) {
            try {
                URL url = new URL(spec);
                return this.getHostPortRestrictionHandler().allowProxy(url.getHost(), Integer.toString(url.getPort() == -1 ? url.getDefaultPort() : url.getPort()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return true;
    }

    class HostPortRestrictionHandler {
        private final String allowedHostPortsValue;
        private Map<String, HashSet<String>> allowedHostPorts = null;
        private Boolean isProxyCallRestricted = Boolean.FALSE;

        public HostPortRestrictionHandler(String allowedHostPortsValue) {
            this.allowedHostPortsValue = allowedHostPortsValue;
            LOG.debug("Proxy restriction will be derived from {}", (Object)allowedHostPortsValue);
        }

        public boolean allowProxy(String host, String port) {
            LOG.debug("Checking host {} port {} against allowed list.", (Object)host, (Object)port);
            if (StringUtils.isNotBlank((String)host)) {
                String hostToCompare = host.trim().toLowerCase();
                if (this.allowedHostPorts == null) {
                    this.initializeAllowedHostPorts();
                }
                if (this.isProxyCallRestricted.booleanValue()) {
                    if (this.allowedHostPorts.containsKey(hostToCompare)) {
                        if (this.allowedHostPorts.get(hostToCompare).contains("*")) {
                            return true;
                        }
                        String portToCompare = "";
                        if (StringUtils.isNotBlank((String)port)) {
                            portToCompare = port.trim();
                        }
                        return this.allowedHostPorts.get(hostToCompare).contains(portToCompare);
                    }
                    return false;
                }
            }
            return true;
        }

        private void initializeAllowedHostPorts() {
            String allowedStr;
            boolean proxyCallRestricted = false;
            HashMap<String, HashSet<String>> allowed = new HashMap<String, HashSet<String>>();
            if (StringUtils.isNotBlank((String)this.allowedHostPortsValue) && !(allowedStr = this.allowedHostPortsValue.toLowerCase()).equals(Configuration.PROXY_ALLOWED_HOST_PORTS.getDefaultValue())) {
                String[] hostPorts;
                proxyCallRestricted = true;
                for (String hostPortStr : hostPorts = allowedStr.trim().split(",")) {
                    String[] hostAndPort = hostPortStr.trim().split(":");
                    if (hostAndPort.length == 1) {
                        if (!allowed.containsKey(hostAndPort[0])) {
                            allowed.put(hostAndPort[0], new HashSet());
                        }
                        ((HashSet)allowed.get(hostAndPort[0])).add("*");
                        LOG.debug("Allow proxy to host {} and all ports.", (Object)hostAndPort[0]);
                        continue;
                    }
                    if (!allowed.containsKey(hostAndPort[0])) {
                        allowed.put(hostAndPort[0], new HashSet());
                    }
                    ((HashSet)allowed.get(hostAndPort[0])).add(hostAndPort[1]);
                    LOG.debug("Allow proxy to host {} and port {}", (Object)hostAndPort[0], (Object)hostAndPort[1]);
                }
            }
            this.allowedHostPorts = allowed;
            this.isProxyCallRestricted = proxyCallRestricted;
        }

        public Boolean proxyCallRestricted() {
            if (this.allowedHostPorts == null) {
                this.initializeAllowedHostPorts();
            }
            return this.isProxyCallRestricted;
        }
    }
}

