/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ViewThrottleFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ViewThrottleFilter.class);
    @Inject
    private Configuration m_configuration;
    private Semaphore m_semaphore;
    private int m_timeout;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_timeout = this.m_configuration.getViewRequestThreadPoolTimeout();
        int clientThreadPoolSize = this.m_configuration.getClientThreadPoolSize();
        int viewThreadPoolSize = this.m_configuration.getViewRequestThreadPoolMaxSize();
        int viewSemaphoreCount = clientThreadPoolSize / 2;
        if (viewThreadPoolSize > 0) {
            viewSemaphoreCount = viewThreadPoolSize;
            if (viewThreadPoolSize > clientThreadPoolSize) {
                LOG.warn("The number of view processing threads ({}) cannot be greater than the REST API client threads {{})", (Object)viewThreadPoolSize, (Object)clientThreadPoolSize);
                viewSemaphoreCount = clientThreadPoolSize;
            }
        }
        LOG.info("Ambari Views will be able to utilize {} concurrent REST API threads", (Object)viewSemaphoreCount);
        this.m_semaphore = new Semaphore(viewSemaphoreCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean acquired = false;
        try {
            acquired = this.m_semaphore.tryAcquire(this.m_timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            LOG.warn("While waiting for an available thread, the view request was interrupted");
        }
        if (!acquired) {
            httpResponse.sendError(503, "There are no available threads to handle view requests");
            return;
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.m_semaphore.release();
        }
    }

    public void destroy() {
    }
}

