/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.view.NoSuchResourceException;
import id.onyx.obdp.view.ReadRequest;
import id.onyx.obdp.view.ResourceAlreadyExistsException;
import id.onyx.obdp.view.ResourceProvider;
import id.onyx.obdp.view.UnsupportedPropertyException;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewSubResourceProvider
extends AbstractResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ViewSubResourceProvider.class);
    private static final String VIEW_NAME_PROPERTY_ID = "view_name";
    private static final String VIEW_VERSION_PROPERTY_ID = "version";
    private static final String INSTANCE_NAME_PROPERTY_ID = "instance_name";
    private final ViewEntity viewDefinition;
    private final String pkField;
    private final Resource.Type type;
    private final Map<String, PropertyDescriptor> descriptorMap;
    private final Set<String> pkPropertyIds;

    public ViewSubResourceProvider(Resource.Type type, Class<?> clazz, String pkField, ViewEntity viewDefinition) throws IntrospectionException {
        super(ViewSubResourceProvider.discoverPropertyIds(clazz), ViewSubResourceProvider.getKeyPropertyIds(pkField, type));
        this.pkField = pkField;
        this.viewDefinition = viewDefinition;
        this.pkPropertyIds = new HashSet<String>(this.getKeyPropertyIds().values());
        this.type = type;
        this.descriptorMap = ViewSubResourceProvider.getDescriptorMap(clazz);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, id.onyx.obdp.server.controller.spi.UnsupportedPropertyException, id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException, NoSuchParentResourceException {
        Set<Map<String, Object>> properties = request.getProperties();
        for (Map<String, Object> propertyMap : properties) {
            String resourceId = (String)propertyMap.get(this.pkField);
            String instanceName = (String)propertyMap.get(INSTANCE_NAME_PROPERTY_ID);
            try {
                this.getResourceProvider(instanceName).createResource(resourceId, propertyMap);
            }
            catch (NoSuchResourceException e) {
                throw new NoSuchParentResourceException(e.getMessage(), e);
            }
            catch (UnsupportedPropertyException e) {
                throw new id.onyx.obdp.server.controller.spi.UnsupportedPropertyException(this.getResourceType(e), e.getPropertyIds());
            }
            catch (ResourceAlreadyExistsException e) {
                throw new id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException(e.getMessage());
            }
            catch (Exception e) {
                LOG.error("Caught exception creating view sub resources.", (Throwable)e);
                throw new SystemException(e.getMessage(), e);
            }
        }
        return new RequestStatusImpl(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, id.onyx.obdp.server.controller.spi.UnsupportedPropertyException, id.onyx.obdp.server.controller.spi.NoSuchResourceException, NoSuchParentResourceException {
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<ViewInstanceEntity> instanceDefinitions = new HashSet<ViewInstanceEntity>();
        try {
            Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
            int size = propertyMaps.size();
            Collection<ViewInstanceEntity> viewInstanceDefinitions = this.viewDefinition.getInstances();
            if (size == 0) {
                instanceDefinitions.addAll(viewInstanceDefinitions);
            } else {
                for (Map<String, Object> propertyMap : propertyMaps) {
                    String resourceId;
                    String instanceName = (String)propertyMap.get(INSTANCE_NAME_PROPERTY_ID);
                    if (size == 1 && instanceName != null && (resourceId = (String)propertyMap.get(this.pkField)) != null) {
                        Object bean = this.getResourceProvider(instanceName).getResource(resourceId, requestedIds);
                        return Collections.singleton(this.getResource(bean, this.viewDefinition.getCommonName(), this.viewDefinition.getVersion(), instanceName, requestedIds));
                    }
                    if (instanceName == null) {
                        instanceDefinitions.addAll(viewInstanceDefinitions);
                        break;
                    }
                    ViewInstanceEntity instanceDefinition = this.viewDefinition.getInstanceDefinition(instanceName);
                    if (instanceDefinition == null) continue;
                    instanceDefinitions.add(instanceDefinition);
                }
            }
            HashSet<Resource> results = new HashSet<Resource>();
            ViewReadRequest readRequest = new ViewReadRequest(request, requestedIds, predicate == null ? "" : predicate.toString());
            for (ViewInstanceEntity instanceDefinition : instanceDefinitions) {
                Set beans = instanceDefinition.getResourceProvider(this.type).getResources((ReadRequest)readRequest);
                for (Object bean : beans) {
                    Resource resource = this.getResource(bean, this.viewDefinition.getCommonName(), this.viewDefinition.getVersion(), instanceDefinition.getName(), requestedIds);
                    if (!predicate.evaluate(resource)) continue;
                    results.add(resource);
                }
            }
            return results;
        }
        catch (NoSuchResourceException e) {
            throw new NoSuchParentResourceException(e.getMessage(), e);
        }
        catch (UnsupportedPropertyException e) {
            throw new id.onyx.obdp.server.controller.spi.UnsupportedPropertyException(this.getResourceType(e), e.getPropertyIds());
        }
        catch (Exception e) {
            LOG.error("Caught exception getting view sub resources.", (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, id.onyx.obdp.server.controller.spi.UnsupportedPropertyException, id.onyx.obdp.server.controller.spi.NoSuchResourceException, NoSuchParentResourceException {
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            Map<String, Object> propertyMap = iterator.next();
            Set<Resource> resources = this.getResources(request, predicate);
            for (Resource resource : resources) {
                String resourceId = (String)resource.getPropertyValue(this.pkField);
                String instanceName = (String)resource.getPropertyValue(INSTANCE_NAME_PROPERTY_ID);
                try {
                    this.getResourceProvider(instanceName).updateResource(resourceId, propertyMap);
                }
                catch (NoSuchResourceException e) {
                    throw new NoSuchParentResourceException(e.getMessage(), e);
                }
                catch (UnsupportedPropertyException e) {
                    throw new id.onyx.obdp.server.controller.spi.UnsupportedPropertyException(this.getResourceType(e), e.getPropertyIds());
                }
                catch (Exception e) {
                    LOG.error("Caught exception updating view sub resources.", (Throwable)e);
                    throw new SystemException(e.getMessage(), e);
                }
            }
        }
        return new RequestStatusImpl(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, id.onyx.obdp.server.controller.spi.UnsupportedPropertyException, id.onyx.obdp.server.controller.spi.NoSuchResourceException, NoSuchParentResourceException {
        Set<Resource> resources = this.getResources(PropertyHelper.getReadRequest(new String[0]), predicate);
        for (Resource resource : resources) {
            String resourceId = (String)resource.getPropertyValue(this.pkField);
            String instanceName = (String)resource.getPropertyValue(INSTANCE_NAME_PROPERTY_ID);
            try {
                this.getResourceProvider(instanceName).deleteResource(resourceId);
            }
            catch (NoSuchResourceException e) {
                throw new NoSuchParentResourceException(e.getMessage(), e);
            }
            catch (UnsupportedPropertyException e) {
                throw new id.onyx.obdp.server.controller.spi.UnsupportedPropertyException(this.getResourceType(e), e.getPropertyIds());
            }
            catch (Exception e) {
                LOG.error("Caught exception deleting view sub resources.", (Throwable)e);
                throw new SystemException(e.getMessage(), e);
            }
        }
        return new RequestStatusImpl(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return this.pkPropertyIds;
    }

    private Resource getResource(Object bean, String viewName, String viewVersion, String instanceName, Set<String> requestedIds) throws InvocationTargetException, IllegalAccessException {
        ResourceImpl resource = new ResourceImpl(this.type);
        resource.setProperty(VIEW_NAME_PROPERTY_ID, viewName);
        resource.setProperty(VIEW_VERSION_PROPERTY_ID, viewVersion);
        resource.setProperty(INSTANCE_NAME_PROPERTY_ID, instanceName);
        for (Map.Entry<String, PropertyDescriptor> entry : this.descriptorMap.entrySet()) {
            Object value = entry.getValue().getReadMethod().invoke(bean, new Object[0]);
            ViewSubResourceProvider.setResourceProperty(resource, entry.getKey(), value, requestedIds);
        }
        return resource;
    }

    private ResourceProvider<?> getResourceProvider(String instanceName) {
        return this.viewDefinition.getInstanceDefinition(instanceName).getResourceProvider(this.type);
    }

    private Resource.Type getResourceType(UnsupportedPropertyException e) {
        return Resource.Type.valueOf(e.getType());
    }

    private static Set<String> discoverPropertyIds(Class<?> clazz) throws IntrospectionException {
        HashSet<String> propertyIds = new HashSet<String>(ViewSubResourceProvider.getDescriptorMap(clazz).keySet());
        propertyIds.add(INSTANCE_NAME_PROPERTY_ID);
        propertyIds.add(VIEW_NAME_PROPERTY_ID);
        propertyIds.add(VIEW_VERSION_PROPERTY_ID);
        return propertyIds;
    }

    private static Map<String, PropertyDescriptor> getDescriptorMap(Class<?> clazz) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> descriptorMap = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            String name = pd.getName();
            if (pd.getReadMethod() == null || name.equals("class")) continue;
            descriptorMap.put(name, pd);
        }
        return descriptorMap;
    }

    private static Map<Resource.Type, String> getKeyPropertyIds(String pkField, Resource.Type type) {
        HashMap<Resource.Type, String> keyPropertyIds = new HashMap<Resource.Type, String>();
        keyPropertyIds.put(Resource.Type.View, VIEW_NAME_PROPERTY_ID);
        keyPropertyIds.put(Resource.Type.ViewVersion, VIEW_VERSION_PROPERTY_ID);
        keyPropertyIds.put(Resource.Type.ViewInstance, INSTANCE_NAME_PROPERTY_ID);
        keyPropertyIds.put(type, pkField);
        return keyPropertyIds;
    }

    private static class ViewReadRequest
    implements ReadRequest {
        private final Request request;
        private final Set<String> propertyIds;
        private final String predicate;

        private ViewReadRequest(Request request, Set<String> propertyIds, String predicate) {
            this.request = request;
            this.propertyIds = propertyIds;
            this.predicate = predicate;
        }

        public Set<String> getPropertyIds() {
            return this.propertyIds;
        }

        public String getPredicate() {
            return this.predicate;
        }

        public ReadRequest.TemporalInfo getTemporalInfo(String id) {
            TemporalInfo temporalInfo = this.request.getTemporalInfo(id);
            return temporalInfo == null ? null : new ViewReadRequestTemporalInfo(temporalInfo);
        }
    }

    private static class ViewReadRequestTemporalInfo
    implements ReadRequest.TemporalInfo {
        private final TemporalInfo temporalInfo;

        private ViewReadRequestTemporalInfo(TemporalInfo temporalInfo) {
            this.temporalInfo = temporalInfo;
        }

        public Long getStartTime() {
            return this.temporalInfo.getStartTime();
        }

        public Long getEndTime() {
            return this.temporalInfo.getEndTime();
        }

        public Long getStep() {
            return this.temporalInfo.getStep();
        }
    }
}

