/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.view.configuration.ResourceConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ViewSubResourceDefinition
extends BaseResourceDefinition {
    private final ViewEntity viewDefinition;
    private final ResourceConfig resourceConfiguration;
    Set<SubResourceDefinition> definitions;

    public ViewSubResourceDefinition(ViewEntity viewDefinition, ResourceConfig resourceConfiguration) {
        super(new Resource.Type(viewDefinition.getQualifiedResourceTypeName(resourceConfiguration.getName())));
        this.viewDefinition = viewDefinition;
        this.resourceConfiguration = resourceConfiguration;
    }

    @Override
    public String getPluralName() {
        return this.resourceConfiguration.getPluralName();
    }

    @Override
    public String getSingularName() {
        return this.resourceConfiguration.getName();
    }

    @Override
    public synchronized Set<SubResourceDefinition> getSubResourceDefinitions() {
        if (this.definitions == null) {
            this.definitions = new HashSet<SubResourceDefinition>();
            List<String> subResourceNames = this.resourceConfiguration.getSubResourceNames();
            if (subResourceNames != null) {
                for (String subType : subResourceNames) {
                    Resource.Type type = Resource.Type.valueOf(this.viewDefinition.getQualifiedResourceTypeName(subType));
                    this.definitions.add(new SubResourceDefinition(type));
                }
            }
        }
        return this.definitions;
    }

    public ResourceConfig getResourceConfiguration() {
        return this.resourceConfiguration;
    }
}

