/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.resources.ResourceInstanceFactoryImpl;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.api.resources.ViewExternalSubResourceDefinition;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.api.services.views.ViewExternalSubResourceService;
import id.onyx.obdp.server.api.services.views.ViewSubResourceService;
import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.OBDPSessionManager;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.events.ClusterConfigFinishedEvent;
import id.onyx.obdp.server.events.ServiceInstalledEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.MemberDAO;
import id.onyx.obdp.server.orm.dao.PermissionDAO;
import id.onyx.obdp.server.orm.dao.PrincipalDAO;
import id.onyx.obdp.server.orm.dao.PrivilegeDAO;
import id.onyx.obdp.server.orm.dao.RemoteOBDPClusterDAO;
import id.onyx.obdp.server.orm.dao.ResourceDAO;
import id.onyx.obdp.server.orm.dao.ResourceTypeDAO;
import id.onyx.obdp.server.orm.dao.UserDAO;
import id.onyx.obdp.server.orm.dao.ViewDAO;
import id.onyx.obdp.server.orm.dao.ViewInstanceDAO;
import id.onyx.obdp.server.orm.dao.ViewURLDAO;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.MemberEntity;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.RemoteOBDPClusterEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewEntityEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceDataEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.orm.entities.ViewInstancePropertyEntity;
import id.onyx.obdp.server.orm.entities.ViewParameterEntity;
import id.onyx.obdp.server.orm.entities.ViewResourceEntity;
import id.onyx.obdp.server.orm.entities.ViewURLEntity;
import id.onyx.obdp.server.security.SecurityHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.stack.OsFamily;
import id.onyx.obdp.server.utils.Closeables;
import id.onyx.obdp.server.utils.VersionUtils;
import id.onyx.obdp.server.view.ClusterImpl;
import id.onyx.obdp.server.view.IllegalClusterException;
import id.onyx.obdp.server.view.RemoteAmbariStreamProvider;
import id.onyx.obdp.server.view.RemoteOBDPClusterRegistry;
import id.onyx.obdp.server.view.ViewAmbariStreamProvider;
import id.onyx.obdp.server.view.ViewArchiveUtility;
import id.onyx.obdp.server.view.ViewContextImpl;
import id.onyx.obdp.server.view.ViewDataMigrationUtility;
import id.onyx.obdp.server.view.ViewExternalSubResourceProvider;
import id.onyx.obdp.server.view.ViewExtractor;
import id.onyx.obdp.server.view.ViewInstanceHandlerList;
import id.onyx.obdp.server.view.ViewInstanceOperationHandler;
import id.onyx.obdp.server.view.ViewSubResourceDefinition;
import id.onyx.obdp.server.view.ViewSubResourceProvider;
import id.onyx.obdp.server.view.ViewURLStreamProvider;
import id.onyx.obdp.server.view.configuration.AutoInstanceConfig;
import id.onyx.obdp.server.view.configuration.EntityConfig;
import id.onyx.obdp.server.view.configuration.InstanceConfig;
import id.onyx.obdp.server.view.configuration.ParameterConfig;
import id.onyx.obdp.server.view.configuration.PermissionConfig;
import id.onyx.obdp.server.view.configuration.PersistenceConfig;
import id.onyx.obdp.server.view.configuration.PropertyConfig;
import id.onyx.obdp.server.view.configuration.ResourceConfig;
import id.onyx.obdp.server.view.configuration.ViewConfig;
import id.onyx.obdp.server.view.validation.ValidationException;
import id.onyx.obdp.view.AmbariStreamProvider;
import id.onyx.obdp.view.ClusterType;
import id.onyx.obdp.view.Masker;
import id.onyx.obdp.view.ResourceProvider;
import id.onyx.obdp.view.SystemException;
import id.onyx.obdp.view.View;
import id.onyx.obdp.view.ViewContext;
import id.onyx.obdp.view.ViewDefinition;
import id.onyx.obdp.view.ViewInstanceDefinition;
import id.onyx.obdp.view.ViewResourceHandler;
import id.onyx.obdp.view.cluster.Cluster;
import id.onyx.obdp.view.events.Event;
import id.onyx.obdp.view.events.Listener;
import id.onyx.obdp.view.migration.ViewDataMigrationException;
import id.onyx.obdp.view.validation.Validator;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.beans.IntrospectionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Singleton
public class ViewRegistry {
    private static final String EXTRACTED_ARCHIVES_DIR = "work";
    private static final String EXTRACT_COMMAND = "extract";
    private static final String ALL_VIEWS_REG_EXP = ".*";
    protected static final int DEFAULT_REQUEST_CONNECT_TIMEOUT = 5000;
    protected static final int DEFAULT_REQUEST_READ_TIMEOUT = 10000;
    private static final String VIEW_OBDP_VERSION_REGEXP = "^((\\d+\\.)?)*(\\*|\\d+)$";
    private static final String VIEW_LOG_FILE = "view.log4j.properties";
    private static final String OBDP_LOG_FILE = "log4j.properties";
    private static final String LOG4J = "log4j.";
    public static final String API_PREFIX = "/api/v1/clusters/";
    public static final String DEFAULT_AUTO_INSTANCE_URL = "auto_instance";
    private static ExecutorService executorService;
    private Map<String, ViewEntity> viewDefinitions = new HashMap<String, ViewEntity>();
    private Map<ViewEntity, Map<String, ViewInstanceEntity>> viewInstanceDefinitions = new HashMap<ViewEntity, Map<String, ViewInstanceEntity>>();
    private final Map<String, Set<SubResourceDefinition>> subResourceDefinitionsMap = new ConcurrentHashMap<String, Set<SubResourceDefinition>>();
    private final Map<Resource.Type, id.onyx.obdp.server.controller.spi.ResourceProvider> resourceProviders = new ConcurrentHashMap<Resource.Type, id.onyx.obdp.server.controller.spi.ResourceProvider>();
    private final Map<String, Set<Listener>> listeners = new ConcurrentHashMap<String, Set<Listener>>();
    private static ViewRegistry singleton;
    private static final Logger LOG;
    protected ViewDataMigrationUtility viewDataMigrationUtility;
    @Inject
    ViewDAO viewDAO;
    @Inject
    ViewInstanceDAO instanceDAO;
    @Inject
    UserDAO userDAO;
    @Inject
    MemberDAO memberDAO;
    @Inject
    PrivilegeDAO privilegeDAO;
    @Inject
    SecurityHelper securityHelper;
    @Inject
    ResourceDAO resourceDAO;
    @Inject
    ResourceTypeDAO resourceTypeDAO;
    @Inject
    PrincipalDAO principalDAO;
    @Inject
    PermissionDAO permissionDAO;
    @Inject
    Provider<Clusters> clustersProvider;
    @Inject
    Provider<OBDPMetaInfo> ambariMetaInfoProvider;
    @Inject
    Configuration configuration;
    @Inject
    ViewInstanceHandlerList handlerList;
    @Inject
    ViewExtractor extractor;
    @Inject
    ViewArchiveUtility archiveUtility;
    @Inject
    OBDPSessionManager ambariSessionManager;
    @Inject
    RemoteOBDPClusterRegistry remoteOBDPClusterRegistry;
    @Inject
    RemoteOBDPClusterDAO remoteOBDPClusterDAO;
    @Inject
    ViewURLDAO viewURLDAO;
    @Inject
    ViewInstanceOperationHandler viewInstanceOperationHandler;

    @Inject
    public ViewRegistry(OBDPEventPublisher publisher) {
        publisher.register(this);
    }

    public static void main(String[] args) {
        if (args.length >= 2 && args[0].equals(EXTRACT_COMMAND)) {
            String archivePath = args[1];
            ViewModule viewModule = new ViewModule();
            try {
                if (ViewRegistry.extractViewArchive(archivePath, viewModule, true)) {
                    System.exit(0);
                }
            }
            catch (Exception e) {
                String msg = "Caught exception extracting view archive " + archivePath + ".";
                LOG.error(msg, (Throwable)e);
                System.exit(2);
            }
        }
        System.exit(1);
    }

    public Collection<ViewEntity> getDefinitions() {
        return this.viewDefinitions.values();
    }

    public ViewEntity getDefinition(String viewName, String version) {
        return this.getDefinition(ViewEntity.getViewName(viewName, version));
    }

    public ViewEntity getDefinition(ResourceTypeEntity resourceTypeEntity) {
        for (ViewEntity viewEntity : this.viewDefinitions.values()) {
            if (!viewEntity.isDeployed() || !viewEntity.getResourceType().equals(resourceTypeEntity)) continue;
            return viewEntity;
        }
        return null;
    }

    public void addDefinition(ViewEntity definition) {
        this.viewDefinitions.put(definition.getName(), definition);
    }

    public Collection<ViewInstanceEntity> getInstanceDefinitions(ViewEntity definition) {
        Map<String, ViewInstanceEntity> instanceEntityMap;
        if (definition != null && (instanceEntityMap = this.viewInstanceDefinitions.get(definition)) != null) {
            return instanceEntityMap.values();
        }
        return Collections.emptyList();
    }

    public ViewInstanceEntity getInstanceDefinition(String viewName, String version, String instanceName) {
        Map<String, ViewInstanceEntity> viewInstanceDefinitionMap = this.viewInstanceDefinitions.get(this.getDefinition(viewName, version));
        return viewInstanceDefinitionMap == null ? null : viewInstanceDefinitionMap.get(instanceName);
    }

    public void addInstanceDefinition(ViewEntity definition, ViewInstanceEntity instanceDefinition) {
        View view;
        Map<String, ViewInstanceEntity> instanceDefinitions = this.viewInstanceDefinitions.get(definition);
        if (instanceDefinitions == null) {
            instanceDefinitions = new HashMap<String, ViewInstanceEntity>();
            this.viewInstanceDefinitions.put(definition, instanceDefinitions);
        }
        if ((view = definition.getView()) != null) {
            view.onCreate((ViewInstanceDefinition)instanceDefinition);
        }
        instanceDefinitions.put(instanceDefinition.getName(), instanceDefinition);
    }

    public void removeInstanceDefinition(ViewEntity definition, String instanceName) {
        ViewInstanceEntity instanceDefinition;
        Map<String, ViewInstanceEntity> instanceDefinitions = this.viewInstanceDefinitions.get(definition);
        if (instanceDefinitions != null && (instanceDefinition = instanceDefinitions.get(instanceName)) != null) {
            View view = definition.getView();
            if (view != null) {
                view.onDestroy((ViewInstanceDefinition)instanceDefinition);
            }
            instanceDefinitions.remove(instanceName);
        }
    }

    public static void initInstance(ViewRegistry singleton) {
        ViewRegistry.singleton = singleton;
    }

    public static ViewRegistry getInstance() {
        return singleton;
    }

    public Set<SubResourceDefinition> getSubResourceDefinitions(String viewName, String version) {
        viewName = ViewEntity.getViewName(viewName, version);
        return this.subResourceDefinitionsMap.get(viewName);
    }

    public void readViewArchives() {
        boolean systemViewsOnly = this.configuration.extractViewsAfterClusterConfig() != false && ((Clusters)this.clustersProvider.get()).getClusters().isEmpty();
        LOG.info("Triggering loading of [{}] views", (Object)(systemViewsOnly ? "SYSTEM" : "ALL"));
        this.readViewArchives(systemViewsOnly, false, ALL_VIEWS_REG_EXP);
    }

    public void readViewArchives(String viewNameRegExp) {
        this.readViewArchives(false, false, viewNameRegExp);
    }

    public boolean instanceExists(ViewInstanceEntity instanceEntity) {
        ViewEntity viewEntity = this.getDefinition(instanceEntity.getViewName());
        return viewEntity != null && this.getInstanceDefinition(viewEntity.getCommonName(), viewEntity.getVersion(), instanceEntity.getName()) != null;
    }

    public void installViewInstance(ViewInstanceEntity instanceEntity) throws ValidationException, IllegalArgumentException, SystemException {
        ViewEntity viewEntity = this.getDefinition(instanceEntity.getViewName());
        if (viewEntity != null) {
            String version;
            String instanceName = instanceEntity.getName();
            String viewName = viewEntity.getCommonName();
            if (this.getInstanceDefinition(viewName, version = viewEntity.getVersion(), instanceName) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating view instance {}/{}/{}", new Object[]{viewName, version, instanceName});
                }
                instanceEntity.validate(viewEntity, Validator.ValidationContext.PRE_CREATE);
                ViewRegistry.setPersistenceEntities(instanceEntity);
                ViewInstanceEntity persistedInstance = this.mergeViewInstance(instanceEntity, viewEntity.getResourceType());
                instanceEntity.setViewInstanceId(persistedInstance.getViewInstanceId());
                this.syncViewInstance(instanceEntity, persistedInstance);
                try {
                    this.bindViewInstance(viewEntity, instanceEntity);
                }
                catch (Exception e) {
                    String message = "Caught exception installing view instance.";
                    LOG.error(message, (Throwable)e);
                    throw new IllegalStateException(message, e);
                }
                this.addInstanceDefinition(viewEntity, instanceEntity);
                this.handlerList.addViewInstance(instanceEntity);
            }
        } else {
            String message = "Attempt to install an instance for an unknown view " + instanceEntity.getViewName() + ".";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    public void updateViewInstance(ViewInstanceEntity instanceEntity) throws ValidationException, SystemException {
        ViewEntity viewEntity = this.getDefinition(instanceEntity.getViewName());
        if (viewEntity != null) {
            instanceEntity.validate(viewEntity, Validator.ValidationContext.PRE_UPDATE);
            this.instanceDAO.merge(instanceEntity);
            this.syncViewInstance(instanceEntity);
        }
    }

    public void updateView(ViewInstanceEntity instanceEntity) {
        ViewEntity viewEntity = this.getDefinition(instanceEntity.getViewName());
        if (null != viewEntity && null != viewEntity.getView()) {
            viewEntity.getView().onUpdate((ViewInstanceDefinition)instanceEntity);
        }
    }

    public ViewInstanceEntity getViewInstanceEntity(String viewName, String instanceName) {
        return this.instanceDAO.findByName(viewName, instanceName);
    }

    @Transactional
    public void uninstallViewInstance(ViewInstanceEntity instanceEntity) throws IllegalStateException {
        try {
            this.viewInstanceOperationHandler.uninstallViewInstance(instanceEntity);
            this.updateCaches(instanceEntity);
        }
        catch (IllegalStateException illegalStateExcpetion) {
            LOG.error("Exception occurred while uninstalling view : {}", (Object)instanceEntity, (Object)illegalStateExcpetion);
            throw illegalStateExcpetion;
        }
    }

    private void updateCaches(ViewInstanceEntity instanceEntity) {
        ViewEntity viewEntity = this.getDefinition(instanceEntity.getViewName());
        viewEntity.removeInstanceDefinition(instanceEntity.getInstanceName());
        this.removeInstanceDefinition(viewEntity, instanceEntity.getInstanceName());
        this.handlerList.removeViewInstance(instanceEntity);
    }

    @Transactional
    public void removeInstanceData(ViewInstanceEntity instanceEntity, String key) {
        ViewInstanceDataEntity dataEntity = instanceEntity.getInstanceData(key);
        if (dataEntity != null) {
            this.instanceDAO.removeData(dataEntity);
        }
        instanceEntity.removeInstanceData(key);
        this.instanceDAO.merge(instanceEntity);
    }

    @Transactional
    public void copyPrivileges(ViewInstanceEntity sourceInstanceEntity, ViewInstanceEntity targetInstanceEntity) {
        LOG.debug("Copy all privileges from {} to {}", (Object)sourceInstanceEntity.getName(), (Object)targetInstanceEntity.getName());
        List<PrivilegeEntity> targetInstancePrivileges = this.privilegeDAO.findByResourceId(targetInstanceEntity.getResource().getId());
        if (targetInstancePrivileges.size() > 0) {
            LOG.warn("Target instance {} already has privileges assigned, these will not be deleted. Manual clean up may be needed", (Object)targetInstanceEntity.getName());
        }
        List<PrivilegeEntity> sourceInstancePrivileges = this.privilegeDAO.findByResourceId(sourceInstanceEntity.getResource().getId());
        for (PrivilegeEntity sourcePrivilege : sourceInstancePrivileges) {
            PrivilegeEntity targetPrivilege = new PrivilegeEntity();
            targetPrivilege.setPrincipal(sourcePrivilege.getPrincipal());
            targetPrivilege.setResource(targetInstanceEntity.getResource());
            targetPrivilege.setPermission(sourcePrivilege.getPermission());
            try {
                this.privilegeDAO.create(targetPrivilege);
                targetPrivilege.getPrincipal().getPrivileges().add(sourcePrivilege);
            }
            catch (Exception e) {
                LOG.warn("Could not migrate privilege {} ", (Object)targetPrivilege);
                LOG.error("Caught exception", (Throwable)e);
            }
        }
    }

    public void fireEvent(Event event) {
        ViewDefinition subject = event.getViewSubject();
        this.fireEvent(event, subject.getViewName());
        this.fireEvent(event, ViewEntity.getViewName(subject.getViewName(), subject.getVersion()));
    }

    public synchronized void registerListener(Listener listener, String viewName, String viewVersion) {
        String name = viewVersion == null ? viewName : ViewEntity.getViewName(viewName, viewVersion);
        Set listeners = this.listeners.get(name);
        if (listeners == null) {
            listeners = Sets.newSetFromMap(new ConcurrentHashMap());
            this.listeners.put(name, listeners);
        }
        listeners.add((Listener)listener);
    }

    public synchronized void unregisterListener(Listener listener, String viewName, String viewVersion) {
        String name = viewVersion == null ? viewName : ViewEntity.getViewName(viewName, viewVersion);
        Set<Listener> listeners = this.listeners.get(name);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public boolean hasPermission(PermissionEntity permissionEntity, ResourceEntity resourceEntity, String userName) {
        UserEntity userEntity = this.userDAO.findUserByName(userName);
        if (userEntity == null) {
            return false;
        }
        if (this.privilegeDAO.exists(userEntity.getPrincipal(), resourceEntity, permissionEntity)) {
            return true;
        }
        List<MemberEntity> memberEntities = this.memberDAO.findAllMembersByUser(userEntity);
        for (MemberEntity memberEntity : memberEntities) {
            GroupEntity groupEntity = memberEntity.getGroup();
            if (!this.privilegeDAO.exists(groupEntity.getPrincipal(), resourceEntity, permissionEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPermission(String viewName, String version, String instanceName, boolean readOnly) {
        ViewInstanceEntity instanceEntity = instanceName == null ? null : this.getInstanceDefinition(viewName, version, instanceName);
        return this.checkPermission(instanceEntity, readOnly);
    }

    public boolean checkPermission(ViewInstanceEntity instanceEntity, boolean readOnly) {
        ResourceEntity resourceEntity = instanceEntity == null ? null : instanceEntity.getResource();
        return resourceEntity == null && readOnly || this.checkAuthorization(resourceEntity);
    }

    public boolean checkAdmin() {
        return this.checkAuthorization(null);
    }

    public boolean includeDefinition(ViewEntity definitionEntity) {
        if (this.checkPermission(null, false)) {
            return true;
        }
        for (ViewInstanceEntity instanceEntity : definitionEntity.getInstances()) {
            if (!this.checkPermission(instanceEntity, true)) continue;
            return true;
        }
        return false;
    }

    public void setViewInstanceProperties(ViewInstanceEntity instanceEntity, Map<String, String> properties, ViewConfig viewConfig, ClassLoader classLoader) throws SystemException {
        try {
            Masker masker = ViewRegistry.getMasker(viewConfig.getMaskerClass(classLoader));
            HashMap<String, ParameterConfig> parameterConfigMap = new HashMap<String, ParameterConfig>();
            for (ParameterConfig parameterConfig : viewConfig.getParameters()) {
                parameterConfigMap.put(parameterConfig.getName(), parameterConfig);
            }
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                ParameterConfig parameterConfig = (ParameterConfig)parameterConfigMap.get(name);
                if (parameterConfig != null && parameterConfig.isMasked()) {
                    value = masker.mask(value);
                }
                instanceEntity.putProperty(name, value);
            }
        }
        catch (Exception e) {
            throw new SystemException("Caught exception while setting instance property.", (Throwable)e);
        }
    }

    public Cluster getCluster(ViewInstanceDefinition viewInstance) {
        if (viewInstance != null) {
            Long clusterId = viewInstance.getClusterHandle();
            if (clusterId != null && viewInstance.getClusterType() == ClusterType.LOCAL_OBDP) {
                try {
                    return new ClusterImpl(((Clusters)this.clustersProvider.get()).getCluster(clusterId));
                }
                catch (OBDPException e) {
                    LOG.error("Could not find the cluster identified by {}.", (Object)clusterId);
                    throw new IllegalClusterException(e);
                }
            }
            if (clusterId != null && viewInstance.getClusterType() == ClusterType.REMOTE_OBDP) {
                try {
                    return this.remoteOBDPClusterRegistry.get(clusterId);
                }
                catch (MalformedURLException e) {
                    LOG.error("Remote Cluster with id={} had invalid URL.", (Object)clusterId, (Object)e);
                    throw new IllegalClusterException(e);
                }
                catch (ClusterNotFoundException e) {
                    LOG.error("Cannot get Remote Cluster with id={}.", (Object)clusterId, (Object)e);
                    throw new IllegalClusterException((Throwable)((Object)e));
                }
            }
        }
        return null;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(ServiceInstalledEvent event) {
        Clusters clusters = (Clusters)this.clustersProvider.get();
        Long clusterId = event.getClusterId();
        try {
            id.onyx.obdp.server.state.Cluster cluster = clusters.getClusterById(clusterId);
            String clusterName = cluster.getClusterName();
            HashSet<StackId> stackIds = new HashSet<StackId>();
            Set<String> serviceNames = cluster.getServices().keySet();
            for (String serviceName : serviceNames) {
                Service service = cluster.getService(serviceName);
                stackIds.add(service.getDesiredStackId());
            }
            for (ViewEntity viewEntity : this.getDefinitions()) {
                String viewName = viewEntity.getName();
                ViewConfig viewConfig = viewEntity.getConfiguration();
                AutoInstanceConfig autoConfig = viewConfig.getAutoInstance();
                ArrayList roles = Lists.newArrayList();
                if (autoConfig != null && !CollectionUtils.isEmpty(autoConfig.getRoles())) {
                    roles.addAll(autoConfig.getRoles());
                }
                for (StackId stackId : stackIds) {
                    try {
                        if (!this.checkAutoInstanceConfig(autoConfig, stackId, event.getServiceName(), serviceNames)) continue;
                        this.installAutoInstance(clusterId, clusterName, cluster.getService(event.getServiceName()), viewEntity, viewName, viewConfig, autoConfig, roles);
                    }
                    catch (Exception e) {
                        LOG.error("Can't auto create instance of view " + viewName + " for cluster " + clusterName + ".  Caught exception :" + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (OBDPException e) {
            LOG.warn("Unknown cluster id " + clusterId + ".");
        }
    }

    private void installAutoInstance(Long clusterId, String clusterName, Service service, ViewEntity viewEntity, String viewName, ViewConfig viewConfig, AutoInstanceConfig autoConfig, Collection<String> roles) throws SystemException, ValidationException {
        LOG.info("Auto creating instance of view " + viewName + " for cluster " + clusterName + ".");
        ViewInstanceEntity viewInstanceEntity = this.createViewInstanceEntity(viewEntity, viewConfig, autoConfig);
        this.updateHiveLLAPSettingsIfRequired(viewInstanceEntity, service);
        viewInstanceEntity.setClusterHandle(clusterId);
        this.installViewInstance(viewInstanceEntity);
        this.setViewInstanceRoleAccess(viewInstanceEntity, roles);
        try {
            this.setViewUrl(viewInstanceEntity);
        }
        catch (Exception urlCreateException) {
            LOG.error("Error while creating an auto URL for the view instance {}, Url should be created in view instance settings", (Object)viewInstanceEntity.getViewName());
            LOG.error("View URL creation error ", (Throwable)urlCreateException);
        }
    }

    private void updateHiveLLAPSettingsIfRequired(ViewInstanceEntity viewInstanceEntity, Service service) {
        String INTERACTIVE_KEY = "use.hive.interactive.mode";
        String LLAP_COMPONENT_NAME = "HIVE_SERVER_INTERACTIVE";
        String viewVersion = viewInstanceEntity.getViewDefinition().getVersion();
        String viewName = viewInstanceEntity.getViewDefinition().getViewName();
        if (!viewName.equalsIgnoreCase("HIVE") || viewVersion.equalsIgnoreCase("1.0.0")) {
            return;
        }
        try {
            ServiceComponent component = service.getServiceComponent(LLAP_COMPONENT_NAME);
            if (component.getServiceComponentHosts().size() == 0) {
                return;
            }
            for (Map.Entry<String, String> property : viewInstanceEntity.getPropertyMap().entrySet()) {
                if (!INTERACTIVE_KEY.equals(property.getKey()) || "true".equalsIgnoreCase(property.getValue())) continue;
                ViewInstancePropertyEntity propertyEntity = new ViewInstancePropertyEntity();
                propertyEntity.setViewInstanceName(viewInstanceEntity.getName());
                propertyEntity.setViewName(viewInstanceEntity.getViewName());
                propertyEntity.setName(INTERACTIVE_KEY);
                propertyEntity.setValue("true");
                propertyEntity.setViewInstanceEntity(viewInstanceEntity);
                viewInstanceEntity.getProperties().add(propertyEntity);
            }
        }
        catch (OBDPException e) {
            LOG.error("Failed to update '{}' parameter for viewName: {}, version: {}. Exception: {}", new Object[]{INTERACTIVE_KEY, viewName, viewVersion, e});
        }
    }

    private String getUrlName(ViewInstanceEntity viewInstanceEntity) {
        return viewInstanceEntity.getViewEntity().getCommonName().toLowerCase() + "_" + viewInstanceEntity.getInstanceName().toLowerCase();
    }

    private void setViewUrl(ViewInstanceEntity instanceEntity) {
        block5: {
            ViewInstanceEntity viewInstanceEntity = this.instanceDAO.findByName(instanceEntity.getViewName(), instanceEntity.getInstanceName());
            Preconditions.checkNotNull((Object)viewInstanceEntity);
            ViewURLEntity viewUrl = viewInstanceEntity.getViewUrl();
            if (viewUrl != null) {
                LOG.warn("Url exists for the auto instance {}, new url will not be created", (Object)viewInstanceEntity.getViewName());
                return;
            }
            String urlName = this.getUrlName(viewInstanceEntity);
            Optional<ViewURLEntity> existingUrl = this.viewURLDAO.findByName(urlName);
            ViewURLEntity urlEntity = new ViewURLEntity();
            urlEntity.setUrlName(urlName);
            urlEntity.setUrlSuffix(viewInstanceEntity.getInstanceName().toLowerCase());
            ViewURLEntity toSaveOrUpdate = (ViewURLEntity)existingUrl.or((Object)urlEntity);
            toSaveOrUpdate.setViewInstanceEntity(viewInstanceEntity);
            if (existingUrl.isPresent()) {
                LOG.info("Url already present for {}", (Object)viewInstanceEntity.getViewName());
                this.viewURLDAO.update(toSaveOrUpdate);
            } else {
                LOG.info("Creating a new URL for auto instance {}", (Object)viewInstanceEntity.getViewName());
                this.viewURLDAO.save(urlEntity);
            }
            viewInstanceEntity.setViewUrl(urlEntity);
            try {
                this.updateViewInstance(viewInstanceEntity);
            }
            catch (Exception ex) {
                LOG.error("Could not update the view instance with new URL, removing URL", (Throwable)ex);
                Optional<ViewURLEntity> viewURLDAOByName = this.viewURLDAO.findByName(urlName);
                if (!viewURLDAOByName.isPresent()) break block5;
                this.viewURLDAO.delete((ViewURLEntity)viewURLDAOByName.get());
            }
        }
    }

    @Subscribe
    public void onClusterConfigFinishedEvent(ClusterConfigFinishedEvent event) {
        if (this.configuration.extractViewsAfterClusterConfig().booleanValue()) {
            LOG.info("Trigger extracting NON-SYSTEM views; cluster [{}] ...", (Object)event.getClusterName());
            this.readNonSystemViewViewArchives();
            LOG.info("Trigger extracting NON-SYSTEM views; cluster [{}] DONE.", (Object)event.getClusterName());
        }
    }

    private boolean checkAutoInstanceConfig(AutoInstanceConfig autoConfig, StackId stackId, String serviceName, Set<String> serviceNames) {
        String configStackId;
        List<String> autoCreateServices;
        if (autoConfig != null && (autoCreateServices = autoConfig.getServices()) != null && autoCreateServices.contains(serviceName) && serviceNames.containsAll(autoCreateServices) && (configStackId = autoConfig.getStackId()) != null) {
            if (configStackId.equals("*")) {
                return true;
            }
            StackId id = new StackId(configStackId);
            if (id.getStackName().equals(stackId.getStackName())) {
                String stackVersion = stackId.getStackVersion();
                String configStackVersion = id.getStackVersion();
                int compVal = 0;
                int index = configStackVersion.indexOf(42);
                if (index == -1) {
                    compVal = VersionUtils.compareVersions((String)configStackVersion, (String)stackVersion);
                } else if (index > 0) {
                    String[] parts = configStackVersion.substring(0, index).split("\\.");
                    compVal = VersionUtils.compareVersions((String)configStackVersion, (String)stackVersion, (int)parts.length);
                }
                return compVal == 0;
            }
        }
        return false;
    }

    protected void clear() {
        this.viewDefinitions.clear();
        this.viewInstanceDefinitions.clear();
        this.subResourceDefinitionsMap.clear();
        this.listeners.clear();
    }

    protected Map<Resource.Type, id.onyx.obdp.server.controller.spi.ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    private ViewEntity getDefinition(String viewName) {
        return this.viewDefinitions.get(viewName);
    }

    protected ViewEntity setupViewDefinition(ViewEntity viewDefinition, ClassLoader cl) throws ClassNotFoundException, IntrospectionException {
        ViewConfig viewConfig = viewDefinition.getConfiguration();
        viewDefinition.setClassLoader(cl);
        List<ParameterConfig> parameterConfigurations = viewConfig.getParameters();
        HashSet<ViewParameterEntity> parameters = new HashSet<ViewParameterEntity>();
        String viewName = viewDefinition.getName();
        for (ParameterConfig parameterConfiguration : parameterConfigurations) {
            ViewParameterEntity viewParameterEntity = new ViewParameterEntity();
            viewParameterEntity.setViewName(viewName);
            viewParameterEntity.setName(parameterConfiguration.getName());
            viewParameterEntity.setDescription(parameterConfiguration.getDescription());
            viewParameterEntity.setLabel(parameterConfiguration.getLabel());
            viewParameterEntity.setPlaceholder(parameterConfiguration.getPlaceholder());
            viewParameterEntity.setDefaultValue(parameterConfiguration.getDefaultValue());
            viewParameterEntity.setClusterConfig(parameterConfiguration.getClusterConfig());
            viewParameterEntity.setRequired(parameterConfiguration.isRequired());
            viewParameterEntity.setMasked(parameterConfiguration.isMasked());
            viewParameterEntity.setViewEntity(viewDefinition);
            parameters.add(viewParameterEntity);
        }
        viewDefinition.setParameters(parameters);
        List<ResourceConfig> resourceConfigurations = viewConfig.getResources();
        Resource.Type externalResourceType = viewDefinition.getExternalResourceType();
        ViewExternalSubResourceProvider viewExternalSubResourceProvider = new ViewExternalSubResourceProvider(externalResourceType, viewDefinition);
        viewDefinition.addResourceProvider(externalResourceType, viewExternalSubResourceProvider);
        this.resourceProviders.put(externalResourceType, viewExternalSubResourceProvider);
        ResourceInstanceFactoryImpl.addResourceDefinition(externalResourceType, new ViewExternalSubResourceDefinition(externalResourceType));
        HashSet<ViewResourceEntity> resources = new HashSet<ViewResourceEntity>();
        for (ResourceConfig resourceConfiguration : resourceConfigurations) {
            ViewResourceEntity viewResourceEntity = new ViewResourceEntity();
            viewResourceEntity.setViewName(viewName);
            viewResourceEntity.setName(resourceConfiguration.getName());
            viewResourceEntity.setPluralName(resourceConfiguration.getPluralName());
            viewResourceEntity.setIdProperty(resourceConfiguration.getIdProperty());
            viewResourceEntity.setResource(resourceConfiguration.getResource());
            viewResourceEntity.setService(resourceConfiguration.getService());
            viewResourceEntity.setProvider(resourceConfiguration.getProvider());
            viewResourceEntity.setSubResourceNames(resourceConfiguration.getSubResourceNames());
            viewResourceEntity.setViewEntity(viewDefinition);
            ViewSubResourceDefinition resourceDefinition = new ViewSubResourceDefinition(viewDefinition, resourceConfiguration);
            viewDefinition.addResourceDefinition(resourceDefinition);
            Resource.Type type = resourceDefinition.getType();
            viewDefinition.addResourceConfiguration(type, resourceConfiguration);
            if (resourceConfiguration.isExternal()) {
                viewExternalSubResourceProvider.addResourceName(resourceConfiguration.getName());
            } else {
                ResourceInstanceFactoryImpl.addResourceDefinition(type, resourceDefinition);
                Class<?> clazz = resourceConfiguration.getResourceClass(cl);
                String idProperty = resourceConfiguration.getIdProperty();
                ViewSubResourceProvider provider = new ViewSubResourceProvider(type, clazz, idProperty, viewDefinition);
                viewDefinition.addResourceProvider(type, provider);
                this.resourceProviders.put(type, provider);
                resources.add(viewResourceEntity);
            }
            viewDefinition.setResources(resources);
        }
        ResourceTypeEntity resourceTypeEntity = new ResourceTypeEntity();
        resourceTypeEntity.setName(viewName);
        viewDefinition.setResourceType(resourceTypeEntity);
        List<PermissionConfig> permissionConfigurations = viewConfig.getPermissions();
        HashSet<PermissionEntity> permissions = new HashSet<PermissionEntity>();
        for (PermissionConfig permissionConfiguration : permissionConfigurations) {
            PermissionEntity permissionEntity = new PermissionEntity();
            permissionEntity.setPermissionName(permissionConfiguration.getName());
            permissionEntity.setResourceType(resourceTypeEntity);
            permissions.add(permissionEntity);
        }
        viewDefinition.setPermissions(permissions);
        View view = null;
        if (viewConfig.getView() != null) {
            view = ViewRegistry.getView(viewConfig.getViewClass(cl), new ViewContextImpl(viewDefinition, this));
        }
        viewDefinition.setView(view);
        Validator validator = null;
        if (viewConfig.getValidator() != null) {
            validator = ViewRegistry.getValidator(viewConfig.getValidatorClass(cl), new ViewContextImpl(viewDefinition, this));
        }
        viewDefinition.setValidator(validator);
        viewDefinition.setMask(viewConfig.getMasker());
        HashSet<SubResourceDefinition> subResourceDefinitions = new HashSet<SubResourceDefinition>();
        for (Resource.Type type : viewDefinition.getViewResourceTypes()) {
            subResourceDefinitions.add(new SubResourceDefinition(type));
        }
        this.subResourceDefinitionsMap.put(viewName, subResourceDefinitions);
        return viewDefinition;
    }

    protected ViewInstanceEntity createViewInstanceDefinition(ViewConfig viewConfig, ViewEntity viewDefinition, InstanceConfig instanceConfig) throws ValidationException, ClassNotFoundException, SystemException {
        ViewInstanceEntity viewInstanceDefinition = this.createViewInstanceEntity(viewDefinition, viewConfig, instanceConfig);
        viewInstanceDefinition.validate(viewDefinition, Validator.ValidationContext.PRE_CREATE);
        this.bindViewInstance(viewDefinition, viewInstanceDefinition);
        return viewInstanceDefinition;
    }

    private ViewInstanceEntity createViewInstanceEntity(ViewEntity viewDefinition, ViewConfig viewConfig, InstanceConfig instanceConfig) throws SystemException {
        ViewInstanceEntity viewInstanceDefinition = new ViewInstanceEntity(viewDefinition, instanceConfig);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropertyConfig propertyConfig : instanceConfig.getProperties()) {
            properties.put(propertyConfig.getKey(), propertyConfig.getValue());
        }
        this.setViewInstanceProperties(viewInstanceDefinition, properties, viewConfig, viewDefinition.getClassLoader());
        ViewRegistry.setPersistenceEntities(viewInstanceDefinition);
        return viewInstanceDefinition;
    }

    protected void bindViewInstance(ViewEntity viewDefinition, ViewInstanceEntity viewInstanceDefinition) throws ClassNotFoundException {
        viewInstanceDefinition.setViewEntity(viewDefinition);
        ViewContextImpl viewInstanceContext = new ViewContextImpl(viewInstanceDefinition, this);
        ViewExternalSubResourceService externalSubResourceService = new ViewExternalSubResourceService(viewDefinition.getExternalResourceType(), viewInstanceDefinition);
        viewInstanceDefinition.addService("resources", externalSubResourceService);
        Collection<ViewSubResourceDefinition> resourceDefinitions = viewDefinition.getResourceDefinitions().values();
        for (ViewSubResourceDefinition resourceDefinition : resourceDefinitions) {
            Resource.Type type = resourceDefinition.getType();
            ResourceConfig resourceConfig = resourceDefinition.getResourceConfiguration();
            ViewSubResourceService viewResourceService = new ViewSubResourceService(type, viewInstanceDefinition);
            ClassLoader cl = viewDefinition.getClassLoader();
            Object service = ViewRegistry.getService(resourceConfig.getServiceClass(cl), viewResourceService, viewInstanceContext);
            if (resourceConfig.isExternal()) {
                externalSubResourceService.addResourceService(resourceConfig.getName(), service);
                continue;
            }
            viewInstanceDefinition.addService(viewDefinition.getResourceDefinition(type).getPluralName(), service);
            viewInstanceDefinition.addResourceProvider(type, ViewRegistry.getProvider(resourceConfig.getProviderClass(cl), viewInstanceContext));
        }
        viewDefinition.addInstanceDefinition(viewInstanceDefinition);
    }

    private static void setPersistenceEntities(ViewInstanceEntity viewInstanceDefinition) {
        PersistenceConfig persistenceConfig;
        ViewEntity viewDefinition = viewInstanceDefinition.getViewEntity();
        ViewConfig viewConfig = viewDefinition.getConfiguration();
        HashSet<ViewEntityEntity> entities = new HashSet<ViewEntityEntity>();
        if (viewConfig != null && (persistenceConfig = viewConfig.getPersistence()) != null) {
            for (EntityConfig entityConfiguration : persistenceConfig.getEntities()) {
                ViewEntityEntity viewEntityEntity = new ViewEntityEntity();
                viewEntityEntity.setViewName(viewDefinition.getName());
                viewEntityEntity.setViewInstanceName(viewInstanceDefinition.getName());
                viewEntityEntity.setClassName(entityConfiguration.getClassName());
                viewEntityEntity.setIdProperty(entityConfiguration.getIdProperty());
                viewEntityEntity.setViewInstance(viewInstanceDefinition);
                entities.add(viewEntityEntity);
            }
        }
        viewInstanceDefinition.setEntities(entities);
    }

    private static <T> T getService(Class<T> clazz, final ViewResourceHandler viewResourceHandler, final ViewContext viewInstanceContext) {
        Injector viewInstanceInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ViewResourceHandler.class).toInstance((Object)viewResourceHandler);
                this.bind(ViewContext.class).toInstance((Object)viewInstanceContext);
            }
        }});
        return (T)viewInstanceInjector.getInstance(clazz);
    }

    private static ResourceProvider getProvider(Class<? extends ResourceProvider> clazz, final ViewContext viewInstanceContext) {
        Injector viewInstanceInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ViewContext.class).toInstance((Object)viewInstanceContext);
            }
        }});
        return (ResourceProvider)viewInstanceInjector.getInstance(clazz);
    }

    private static View getView(Class<? extends View> clazz, final ViewContext viewContext) {
        Injector viewInstanceInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ViewContext.class).toInstance((Object)viewContext);
            }
        }});
        return (View)viewInstanceInjector.getInstance(clazz);
    }

    private static Validator getValidator(Class<? extends Validator> clazz, final ViewContext viewContext) {
        Injector viewInstanceInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ViewContext.class).toInstance((Object)viewContext);
            }
        }});
        return (Validator)viewInstanceInjector.getInstance(clazz);
    }

    private static Masker getMasker(Class<? extends Masker> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            LOG.error("Could not create masker instance", (Throwable)e);
            return null;
        }
    }

    private void removeUndeployedViews() {
        for (ViewEntity viewEntity : this.viewDAO.findAll()) {
            String name = viewEntity.getName();
            if (ViewRegistry.getInstance().viewDefinitions.containsKey(name)) continue;
            try {
                this.viewDAO.remove(viewEntity);
            }
            catch (Exception e) {
                LOG.error("Caught exception undeploying view " + viewEntity.getName(), (Throwable)e);
            }
        }
    }

    private void syncView(ViewEntity view, Set<ViewInstanceEntity> instanceDefinitions) throws Exception {
        String viewName = view.getName();
        ViewEntity persistedView = this.viewDAO.findByName(viewName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Syncing view {}.", (Object)viewName);
        }
        if (persistedView == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating view {}.", (Object)viewName);
            }
            ResourceTypeEntity resourceType = this.resourceTypeDAO.merge(view.getResourceType());
            for (ViewInstanceEntity instance : view.getInstances()) {
                instance.setResource(this.createViewInstanceResource(resourceType));
            }
            view.setResourceType(resourceType);
            persistedView = this.viewDAO.merge(view);
        }
        view.setResourceType(persistedView.getResourceType());
        view.setPermissions(persistedView.getPermissions());
        for (ViewInstanceEntity persistedInstance : persistedView.getInstances()) {
            String instanceName = persistedInstance.getName();
            ViewInstanceEntity instance = view.getInstanceDefinition(instanceName);
            if (instance == null) {
                if (persistedInstance.isXmlDriven()) {
                    this.instanceDAO.remove(persistedInstance);
                    continue;
                }
                this.instanceDAO.merge(persistedInstance);
                this.bindViewInstance(view, persistedInstance);
                instanceDefinitions.add(persistedInstance);
                continue;
            }
            this.syncViewInstance(instance, persistedInstance);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Syncing view {} complete.", (Object)viewName);
        }
    }

    private void syncViewInstance(ViewInstanceEntity instanceEntity) {
        String instanceName;
        String version;
        String viewName = instanceEntity.getViewDefinition().getViewName();
        ViewInstanceEntity registryEntry = this.getInstanceDefinition(viewName, version = instanceEntity.getViewDefinition().getVersion(), instanceName = instanceEntity.getInstanceName());
        if (registryEntry != null) {
            this.syncViewInstance(registryEntry, instanceEntity);
        }
    }

    private void syncViewInstance(ViewInstanceEntity instance1, ViewInstanceEntity instance2) {
        instance1.setLabel(instance2.getLabel());
        instance1.setDescription(instance2.getDescription());
        instance1.setViewUrl(instance2.getViewUrl());
        instance1.setVisible(instance2.isVisible());
        instance1.setResource(instance2.getResource());
        instance1.setViewInstanceId(instance2.getViewInstanceId());
        instance1.setClusterHandle(instance2.getClusterHandle());
        instance1.setClusterType(instance2.getClusterType());
        instance1.setData(instance2.getData());
        instance1.setEntities(instance2.getEntities());
        instance1.setProperties(instance2.getProperties());
    }

    @Transactional
    ViewInstanceEntity mergeViewInstance(ViewInstanceEntity instanceEntity, ResourceTypeEntity resourceTypeEntity) {
        instanceEntity.setResource(this.createViewInstanceResource(resourceTypeEntity));
        return this.instanceDAO.merge(instanceEntity);
    }

    private ResourceEntity createViewInstanceResource(ResourceTypeEntity resourceTypeEntity) {
        ResourceEntity resourceEntity = new ResourceEntity();
        resourceEntity.setResourceType(resourceTypeEntity);
        this.resourceDAO.create(resourceEntity);
        return resourceEntity;
    }

    private void fireEvent(Event event, String viewName) {
        Set<Listener> listeners = this.listeners.get(viewName);
        if (listeners != null) {
            for (Listener listener : listeners) {
                listener.notify(event);
            }
        }
    }

    private boolean checkAuthorization(ResourceEntity resourceEntity) {
        Long resourceId = resourceEntity == null ? null : resourceEntity.getId();
        return resourceId == null ? AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_VIEWS) : AuthorizationHelper.isAuthorized(ResourceType.VIEW, resourceId, RoleAuthorization.VIEW_USE);
    }

    protected void onDeploy(ViewEntity definition) {
        View view = definition.getView();
        if (view != null) {
            view.onDeploy((ViewDefinition)definition);
        }
    }

    public void readViewArchive(Path path) {
        File viewDir = this.configuration.getViewsDir();
        String extractedArchivesPath = viewDir.getAbsolutePath() + File.separator + EXTRACTED_ARCHIVES_DIR;
        File archiveFile = path.toAbsolutePath().toFile();
        if (this.extractor.ensureExtractedArchiveDirectory(extractedArchivesPath)) {
            try {
                ViewConfig viewConfig = this.archiveUtility.getViewConfigFromArchive(archiveFile);
                String viewName = ViewEntity.getViewName(viewConfig.getName(), viewConfig.getVersion());
                String extractedArchiveDirPath = extractedArchivesPath + File.separator + viewName;
                File extractedArchiveDirFile = this.archiveUtility.getFile(extractedArchiveDirPath);
                ViewEntity viewDefinition = new ViewEntity(viewConfig, this.configuration, extractedArchiveDirPath);
                this.addDefinition(viewDefinition);
                this.readViewArchive(viewDefinition, archiveFile, extractedArchiveDirFile, ((OBDPMetaInfo)this.ambariMetaInfoProvider.get()).getServerVersion());
            }
            catch (Exception e) {
                LOG.error("Could not process archive at path " + path, (Throwable)e);
            }
        }
    }

    private void readNonSystemViewViewArchives() {
        try {
            File viewDir = this.configuration.getViewsDir();
            String extractedArchivesPath = viewDir.getAbsolutePath() + File.separator + EXTRACTED_ARCHIVES_DIR;
            File[] files = viewDir.listFiles();
            if (files != null) {
                final String serverVersion = ((OBDPMetaInfo)this.ambariMetaInfoProvider.get()).getServerVersion();
                ExecutorService executorService = ViewRegistry.getExecutorService(this.configuration);
                for (final File archiveFile : files) {
                    if (archiveFile.isDirectory()) continue;
                    try {
                        ViewConfig viewConfig = this.archiveUtility.getViewConfigFromArchive(archiveFile);
                        String commonName = viewConfig.getName();
                        String version = viewConfig.getVersion();
                        String viewName = ViewEntity.getViewName(commonName, version);
                        String extractedArchiveDirPath = extractedArchivesPath + File.separator + viewName;
                        final File extractedArchiveDirFile = this.archiveUtility.getFile(extractedArchiveDirPath);
                        final ViewEntity viewDefinition = new ViewEntity(viewConfig, this.configuration, extractedArchiveDirPath);
                        boolean systemView = viewDefinition.isSystem();
                        if (systemView) continue;
                        this.addDefinition(viewDefinition);
                        executorService.submit(new Runnable(){

                            @Override
                            public void run() {
                                ViewRegistry.this.readViewArchive(viewDefinition, archiveFile, extractedArchiveDirFile, serverVersion);
                                ViewRegistry.this.migrateDataFromPreviousVersion(viewDefinition, serverVersion);
                            }
                        });
                    }
                    catch (Exception e) {
                        String msg = "Caught exception reading view archive " + archiveFile.getAbsolutePath();
                        LOG.error(msg, (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception reading view archives.", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readViewArchives(boolean systemOnly, boolean useExecutor, String viewNameRegExp) {
        block15: {
            try {
                File viewDir = this.configuration.getViewsDir();
                String extractedArchivesPath = viewDir.getAbsolutePath() + File.separator + EXTRACTED_ARCHIVES_DIR;
                if (this.extractor.ensureExtractedArchiveDirectory(extractedArchivesPath)) {
                    void var11_15;
                    File[] files = viewDir.listFiles();
                    if (files == null) break block15;
                    HashSet<6> extractionRunnables = new HashSet<6>();
                    final String serverVersion = ((OBDPMetaInfo)this.ambariMetaInfoProvider.get()).getServerVersion();
                    File[] fileArray = files;
                    int n = fileArray.length;
                    boolean bl = false;
                    while (var11_15 < n) {
                        final File archiveFile = fileArray[var11_15];
                        if (!archiveFile.isDirectory()) {
                            try {
                                ViewConfig viewConfig = this.archiveUtility.getViewConfigFromArchive(archiveFile);
                                String commonName = viewConfig.getName();
                                String version = viewConfig.getVersion();
                                String viewName = ViewEntity.getViewName(commonName, version);
                                if (viewName.matches(viewNameRegExp)) {
                                    String extractedArchiveDirPath = extractedArchivesPath + File.separator + viewName;
                                    final File extractedArchiveDirFile = this.archiveUtility.getFile(extractedArchiveDirPath);
                                    final ViewEntity viewDefinition = new ViewEntity(viewConfig, this.configuration, extractedArchiveDirPath);
                                    boolean systemView = viewDefinition.isSystem();
                                    if (!systemOnly || systemView) {
                                        this.addDefinition(viewDefinition);
                                        if (systemView || !useExecutor || extractedArchiveDirFile.exists()) {
                                            this.readViewArchive(viewDefinition, archiveFile, extractedArchiveDirFile, serverVersion);
                                        } else {
                                            extractionRunnables.add(new Runnable(){

                                                @Override
                                                public void run() {
                                                    ViewRegistry.this.readViewArchive(viewDefinition, archiveFile, extractedArchiveDirFile, serverVersion);
                                                    ViewRegistry.this.migrateDataFromPreviousVersion(viewDefinition, serverVersion);
                                                }
                                            });
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                String msg = "Caught exception reading view archive " + archiveFile.getAbsolutePath();
                                LOG.error(msg, (Throwable)e);
                            }
                        }
                        ++var11_15;
                    }
                    for (ViewEntity view : this.getDefinitions()) {
                        if (view.getStatus() != ViewDefinition.ViewStatus.DEPLOYED) continue;
                        this.migrateDataFromPreviousVersion(view, serverVersion);
                    }
                    if (useExecutor && extractionRunnables.size() > 0) {
                        ExecutorService executorService = ViewRegistry.getExecutorService(this.configuration);
                        for (Runnable runnable : extractionRunnables) {
                            executorService.submit(runnable);
                        }
                    }
                    if (this.configuration.isViewRemoveUndeployedEnabled()) {
                        this.removeUndeployedViews();
                    }
                    break block15;
                }
                LOG.error("Could not create extracted view archive directory " + extractedArchivesPath + ".");
            }
            catch (Exception e) {
                LOG.error("Caught exception reading view archives.", (Throwable)e);
            }
        }
    }

    private synchronized void readViewArchive(ViewEntity viewDefinition, File archiveFile, File extractedArchiveDirFile, String serverVersion) {
        this.setViewStatus(viewDefinition, ViewDefinition.ViewStatus.DEPLOYING, "Deploying " + extractedArchiveDirFile + ".");
        String extractedArchiveDirPath = extractedArchiveDirFile.getAbsolutePath();
        LOG.info("Reading view archive " + archiveFile + ".");
        try {
            List<File> additionalPaths = ViewRegistry.getViewsAdditionalClasspath(this.configuration);
            ClassLoader cl = this.extractor.extractViewArchive(viewDefinition, archiveFile, extractedArchiveDirFile, additionalPaths);
            this.configureViewLogging(viewDefinition, cl);
            ViewConfig viewConfig = this.archiveUtility.getViewConfigFromExtractedArchive(extractedArchiveDirPath, this.configuration.isViewValidationEnabled());
            viewDefinition.setConfiguration(viewConfig);
            if (this.checkViewVersions(viewDefinition, serverVersion)) {
                this.setupViewDefinition(viewDefinition, cl);
                HashSet<ViewInstanceEntity> instanceDefinitions = new HashSet<ViewInstanceEntity>();
                for (InstanceConfig instanceConfig : viewConfig.getInstances()) {
                    ViewInstanceEntity instanceEntity = this.createViewInstanceDefinition(viewConfig, viewDefinition, instanceConfig);
                    instanceEntity.setXmlDriven(true);
                    instanceDefinitions.add(instanceEntity);
                }
                this.persistView(viewDefinition, instanceDefinitions);
                if (this.getDefinition(viewDefinition.getViewName(), viewDefinition.getVersion()) != null) {
                    this.addAutoInstanceDefinition(viewDefinition);
                }
                this.setViewStatus(viewDefinition, ViewDefinition.ViewStatus.DEPLOYED, "Deployed " + extractedArchiveDirPath + ".");
                LOG.info("View deployed: " + viewDefinition.getName() + ".");
            }
        }
        catch (Throwable e) {
            String msg = "Caught exception loading view " + viewDefinition.getName();
            this.setViewStatus(viewDefinition, ViewDefinition.ViewStatus.ERROR, msg + " : " + e.getMessage());
            LOG.error(msg, e);
        }
    }

    private static List<File> getViewsAdditionalClasspath(Configuration configuration) {
        String viewsAdditionalClasspath = configuration.getViewsAdditionalClasspath();
        LinkedList<File> additionalPaths = new LinkedList<File>();
        if (null != viewsAdditionalClasspath && !viewsAdditionalClasspath.trim().isEmpty()) {
            String[] paths;
            for (String path : paths = viewsAdditionalClasspath.trim().split(",")) {
                if (null == path || path.trim().isEmpty()) continue;
                additionalPaths.add(new File(path));
            }
        }
        return additionalPaths;
    }

    private void migrateDataFromPreviousVersion(ViewEntity viewDefinition, String serverVersion) {
        if (!this.viewDefinitions.containsKey(viewDefinition.getName())) {
            LOG.debug("Cancel auto migration of not loaded view: {}.", (Object)viewDefinition.getName());
            return;
        }
        try {
            for (ViewInstanceEntity instance : viewDefinition.getInstances()) {
                LOG.debug("Try to migrate the data from previous version of: {}/{}.", (Object)viewDefinition.getName(), (Object)instance.getInstanceName());
                ViewInstanceEntity latestUnregisteredView = this.getLatestUnregisteredInstance(serverVersion, instance);
                if (latestUnregisteredView == null) continue;
                String instanceName = instance.getViewEntity().getName() + "/" + instance.getName();
                try {
                    LOG.info("Found previous version of the view instance " + instanceName + ": " + latestUnregisteredView.getViewEntity().getName() + "/" + latestUnregisteredView.getName());
                    this.getViewDataMigrationUtility().migrateData(instance, latestUnregisteredView, true);
                    LOG.info("View data migrated: " + viewDefinition.getName() + ".");
                }
                catch (ViewDataMigrationException e) {
                    LOG.error("Error occurred during migration", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            String msg = "Caught exception migrating data in view " + viewDefinition.getName();
            this.setViewStatus(viewDefinition, ViewDefinition.ViewStatus.ERROR, msg + " : " + e.getMessage());
            LOG.error(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureViewLogging(ViewEntity viewDefinition, ClassLoader cl) {
        block9: {
            InputStream viewLog4jStream = cl.getResourceAsStream(VIEW_LOG_FILE);
            InputStream ambariLog4jStream = null;
            if (null != viewLog4jStream) {
                try {
                    Properties viewLog4jConfig = new Properties();
                    viewLog4jConfig.load(viewLog4jStream);
                    LOG.info("setting up logging for view {} as per property file {}", (Object)viewDefinition.getName(), (Object)VIEW_LOG_FILE);
                    ambariLog4jStream = cl.getResourceAsStream(OBDP_LOG_FILE);
                    if (null != ambariLog4jStream) {
                        Properties ambariLog4jConfig = new Properties();
                        ambariLog4jConfig.load(ambariLog4jStream);
                        for (Object property : ambariLog4jConfig.keySet()) {
                            String prop = (String)property;
                            if (prop.startsWith(LOG4J)) {
                                viewLog4jConfig.remove(prop);
                                continue;
                            }
                            viewLog4jConfig.put(prop, ambariLog4jConfig.getProperty(prop));
                        }
                    }
                    PropertyConfigurator.configure((Properties)viewLog4jConfig);
                    Closeables.closeSilently(ambariLog4jStream);
                }
                catch (IOException e) {
                    LOG.error("Error occurred while configuring logs for {}", (Object)viewDefinition.getName());
                    break block9;
                }
                finally {
                    Closeables.closeSilently(ambariLog4jStream);
                    Closeables.closeSilently(viewLog4jStream);
                }
                Closeables.closeSilently(viewLog4jStream);
            }
        }
    }

    private void addAutoInstanceDefinition(ViewEntity viewEntity) {
        ViewConfig viewConfig = viewEntity.getConfiguration();
        String viewName = viewEntity.getViewName();
        AutoInstanceConfig autoInstanceConfig = viewConfig.getAutoInstance();
        if (autoInstanceConfig == null) {
            return;
        }
        List<String> services = autoInstanceConfig.getServices();
        Set<String> roles = autoInstanceConfig.getRoles();
        Map<String, id.onyx.obdp.server.state.Cluster> allClusters = ((Clusters)this.clustersProvider.get()).getClusters();
        for (id.onyx.obdp.server.state.Cluster cluster : allClusters.values()) {
            String clusterName = cluster.getClusterName();
            Long clusterId = cluster.getClusterId();
            Set<String> serviceNames = cluster.getServices().keySet();
            for (String service : services) {
                try {
                    Service svc = cluster.getService(service);
                    StackId stackId = svc.getDesiredStackId();
                    if (!this.checkAutoInstanceConfig(autoInstanceConfig, stackId, service, serviceNames)) continue;
                    this.installAutoInstance(clusterId, clusterName, cluster.getService(service), viewEntity, viewName, viewConfig, autoInstanceConfig, roles);
                }
                catch (Exception e) {
                    LOG.error("Can't auto create instance of view " + viewName + " for cluster " + clusterName + ".  Caught exception :" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Transactional
    protected void setViewInstanceRoleAccess(ViewInstanceEntity viewInstanceEntity, Collection<String> roles) {
        if (roles != null && !roles.isEmpty()) {
            PermissionEntity permissionViewUser = this.permissionDAO.findViewUsePermission();
            ResourceEntity resourceEntity = viewInstanceEntity.getResource();
            if (null == resourceEntity) {
                resourceEntity = this.instanceDAO.findResourceForViewInstance(viewInstanceEntity.getViewName(), viewInstanceEntity.getInstanceName());
            }
            if (permissionViewUser == null) {
                LOG.error("Missing the {} role.  Access to view cannot be set.", (Object)"VIEW.USER", (Object)viewInstanceEntity.getName());
            } else {
                for (String role : roles) {
                    PermissionEntity permissionRole = this.permissionDAO.findByName(role);
                    if (permissionRole == null) {
                        LOG.warn("Invalid role {} encountered while setting access to view {}, Ignoring.", (Object)role, (Object)viewInstanceEntity.getName());
                        continue;
                    }
                    PrincipalEntity principalRole = permissionRole.getPrincipal();
                    if (principalRole == null) {
                        LOG.warn("Missing principal ID for role {} encountered while setting access to view {}. Ignoring.", (Object)role, (Object)viewInstanceEntity.getName());
                        continue;
                    }
                    if (this.privilegeDAO.exists(principalRole, resourceEntity, permissionViewUser)) continue;
                    PrivilegeEntity privilegeEntity = new PrivilegeEntity();
                    privilegeEntity.setPermission(permissionViewUser);
                    privilegeEntity.setPrincipal(principalRole);
                    privilegeEntity.setResource(resourceEntity);
                    this.privilegeDAO.create(privilegeEntity);
                }
            }
        }
    }

    protected boolean checkViewVersions(ViewEntity view, String serverVersion) {
        ViewConfig config = view.getConfiguration();
        return this.checkViewVersion(view, config.getMinAmbariVersion(), serverVersion, "minimum", -1, "less than") && this.checkViewVersion(view, config.getMaxAmbariVersion(), serverVersion, "maximum", 1, "greater than");
    }

    private boolean checkViewVersion(ViewEntity view, String version, String serverVersion, String label, int errValue, String errMsg) {
        if (version != null && !version.isEmpty()) {
            int compVal;
            if (!version.matches(VIEW_OBDP_VERSION_REGEXP)) {
                String msg = "The configured " + label + " Ambari version " + version + " for view " + view.getName() + " is not valid.";
                this.setViewStatus(view, ViewDefinition.ViewStatus.ERROR, msg);
                LOG.error(msg);
                return false;
            }
            int index = version.indexOf(42);
            int n = index == -1 ? VersionUtils.compareVersions((String)serverVersion, (String)version) : (compVal = index > 0 ? VersionUtils.compareVersions((String)serverVersion, (String)version.substring(0, index), (int)index) : 0);
            if (compVal == errValue) {
                String msg = "The Ambari server version " + serverVersion + " is " + errMsg + " the configured " + label + " Ambari version " + version + " for view " + view.getName();
                this.setViewStatus(view, ViewDefinition.ViewStatus.ERROR, msg);
                LOG.error(msg);
                return false;
            }
        }
        return true;
    }

    @Transactional
    void persistView(ViewEntity viewDefinition, Set<ViewInstanceEntity> instanceDefinitions) throws Exception {
        this.syncView(viewDefinition, instanceDefinitions);
        this.onDeploy(viewDefinition);
        for (ViewInstanceEntity instanceEntity : instanceDefinitions) {
            this.addInstanceDefinition(viewDefinition, instanceEntity);
            this.handlerList.addViewInstance(instanceEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean extractViewArchive(String archivePath, ViewModule viewModule, boolean systemOnly) throws Exception {
        String version;
        File archiveFile;
        ViewConfig viewConfig;
        String commonName;
        String viewName;
        String extractedArchiveDirPath;
        File extractedArchiveDirFile;
        Injector injector = Guice.createInjector((Module[])new Module[]{viewModule});
        ViewExtractor extractor = (ViewExtractor)injector.getInstance(ViewExtractor.class);
        ViewArchiveUtility archiveUtility = (ViewArchiveUtility)injector.getInstance(ViewArchiveUtility.class);
        Configuration configuration = (Configuration)injector.getInstance(Configuration.class);
        File viewDir = configuration.getViewsDir();
        String extractedArchivesPath = viewDir.getAbsolutePath() + File.separator + EXTRACTED_ARCHIVES_DIR;
        if (extractor.ensureExtractedArchiveDirectory(extractedArchivesPath) && !(extractedArchiveDirFile = archiveUtility.getFile(extractedArchiveDirPath = extractedArchivesPath + File.separator + (viewName = ViewEntity.getViewName(commonName = (viewConfig = archiveUtility.getViewConfigFromArchive(archiveFile = archiveUtility.getFile(archivePath))).getName(), version = viewConfig.getVersion())))).exists()) {
            ViewEntity viewDefinition = new ViewEntity(viewConfig, configuration, extractedArchiveDirPath);
            if (!systemOnly || viewDefinition.isSystem()) {
                ClassLoader classLoader = null;
                try {
                    List<File> additionalPaths = ViewRegistry.getViewsAdditionalClasspath(configuration);
                    classLoader = extractor.extractViewArchive(viewDefinition, archiveFile, extractedArchiveDirFile, additionalPaths);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (classLoader instanceof Closeable) {
                        Closeables.closeSilently((Closeable)((Object)classLoader));
                    }
                }
            }
        }
        return false;
    }

    private void setViewStatus(ViewEntity viewDefinition, ViewDefinition.ViewStatus status, String statusDetail) {
        viewDefinition.setStatus(status);
        viewDefinition.setStatusDetail(statusDetail);
    }

    private static synchronized ExecutorService getExecutorService(Configuration configuration) {
        if (executorService == null) {
            LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(configuration.getViewExtractionThreadPoolCoreSize(), configuration.getViewExtractionThreadPoolMaxSize(), configuration.getViewExtractionThreadPoolTimeout(), TimeUnit.MILLISECONDS, queue);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        return executorService;
    }

    protected ViewURLStreamProvider createURLStreamProvider(ViewContext viewContext) {
        ComponentSSLConfiguration sslConfiguration = ComponentSSLConfiguration.instance();
        URLStreamProvider streamProvider = new URLStreamProvider(this.configuration.getRequestConnectTimeout(), this.configuration.getRequestReadTimeout(), sslConfiguration.getTruststorePath(), sslConfiguration.getTruststorePassword(), sslConfiguration.getTruststoreType());
        return new ViewURLStreamProvider(viewContext, streamProvider);
    }

    protected ViewAmbariStreamProvider createAmbariStreamProvider() {
        ComponentSSLConfiguration sslConfiguration = ComponentSSLConfiguration.instance();
        URLStreamProvider streamProvider = new URLStreamProvider(this.configuration.getViewAmbariRequestConnectTimeout(), this.configuration.getViewAmbariRequestReadTimeout(), sslConfiguration.getTruststorePath(), sslConfiguration.getTruststorePassword(), sslConfiguration.getTruststoreType());
        return new ViewAmbariStreamProvider(streamProvider, this.ambariSessionManager, OBDPServer.getController());
    }

    protected AmbariStreamProvider createRemoteAmbariStreamProvider(Long clusterId) {
        RemoteOBDPClusterEntity clusterEntity = this.remoteOBDPClusterDAO.findById(clusterId);
        if (clusterEntity != null) {
            return new RemoteAmbariStreamProvider(this.getBaseurl(clusterEntity.getUrl()), clusterEntity.getUsername(), clusterEntity.getPassword(), this.configuration.getViewAmbariRequestConnectTimeout(), this.configuration.getViewAmbariRequestReadTimeout());
        }
        return null;
    }

    private String getBaseurl(String url) {
        int index = url.indexOf(API_PREFIX);
        return url.substring(0, index);
    }

    private ViewInstanceEntity getLatestUnregisteredInstance(String serverVersion, ViewInstanceEntity instance) throws JAXBException, IOException, SAXException {
        File viewDir = this.configuration.getViewsDir();
        String extractedArchivesPath = viewDir.getAbsolutePath() + File.separator + EXTRACTED_ARCHIVES_DIR;
        File extractedArchivesDir = new File(extractedArchivesPath);
        File[] extractedArchives = extractedArchivesDir.listFiles();
        HashMap<ViewInstanceEntity, Long> unregInstancesTimestamps = new HashMap<ViewInstanceEntity, Long>();
        if (extractedArchives != null) {
            for (File archiveDir : extractedArchives) {
                ViewConfig uViewConfig;
                if (!archiveDir.isDirectory() || (uViewConfig = this.archiveUtility.getViewConfigFromExtractedArchive(archiveDir.getPath(), false)).isSystem() || !uViewConfig.getName().equals(instance.getViewEntity().getViewName()) || this.viewDefinitions.containsKey(ViewEntity.getViewName(uViewConfig.getName(), uViewConfig.getVersion()))) continue;
                LOG.debug("Unregistered extracted view found: {}", (Object)archiveDir.getPath());
                ViewEntity uViewDefinition = new ViewEntity(uViewConfig, this.configuration, archiveDir.getPath());
                this.readViewArchive(uViewDefinition, archiveDir, archiveDir, serverVersion);
                for (ViewInstanceEntity instanceEntity : uViewDefinition.getInstances()) {
                    LOG.debug("{} instance found: {}", (Object)uViewDefinition.getName(), (Object)instanceEntity.getInstanceName());
                    unregInstancesTimestamps.put(instanceEntity, archiveDir.lastModified());
                }
            }
        }
        long latestPrevInstanceTimestamp = 0L;
        ViewInstanceEntity latestPrevInstance = null;
        for (ViewInstanceEntity unregInstance : unregInstancesTimestamps.keySet()) {
            if (!unregInstance.getName().equals(instance.getName()) || (Long)unregInstancesTimestamps.get(unregInstance) <= latestPrevInstanceTimestamp) continue;
            latestPrevInstance = unregInstance;
            latestPrevInstanceTimestamp = (Long)unregInstancesTimestamps.get(latestPrevInstance);
        }
        if (latestPrevInstance != null) {
            LOG.debug("Previous version of {}/{} found: {}/{}", new Object[]{instance.getViewEntity().getName(), instance.getName(), latestPrevInstance.getViewEntity().getName(), latestPrevInstance.getName()});
        } else {
            LOG.debug("Previous version of {}/{} not found", (Object)instance.getViewEntity().getName(), (Object)instance.getName());
        }
        return latestPrevInstance;
    }

    protected ViewDataMigrationUtility getViewDataMigrationUtility() {
        if (this.viewDataMigrationUtility == null) {
            this.viewDataMigrationUtility = new ViewDataMigrationUtility(this);
        }
        return this.viewDataMigrationUtility;
    }

    protected void setViewDataMigrationUtility(ViewDataMigrationUtility viewDataMigrationUtility) {
        this.viewDataMigrationUtility = viewDataMigrationUtility;
    }

    static {
        LOG = LoggerFactory.getLogger(ViewRegistry.class);
    }

    protected static class ViewModule
    extends AbstractModule {
        protected ViewModule() {
        }

        protected void configure() {
            Configuration configuration = new Configuration();
            this.bind(Configuration.class).toInstance((Object)configuration);
            this.bind(OsFamily.class).toInstance((Object)new OsFamily(configuration));
        }
    }
}

