/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.orm.dao.PrivilegeDAO;
import id.onyx.obdp.server.orm.dao.ViewDAO;
import id.onyx.obdp.server.orm.dao.ViewInstanceDAO;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ViewInstanceOperationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ViewInstanceOperationHandler.class);
    @Inject
    ViewDAO viewDAO;
    @Inject
    ViewInstanceDAO instanceDAO;
    @Inject
    PrivilegeDAO privilegeDAO;

    private void removePrivilegeEntity(PrivilegeEntity privilegeEntity) {
        PrincipalEntity principalEntity = privilegeEntity.getPrincipal();
        if (principalEntity != null) {
            principalEntity.removePrivilege(privilegeEntity);
        }
        this.privilegeDAO.remove(privilegeEntity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void uninstallViewInstance(ViewInstanceEntity instanceEntity) {
        LOG.info("uninstalling ViewInstance : {} ", (Object)instanceEntity);
        ViewEntity viewEntity = this.viewDAO.findByName(instanceEntity.getViewName());
        LOG.info("viewEntity received corresponding to the view entity : {} ", (Object)viewEntity);
        if (viewEntity == null) throw new IllegalStateException("View '" + instanceEntity.getViewName() + "' not found corresponding to view instance '" + instanceEntity.getName() + "'");
        String instanceName = instanceEntity.getName();
        String viewName = viewEntity.getCommonName();
        String version = viewEntity.getVersion();
        ViewInstanceEntity instanceDefinition = this.instanceDAO.findByName(instanceEntity.getViewName(), instanceEntity.getName());
        LOG.debug("view instance entity received from database : {}", (Object)instanceDefinition);
        if (instanceDefinition == null) throw new IllegalStateException("View instance '" + instanceEntity.getName() + "' not found.");
        if (instanceDefinition.isXmlDriven()) {
            throw new IllegalStateException("View instances defined via xml can't be deleted through api requests");
        }
        List<PrivilegeEntity> instancePrivileges = this.privilegeDAO.findByResourceId(instanceEntity.getResource().getId());
        LOG.info("Removing privilege entities : {}", instancePrivileges);
        for (PrivilegeEntity privilegeEntity : instancePrivileges) {
            this.removePrivilegeEntity(privilegeEntity);
        }
        LOG.info("Deleting view instance : view name : {}, version : {}, instanceName : {}", new Object[]{viewName, version, instanceName});
        this.instanceDAO.remove(instanceDefinition);
    }
}

