/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.view.ViewArchiveUtility;
import id.onyx.obdp.server.view.ViewClassLoader;
import id.onyx.obdp.server.view.configuration.ViewConfig;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewExtractor {
    private static final String ARCHIVE_CLASSES_DIR = "WEB-INF/classes";
    private static final String ARCHIVE_LIB_DIR = "WEB-INF/lib";
    private static final int BUFFER_SIZE = 1024;
    @Inject
    ViewArchiveUtility archiveUtility;
    private static final Logger LOG = LoggerFactory.getLogger(ViewExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader extractViewArchive(ViewEntity view, File viewArchive, File archiveDir, List<File> viewsAdditionalClasspath) throws ExtractionException {
        String archivePath = archiveDir.getAbsolutePath();
        try {
            if (archiveDir.exists() && viewArchive != null && viewArchive.lastModified() > archiveDir.lastModified()) {
                FileUtils.deleteDirectory((File)archiveDir);
            }
            if (!archiveDir.exists()) {
                Object msg = "Creating archive folder " + archivePath + ".";
                view.setStatusDetail((String)msg);
                LOG.info((String)msg);
                if (archiveDir.mkdir()) {
                    try (JarInputStream jarInputStream = this.archiveUtility.getJarFileStream(viewArchive);){
                        JarEntry jarEntry;
                        msg = "Extracting files from " + viewArchive.getName() + ".";
                        view.setStatusDetail((String)msg);
                        LOG.info((String)msg);
                        File metaInfDir = this.archiveUtility.getFile(archivePath + File.separator + "META-INF");
                        if (!metaInfDir.mkdir()) {
                            msg = "Could not create archive META-INF directory.";
                            view.setStatusDetail((String)msg);
                            LOG.error((String)msg);
                            throw new ExtractionException((String)msg);
                        }
                        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                            try {
                                String entryPath = archivePath + File.separator + jarEntry.getName();
                                LOG.debug("Extracting {}", (Object)entryPath);
                                File entryFile = this.archiveUtility.getFile(entryPath);
                                if (jarEntry.isDirectory()) {
                                    if (entryFile.exists()) continue;
                                    LOG.debug("Making directory {}", (Object)entryPath);
                                    if (entryFile.mkdir()) continue;
                                    msg = "Could not create archive entry directory " + entryPath + ".";
                                    view.setStatusDetail((String)msg);
                                    LOG.error((String)msg);
                                    throw new ExtractionException((String)msg);
                                }
                                FileOutputStream fos = this.archiveUtility.getFileOutputStream(entryFile);
                                try {
                                    int n;
                                    LOG.debug("Begin copying from {} to {}", (Object)jarEntry.getName(), (Object)entryPath);
                                    byte[] buffer = new byte[1024];
                                    while ((n = jarInputStream.read(buffer)) > -1) {
                                        fos.write(buffer, 0, n);
                                    }
                                    LOG.debug("Finish copying from {} to {}", (Object)jarEntry.getName(), (Object)entryPath);
                                }
                                finally {
                                    fos.flush();
                                    fos.close();
                                }
                            }
                            finally {
                                jarInputStream.closeEntry();
                            }
                        }
                    }
                } else {
                    msg = "Could not create archive directory " + archivePath + ".";
                    view.setStatusDetail((String)msg);
                    LOG.error((String)msg);
                    throw new ExtractionException((String)msg);
                }
            }
            ViewConfig viewConfig = this.archiveUtility.getViewConfigFromExtractedArchive(archivePath, false);
            return this.getArchiveClassLoader(viewConfig, archiveDir, viewsAdditionalClasspath);
        }
        catch (Exception e) {
            String msg = "Caught exception trying to extract the view archive " + archivePath + ".";
            view.setStatusDetail(msg);
            LOG.error(msg, (Throwable)e);
            throw new ExtractionException(msg, e);
        }
    }

    public boolean ensureExtractedArchiveDirectory(String extractedArchivesPath) {
        File extractedArchiveDir = this.archiveUtility.getFile(extractedArchivesPath);
        return extractedArchiveDir.exists() || extractedArchiveDir.mkdir();
    }

    private ClassLoader getArchiveClassLoader(ViewConfig viewConfig, File archiveDir, List<File> viewsAdditionalClasspath) throws IOException {
        String archivePath = archiveDir.getAbsolutePath();
        LinkedList<URL> urlList = new LinkedList<URL>();
        String classesPath = archivePath + File.separator + ARCHIVE_CLASSES_DIR;
        File classesDir = this.archiveUtility.getFile(classesPath);
        if (classesDir.exists()) {
            urlList.add(classesDir.toURI().toURL());
        }
        for (File file : viewsAdditionalClasspath) {
            if (file.isDirectory()) {
                this.addDirToClasspath(urlList, file);
                continue;
            }
            if (!file.isFile()) continue;
            urlList.add(file.toURI().toURL());
        }
        String libPath = archivePath + File.separator + ARCHIVE_LIB_DIR;
        File libDir = this.archiveUtility.getFile(libPath);
        this.addDirToClasspath(urlList, libDir);
        urlList.add(archiveDir.toURI().toURL());
        LOG.trace("classpath for view {} is : {}", (Object)viewConfig.getName(), urlList);
        return new ViewClassLoader(viewConfig, urlList.toArray(new URL[urlList.size()]));
    }

    private void addDirToClasspath(List<URL> urlList, File libDir) throws MalformedURLException {
        File[] files;
        if (libDir.exists() && (files = libDir.listFiles()) != null) {
            for (File fileEntry : files) {
                if (fileEntry.isDirectory()) continue;
                urlList.add(fileEntry.toURI().toURL());
            }
        }
    }

    public static class ExtractionException
    extends Exception {
        public ExtractionException(String msg) {
            super(msg);
        }

        public ExtractionException(String msg, Throwable throwable) {
            super(msg, throwable);
        }
    }
}

