/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ViewExternalSubResourceProvider
extends AbstractResourceProvider {
    private static final String VIEW_NAME_PROPERTY_ID = "view_name";
    private static final String VIEW_VERSION_PROPERTY_ID = "version";
    private static final String INSTANCE_NAME_PROPERTY_ID = "instance_name";
    private static final String RESOURCE_NAME_PROPERTY_ID = "name";
    private final Resource.Type type;
    private final Set<String> resourceNames = new HashSet<String>();
    private final Set<String> pkPropertyIds;
    private final ViewEntity viewDefinition;

    public ViewExternalSubResourceProvider(Resource.Type type, ViewEntity viewDefinition) {
        super(ViewExternalSubResourceProvider._getPropertyIds(), ViewExternalSubResourceProvider._getKeyPropertyIds(type));
        this.type = type;
        this.pkPropertyIds = new HashSet<String>(this.getKeyPropertyIds().values());
        this.viewDefinition = viewDefinition;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        HashSet<ViewInstanceEntity> instanceDefinitions = new HashSet<ViewInstanceEntity>();
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        int size = propertyMaps.size();
        Collection<ViewInstanceEntity> viewInstanceDefinitions = this.viewDefinition.getInstances();
        if (size == 0) {
            instanceDefinitions.addAll(viewInstanceDefinitions);
        } else {
            for (Map<String, Object> propertyMap : propertyMaps) {
                String instanceName = (String)propertyMap.get(INSTANCE_NAME_PROPERTY_ID);
                if (instanceName == null) {
                    instanceDefinitions.addAll(viewInstanceDefinitions);
                    break;
                }
                instanceDefinitions.add(this.viewDefinition.getInstanceDefinition(instanceName));
            }
        }
        for (ViewInstanceEntity viewInstanceDefinition : instanceDefinitions) {
            for (String resourceName : this.resourceNames) {
                ResourceImpl resource = new ResourceImpl(this.type);
                resource.setProperty(VIEW_NAME_PROPERTY_ID, this.viewDefinition.getCommonName());
                resource.setProperty(VIEW_VERSION_PROPERTY_ID, this.viewDefinition.getVersion());
                resource.setProperty(INSTANCE_NAME_PROPERTY_ID, viewInstanceDefinition.getName());
                resource.setProperty(RESOURCE_NAME_PROPERTY_ID, resourceName);
                resourceSet.add(resource);
            }
        }
        return resourceSet;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return this.pkPropertyIds;
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        return Collections.emptySet();
    }

    public void addResourceName(String resourceName) {
        this.resourceNames.add(resourceName);
    }

    private static Map<Resource.Type, String> _getKeyPropertyIds(Resource.Type type) {
        HashMap<Resource.Type, String> keyPropertyIds = new HashMap<Resource.Type, String>();
        keyPropertyIds.put(Resource.Type.View, VIEW_NAME_PROPERTY_ID);
        keyPropertyIds.put(Resource.Type.ViewVersion, VIEW_VERSION_PROPERTY_ID);
        keyPropertyIds.put(Resource.Type.ViewInstance, INSTANCE_NAME_PROPERTY_ID);
        keyPropertyIds.put(type, RESOURCE_NAME_PROPERTY_ID);
        return keyPropertyIds;
    }

    private static Set<String> _getPropertyIds() {
        HashSet<String> propertyIds = new HashSet<String>();
        propertyIds.add(INSTANCE_NAME_PROPERTY_ID);
        propertyIds.add(VIEW_NAME_PROPERTY_ID);
        propertyIds.add(VIEW_VERSION_PROPERTY_ID);
        propertyIds.add(RESOURCE_NAME_PROPERTY_ID);
        return propertyIds;
    }
}

