/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.utils.Closeables;
import id.onyx.obdp.server.view.DirectoryWatcher;
import id.onyx.obdp.server.view.ViewRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ViewDirectoryWatcher
implements DirectoryWatcher {
    public static final int FIXED_FILE_COUNTER = 30;
    public static final int FILE_CHECK_INTERVAL_MILLIS = 200;
    @Inject
    Configuration configuration;
    @Inject
    ViewRegistry viewRegistry;
    private WatchService watchService;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Future<?> watchTask;
    private static final Logger LOG = LoggerFactory.getLogger(ViewDirectoryWatcher.class);
    private List<Function<Path, Boolean>> hooks = Lists.newArrayList(Collections.singleton(this.loggingHook()));

    public void addHook(Function<Path, Boolean> hook) {
        this.hooks.add(hook);
    }

    private Function<Path, Boolean> loggingHook() {
        return new Function<Path, Boolean>(){

            @Nullable
            public Boolean apply(@Nullable Path path) {
                LOG.info("Finished processing the view definition for" + path);
                return true;
            }
        };
    }

    @Override
    public void start() {
        try {
            Path path = this.buildWatchService();
            Runnable task = this.startWatching(path);
            this.watchTask = this.executorService.submit(task);
        }
        catch (Exception e) {
            LOG.error("There were errors in starting the view directory watcher. This task will not run", (Throwable)e);
        }
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private Runnable startWatching(final Path path) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    WatchKey key;
                    do {
                        key = ViewDirectoryWatcher.this.watchService.take();
                        LOG.info("Watcher Key was signalled");
                        for (WatchEvent<?> event : key.pollEvents()) {
                            LOG.info("Watcher recieved poll event");
                            WatchEvent ev = ViewDirectoryWatcher.cast(event);
                            Path resolvedPath = path.resolve((Path)ev.context());
                            LOG.info(String.format("Event %s: %s\n", ev.kind(), resolvedPath));
                            if (!ViewDirectoryWatcher.this.canBlockTillFileAvailable(resolvedPath)) {
                                LOG.info("Watcher detected that the file was either empty or corrupt");
                                continue;
                            }
                            if (!ViewDirectoryWatcher.this.verify(resolvedPath)) {
                                LOG.info("The uploaded file was 1> Empty 2> Not a regular file or 3> Not a valid Jar archive file");
                                continue;
                            }
                            try {
                                LOG.info("Starting view extraction");
                                ViewDirectoryWatcher.this.viewRegistry.readViewArchive(resolvedPath);
                                for (Function<Path, Boolean> hook : ViewDirectoryWatcher.this.hooks) {
                                    hook.apply((Object)resolvedPath);
                                }
                            }
                            catch (Exception e) {
                                LOG.error("Cannot read the view archive, offending file: " + resolvedPath, (Throwable)e);
                            }
                        }
                    } while (key.reset());
                    LOG.error("The watch key could not be reset, Directory watcher will not run anymore");
                }
                catch (InterruptedException x) {
                    LOG.info("Cancelling the directory watcher", (Throwable)x);
                    return;
                }
            }
        };
    }

    private boolean canBlockTillFileAvailable(Path resolvedPath) throws InterruptedException {
        long emptyCheck;
        int fixed = 0;
        File file = resolvedPath.toAbsolutePath().toFile();
        for (emptyCheck = 0L; file.length() == 0L && emptyCheck < 5L; ++emptyCheck) {
            Thread.sleep(200L);
        }
        if (emptyCheck == 5L) {
            return false;
        }
        long oldLength = file.length();
        while (true) {
            LOG.info("Waiting for file to be completely copied");
            Thread.sleep(200L);
            long newSize = file.length();
            if (newSize > oldLength) {
                oldLength = newSize;
                continue;
            }
            if (oldLength != newSize) {
                return false;
            }
            if (++fixed > 30) break;
        }
        LOG.info("File " + resolvedPath + " has finished copying");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verify(Path resolvedPath) {
        ZipFile zipFile = null;
        try {
            File file = resolvedPath.toAbsolutePath().toFile();
            Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0);
            Preconditions.checkArgument((file.length() > 0L ? 1 : 0) != 0);
            zipFile = new ZipFile(file);
            Closeables.closeSilently(zipFile);
        }
        catch (Exception e) {
            LOG.info("Verification failed ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Closeables.closeSilently(zipFile);
        }
        return true;
    }

    private Path buildWatchService() throws IOException {
        File viewsDir = this.configuration.getViewsDir();
        Path path = Paths.get(viewsDir.getAbsolutePath(), new String[0]);
        this.watchService = path.getFileSystem().newWatchService();
        path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
        return path;
    }

    @Override
    public boolean isRunning() {
        if (this.watchTask != null) {
            return !this.watchTask.isDone();
        }
        return false;
    }

    @Override
    public void stop() {
        this.watchTask.cancel(true);
    }
}

