/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.view.ViewDataMigrationContextImpl;
import id.onyx.obdp.server.view.ViewRegistry;
import id.onyx.obdp.view.PersistenceException;
import id.onyx.obdp.view.ViewInstanceDefinition;
import id.onyx.obdp.view.migration.ViewDataMigrationContext;
import id.onyx.obdp.view.migration.ViewDataMigrationException;
import id.onyx.obdp.view.migration.ViewDataMigrator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewDataMigrationUtility {
    private static final Logger LOG = LoggerFactory.getLogger(ViewDataMigrationUtility.class);
    private ViewRegistry viewRegistry;

    public ViewDataMigrationUtility(ViewRegistry viewRegistry) {
        this.viewRegistry = viewRegistry;
    }

    public void migrateData(ViewInstanceEntity targetInstanceDefinition, ViewInstanceEntity sourceInstanceDefinition, boolean migrateOnce) throws ViewDataMigrationException {
        ViewDataMigrationContextImpl migrationContext = this.getViewDataMigrationContext(targetInstanceDefinition, sourceInstanceDefinition);
        if (migrateOnce && !this.isTargetEmpty(migrationContext)) {
            LOG.error("Migration canceled because target instance is not empty");
            return;
        }
        ViewDataMigrator dataMigrator = this.getViewDataMigrator(targetInstanceDefinition, migrationContext);
        LOG.debug("Running before-migration hook");
        if (!dataMigrator.beforeMigration()) {
            String msg = "View " + targetInstanceDefinition.getInstanceName() + " canceled the migration process";
            LOG.error(msg);
            throw new ViewDataMigrationException(msg);
        }
        Map<String, Class> originClasses = migrationContext.getOriginEntityClasses();
        Map<String, Class> currentClasses = migrationContext.getCurrentEntityClasses();
        for (Map.Entry<String, Class> originEntity : originClasses.entrySet()) {
            LOG.debug("Migrating persistence entity {}", (Object)originEntity.getKey());
            if (currentClasses.containsKey(originEntity.getKey())) {
                Class entity = currentClasses.get(originEntity.getKey());
                dataMigrator.migrateEntity(originEntity.getValue(), entity);
                continue;
            }
            LOG.debug("Entity {} not found in target view", (Object)originEntity.getKey());
            dataMigrator.migrateEntity(originEntity.getValue(), null);
        }
        LOG.debug("Migrating instance data");
        dataMigrator.migrateInstanceData();
        LOG.debug("Running after-migration hook");
        dataMigrator.afterMigration();
        LOG.debug("Copying user permissions");
        this.viewRegistry.copyPrivileges(sourceInstanceDefinition, targetInstanceDefinition);
        migrationContext.putCurrentInstanceData("upgrade", "upgradedFrom", sourceInstanceDefinition.getViewEntity().getVersion());
        migrationContext.closeMigration();
    }

    private boolean isTargetEmpty(ViewDataMigrationContext migrationContext) {
        if (migrationContext.getCurrentInstanceDataByUser().size() > 0) {
            return false;
        }
        try {
            for (Class entity : migrationContext.getCurrentEntityClasses().values()) {
                if (migrationContext.getCurrentDataStore().findAll(entity, null).size() <= 0) continue;
                return false;
            }
        }
        catch (PersistenceException e) {
            ViewInstanceDefinition current = migrationContext.getCurrentInstanceDefinition();
            LOG.error("Persistence exception while check if instance is empty: " + current.getViewDefinition().getViewName() + "{" + current.getViewDefinition().getVersion() + "}/" + current.getInstanceName(), (Throwable)e);
        }
        return true;
    }

    protected ViewDataMigrationContextImpl getViewDataMigrationContext(ViewInstanceEntity targetInstanceDefinition, ViewInstanceEntity sourceInstanceDefinition) {
        return new ViewDataMigrationContextImpl(sourceInstanceDefinition, targetInstanceDefinition);
    }

    protected ViewDataMigrator getViewDataMigrator(ViewInstanceEntity currentInstanceDefinition, ViewDataMigrationContextImpl migrationContext) throws ViewDataMigrationException {
        ViewDataMigrator dataMigrator;
        LOG.info("Migrating " + currentInstanceDefinition.getInstanceName() + " data from " + migrationContext.getOriginDataVersion() + " to " + migrationContext.getCurrentDataVersion() + " data version");
        if (migrationContext.getOriginDataVersion() == migrationContext.getCurrentDataVersion()) {
            LOG.info("Instances of same version, copying all data.");
            dataMigrator = new CopyAllDataMigrator(migrationContext);
        } else {
            try {
                dataMigrator = currentInstanceDefinition.getDataMigrator(migrationContext);
                if (dataMigrator == null) {
                    throw new ViewDataMigrationException("A view instance " + currentInstanceDefinition.getInstanceName() + " does not support migration.");
                }
                LOG.debug("Data migrator loaded");
            }
            catch (ClassNotFoundException e) {
                String msg = "Caught exception loading data migrator of " + currentInstanceDefinition.getInstanceName();
                LOG.error(msg, (Throwable)e);
                throw new RuntimeException(msg);
            }
        }
        return dataMigrator;
    }

    public static class CopyAllDataMigrator
    implements ViewDataMigrator {
        private ViewDataMigrationContext migrationContext;

        public CopyAllDataMigrator(ViewDataMigrationContext migrationContext) {
            this.migrationContext = migrationContext;
        }

        public boolean beforeMigration() {
            return true;
        }

        public void afterMigration() {
        }

        public void migrateEntity(Class originEntityClass, Class currentEntityClass) throws ViewDataMigrationException {
            if (currentEntityClass == null) {
                return;
            }
            this.migrationContext.copyAllObjects(originEntityClass, currentEntityClass);
        }

        public void migrateInstanceData() {
            this.migrationContext.copyAllInstanceData();
        }
    }
}

