/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceDataEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.view.configuration.EntityConfig;
import id.onyx.obdp.server.view.configuration.PersistenceConfig;
import id.onyx.obdp.server.view.persistence.DataStoreImpl;
import id.onyx.obdp.server.view.persistence.DataStoreModule;
import id.onyx.obdp.view.DataStore;
import id.onyx.obdp.view.PersistenceException;
import id.onyx.obdp.view.migration.EntityConverter;
import id.onyx.obdp.view.migration.ViewDataMigrationContext;
import id.onyx.obdp.view.migration.ViewDataMigrationException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ViewDataMigrationContextImpl
implements ViewDataMigrationContext {
    private static final Logger LOG = LoggerFactory.getLogger(ViewDataMigrationContextImpl.class);
    private DataStore originDataStore;
    private DataStore currentDataStore;
    private final ViewInstanceEntity originInstanceDefinition;
    private final ViewInstanceEntity currentInstanceDefinition;
    private Map<ViewInstanceEntity, DataStoreModule> dataStoreModules = new WeakHashMap<ViewInstanceEntity, DataStoreModule>();

    public ViewDataMigrationContextImpl(ViewInstanceEntity originInstanceDefinition, ViewInstanceEntity currentInstanceDefinition) {
        this.originInstanceDefinition = originInstanceDefinition;
        this.currentInstanceDefinition = currentInstanceDefinition;
    }

    protected DataStore getDataStore(ViewInstanceEntity instanceDefinition) {
        if (!this.dataStoreModules.containsKey(instanceDefinition)) {
            DataStoreModule module = new DataStoreModule(instanceDefinition, "ambari-view-migration");
            this.dataStoreModules.put(instanceDefinition, module);
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{this.dataStoreModules.get(instanceDefinition)});
        return (DataStore)injector.getInstance(DataStoreImpl.class);
    }

    public int getCurrentDataVersion() {
        return this.currentInstanceDefinition.getViewEntity().getConfiguration().getDataVersion();
    }

    public int getOriginDataVersion() {
        return this.originInstanceDefinition.getViewEntity().getConfiguration().getDataVersion();
    }

    public DataStore getOriginDataStore() {
        if (this.originDataStore == null) {
            this.originDataStore = this.getDataStore(this.originInstanceDefinition);
        }
        return this.originDataStore;
    }

    public DataStore getCurrentDataStore() {
        if (this.currentDataStore == null) {
            this.currentDataStore = this.getDataStore(this.currentInstanceDefinition);
        }
        return this.currentDataStore;
    }

    @Transactional
    public void putCurrentInstanceData(String user, String key, String value) {
        ViewDataMigrationContextImpl.putInstanceData(this.currentInstanceDefinition, user, key, value);
    }

    public void copyAllObjects(Class originEntityClass, Class currentEntityClass) throws ViewDataMigrationException {
        this.copyAllObjects(originEntityClass, currentEntityClass, new EntityConverter(){

            public void convert(Object orig, Object dest) {
                BeanUtils.copyProperties((Object)orig, (Object)dest);
            }
        });
    }

    @Transactional
    public void copyAllObjects(Class originEntityClass, Class currentEntityClass, EntityConverter entityConverter) throws ViewDataMigrationException {
        try {
            for (Object origInstance : this.getOriginDataStore().findAll(originEntityClass, null)) {
                Object newInstance = currentEntityClass.newInstance();
                entityConverter.convert(origInstance, newInstance);
                this.getCurrentDataStore().store(newInstance);
            }
        }
        catch (PersistenceException | IllegalAccessException | InstantiationException e) {
            String msg = "Error occured during copying data. Persistence entities are not compatible.";
            LOG.error(msg);
            throw new ViewDataMigrationException(msg, e);
        }
    }

    public void copyAllInstanceData() {
        for (Map.Entry<String, Map<String, String>> userData : this.getOriginInstanceDataByUser().entrySet()) {
            for (Map.Entry<String, String> entry : userData.getValue().entrySet()) {
                this.putCurrentInstanceData(userData.getKey(), entry.getKey(), entry.getValue());
            }
        }
    }

    public ViewInstanceEntity getOriginInstanceDefinition() {
        return this.originInstanceDefinition;
    }

    public Map<String, Class> getOriginEntityClasses() {
        ViewEntity viewDefinition = this.originInstanceDefinition.getViewEntity();
        return ViewDataMigrationContextImpl.getPersistenceClassesOfView(viewDefinition);
    }

    public Map<String, Class> getCurrentEntityClasses() {
        ViewEntity viewDefinition = this.currentInstanceDefinition.getViewEntity();
        return ViewDataMigrationContextImpl.getPersistenceClassesOfView(viewDefinition);
    }

    private static Map<String, Class> getPersistenceClassesOfView(ViewEntity viewDefinition) {
        PersistenceConfig persistence = viewDefinition.getConfiguration().getPersistence();
        HashMap<String, Class> classes = new HashMap<String, Class>();
        if (persistence != null) {
            for (EntityConfig c : persistence.getEntities()) {
                try {
                    Class<?> entity = viewDefinition.getClassLoader().loadClass(c.getClassName());
                    classes.put(c.getClassName(), entity);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return classes;
    }

    public ViewInstanceEntity getCurrentInstanceDefinition() {
        return this.currentInstanceDefinition;
    }

    public Map<String, Map<String, String>> getOriginInstanceDataByUser() {
        return ViewDataMigrationContextImpl.getInstanceDataByUser(this.originInstanceDefinition);
    }

    @Transactional
    public void putOriginInstanceData(String user, String key, String value) {
        ViewDataMigrationContextImpl.putInstanceData(this.originInstanceDefinition, user, key, value);
    }

    public Map<String, Map<String, String>> getCurrentInstanceDataByUser() {
        return ViewDataMigrationContextImpl.getInstanceDataByUser(this.currentInstanceDefinition);
    }

    public void closeMigration() {
        for (DataStoreModule module : this.dataStoreModules.values()) {
            module.close();
        }
        this.dataStoreModules.clear();
    }

    private static void putInstanceData(ViewInstanceEntity instanceDefinition, String user, String name, String value) {
        ViewInstanceDataEntity oldInstanceDataEntity = ViewDataMigrationContextImpl.getInstanceData(instanceDefinition, user, name);
        if (oldInstanceDataEntity != null) {
            instanceDefinition.getData().remove(oldInstanceDataEntity);
        }
        ViewInstanceDataEntity instanceDataEntity = new ViewInstanceDataEntity();
        instanceDataEntity.setViewName(instanceDefinition.getViewName());
        instanceDataEntity.setViewInstanceName(instanceDefinition.getName());
        instanceDataEntity.setName(name);
        instanceDataEntity.setUser(user);
        instanceDataEntity.setValue(value);
        instanceDataEntity.setViewInstanceEntity(instanceDefinition);
        instanceDefinition.getData().add(instanceDataEntity);
    }

    private static ViewInstanceDataEntity getInstanceData(ViewInstanceEntity instanceDefinition, String user, String key) {
        for (ViewInstanceDataEntity viewInstanceDataEntity : instanceDefinition.getData()) {
            if (!viewInstanceDataEntity.getName().equals(key) || !viewInstanceDataEntity.getUser().equals(user)) continue;
            return viewInstanceDataEntity;
        }
        return null;
    }

    private static Map<String, Map<String, String>> getInstanceDataByUser(ViewInstanceEntity instanceDefinition) {
        HashMap<String, Map<String, String>> instanceDataByUser = new HashMap<String, Map<String, String>>();
        for (ViewInstanceDataEntity entity : instanceDefinition.getData()) {
            if (!instanceDataByUser.containsKey(entity.getUser())) {
                instanceDataByUser.put(entity.getUser(), new HashMap());
            }
            ((Map)instanceDataByUser.get(entity.getUser())).put(entity.getName(), entity.getValue());
        }
        return instanceDataByUser;
    }
}

