/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.view.HttpImpersonatorImpl;
import id.onyx.obdp.server.view.ImpersonatorSettingImpl;
import id.onyx.obdp.server.view.ViewRegistry;
import id.onyx.obdp.server.view.configuration.ParameterConfig;
import id.onyx.obdp.server.view.configuration.ViewConfig;
import id.onyx.obdp.server.view.events.EventImpl;
import id.onyx.obdp.server.view.persistence.DataStoreImpl;
import id.onyx.obdp.server.view.persistence.DataStoreModule;
import id.onyx.obdp.server.view.validation.ValidationException;
import id.onyx.obdp.view.AmbariStreamProvider;
import id.onyx.obdp.view.ClusterType;
import id.onyx.obdp.view.DataStore;
import id.onyx.obdp.view.ImpersonatorSetting;
import id.onyx.obdp.view.MaskException;
import id.onyx.obdp.view.Masker;
import id.onyx.obdp.view.ResourceProvider;
import id.onyx.obdp.view.SecurityException;
import id.onyx.obdp.view.SystemException;
import id.onyx.obdp.view.URLConnectionProvider;
import id.onyx.obdp.view.URLStreamProvider;
import id.onyx.obdp.view.ViewContext;
import id.onyx.obdp.view.ViewController;
import id.onyx.obdp.view.ViewDefinition;
import id.onyx.obdp.view.ViewInstanceDefinition;
import id.onyx.obdp.view.cluster.Cluster;
import id.onyx.obdp.view.events.Listener;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.directory.api.util.Strings;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewContextImpl
implements ViewContext,
ViewController {
    private static final Logger LOG = LoggerFactory.getLogger(ViewContextImpl.class);
    public static final String HADOOP_SECURITY_AUTH_TO_LOCAL = "hadoop.security.auth_to_local";
    public static final String CORE_SITE = "core-site";
    public static final String HDFS_AUTH_TO_LOCAL = "hdfs.auth_to_local";
    private final ViewEntity viewEntity;
    private final ViewInstanceEntity viewInstanceEntity;
    private final ViewRegistry viewRegistry;
    private DataStore dataStore = null;
    private Masker masker;
    private final VelocityContext velocityContext;

    public ViewContextImpl(ViewInstanceEntity viewInstanceEntity, ViewRegistry viewRegistry) {
        this(viewInstanceEntity.getViewEntity(), viewInstanceEntity, viewRegistry);
    }

    public ViewContextImpl(ViewEntity viewEntity, ViewRegistry viewRegistry) {
        this(viewEntity, null, viewRegistry);
    }

    private ViewContextImpl(ViewEntity viewEntity, ViewInstanceEntity viewInstanceEntity, ViewRegistry viewRegistry) {
        this.viewEntity = viewEntity;
        this.viewInstanceEntity = viewInstanceEntity;
        this.viewRegistry = viewRegistry;
        this.masker = this.getMasker(viewEntity.getClassLoader(), viewEntity.getConfiguration());
        this.velocityContext = this.initVelocityContext();
    }

    public String getViewName() {
        return this.viewEntity.getCommonName();
    }

    public ViewDefinition getViewDefinition() {
        return this.viewEntity;
    }

    public String getInstanceName() {
        return this.viewInstanceEntity == null ? null : this.viewInstanceEntity.getName();
    }

    public ViewInstanceDefinition getViewInstanceDefinition() {
        return this.viewInstanceEntity;
    }

    public Map<String, String> getProperties() {
        if (this.viewInstanceEntity == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.getPropertyValues());
    }

    @Transactional
    public void putInstanceData(String key, String value) {
        this.checkInstance();
        ViewInstanceEntity updateInstance = this.viewRegistry.getViewInstanceEntity(this.viewInstanceEntity.getViewName(), this.viewInstanceEntity.getInstanceName());
        if (updateInstance != null) {
            updateInstance.putInstanceData(key, value);
            try {
                this.viewRegistry.updateViewInstance(updateInstance);
            }
            catch (SystemException e) {
                String msg = "Caught exception updating the view instance.";
                LOG.error(msg, (Throwable)e);
                throw new IllegalStateException(msg, e);
            }
            catch (ValidationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public String getInstanceData(String key) {
        return this.viewInstanceEntity == null ? null : this.viewInstanceEntity.getInstanceDataMap().get(key);
    }

    public Map<String, String> getInstanceData() {
        return this.viewInstanceEntity == null ? null : Collections.unmodifiableMap(this.viewInstanceEntity.getInstanceDataMap());
    }

    public void removeInstanceData(String key) {
        this.checkInstance();
        this.viewRegistry.removeInstanceData(this.viewInstanceEntity, key);
    }

    public String getAmbariProperty(String key) {
        return this.viewInstanceEntity == null ? null : this.viewInstanceEntity.getViewEntity().getAmbariProperty(key);
    }

    public ResourceProvider<?> getResourceProvider(String type) {
        return this.viewInstanceEntity == null ? null : this.viewInstanceEntity.getResourceProvider(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getUsername() {
        String shortName = this.getLoggedinUser();
        try {
            String authToLocalRules = this.getAuthToLocalRules();
            String defaultRealm = KerberosUtil.getDefaultRealm();
            if (!Strings.isNotEmpty((String)authToLocalRules)) return shortName;
            if (!Strings.isNotEmpty((String)defaultRealm)) return shortName;
            Class<KerberosName> clazz = KerberosName.class;
            synchronized (KerberosName.class) {
                KerberosName.setRules((String)authToLocalRules);
                return new KerberosName(shortName + "@" + defaultRealm).getShortName();
            }
        }
        catch (InvocationTargetException e) {
            LOG.debug("Failed to get default realm", (Throwable)e);
            return shortName;
        }
        catch (Exception e) {
            LOG.warn("Failed to apply auth_to_local rules. " + e.getMessage());
            LOG.debug("Failed to apply auth_to_local rules", (Throwable)e);
        }
        return shortName;
    }

    private String getAuthToLocalRules() {
        Cluster cluster = this.getCluster();
        String authToLocalRules = null;
        if (cluster != null) {
            authToLocalRules = cluster.getConfigurationValue(CORE_SITE, HADOOP_SECURITY_AUTH_TO_LOCAL);
        } else if (this.viewInstanceEntity != null) {
            authToLocalRules = this.viewInstanceEntity.getPropertyMap().get(HDFS_AUTH_TO_LOCAL);
        }
        return authToLocalRules;
    }

    public String getLoggedinUser() {
        return this.viewInstanceEntity != null ? this.viewInstanceEntity.getUsername() : null;
    }

    public void hasPermission(String userName, String permissionName) throws SecurityException {
        if (userName == null || userName.length() == 0) {
            throw new SecurityException("No user name specified.");
        }
        if (permissionName == null || permissionName.length() == 0) {
            throw new SecurityException("No permission name specified.");
        }
        if (this.viewInstanceEntity == null) {
            throw new SecurityException("There is no instance associated with the view context");
        }
        PermissionEntity permissionEntity = this.viewEntity.getPermission(permissionName);
        if (permissionEntity == null) {
            throw new SecurityException("The permission " + permissionName + " is not defined for " + this.viewEntity.getName());
        }
        if (!this.viewRegistry.hasPermission(permissionEntity, this.viewInstanceEntity.getResource(), userName)) {
            throw new SecurityException("The user " + userName + " has not been granted permission " + permissionName);
        }
    }

    public URLStreamProvider getURLStreamProvider() {
        return this.viewRegistry.createURLStreamProvider(this);
    }

    public URLConnectionProvider getURLConnectionProvider() {
        return this.viewRegistry.createURLStreamProvider(this);
    }

    public synchronized AmbariStreamProvider getAmbariStreamProvider() {
        return this.viewRegistry.createAmbariStreamProvider();
    }

    public AmbariStreamProvider getAmbariClusterStreamProvider() {
        Long clusterHandle = this.viewInstanceEntity.getClusterHandle();
        ClusterType clusterType = this.viewInstanceEntity.getClusterType();
        AmbariStreamProvider clusterStreamProvider = null;
        if (clusterHandle != null && clusterType == ClusterType.LOCAL_OBDP) {
            clusterStreamProvider = this.getAmbariStreamProvider();
        } else if (clusterHandle != null && clusterType == ClusterType.REMOTE_OBDP) {
            clusterStreamProvider = this.viewRegistry.createRemoteAmbariStreamProvider(clusterHandle);
        }
        return clusterStreamProvider;
    }

    public synchronized DataStore getDataStore() {
        if (this.viewInstanceEntity != null && this.dataStore == null) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new DataStoreModule(this.viewInstanceEntity)});
            this.dataStore = (DataStore)injector.getInstance(DataStoreImpl.class);
        }
        return this.dataStore;
    }

    public Collection<ViewDefinition> getViewDefinitions() {
        return Collections.unmodifiableCollection(this.viewRegistry.getDefinitions());
    }

    public Collection<ViewInstanceDefinition> getViewInstanceDefinitions() {
        HashSet<ViewInstanceEntity> instanceDefinitions = new HashSet<ViewInstanceEntity>();
        for (ViewEntity viewEntity : this.viewRegistry.getDefinitions()) {
            instanceDefinitions.addAll(this.viewRegistry.getInstanceDefinitions(viewEntity));
        }
        return Collections.unmodifiableCollection(instanceDefinitions);
    }

    public ViewController getController() {
        return this;
    }

    public HttpImpersonatorImpl getHttpImpersonator() {
        return new HttpImpersonatorImpl(this);
    }

    public ImpersonatorSetting getImpersonatorSetting() {
        return new ImpersonatorSettingImpl(this);
    }

    public Cluster getCluster() {
        return this.viewRegistry.getCluster(this.viewInstanceEntity);
    }

    public void fireEvent(String eventId, Map<String, String> eventProperties) {
        EventImpl event = this.viewInstanceEntity == null ? new EventImpl(eventId, eventProperties, this.viewEntity) : new EventImpl(eventId, eventProperties, this.viewInstanceEntity);
        this.viewRegistry.fireEvent(event);
    }

    public void registerListener(Listener listener, String viewName) {
        this.viewRegistry.registerListener(listener, viewName, null);
    }

    public void registerListener(Listener listener, String viewName, String viewVersion) {
        this.viewRegistry.registerListener(listener, viewName, viewVersion);
    }

    public void unregisterListener(Listener listener, String viewName) {
        this.viewRegistry.unregisterListener(listener, viewName, null);
    }

    public void unregisterListener(Listener listener, String viewName, String viewVersion) {
        this.viewRegistry.unregisterListener(listener, viewName, viewVersion);
    }

    private void checkInstance() {
        if (this.viewInstanceEntity == null) {
            throw new IllegalStateException("No instance is associated with the context.");
        }
    }

    private Masker getMasker(ClassLoader cl, ViewConfig viewConfig) {
        try {
            return viewConfig.getMaskerClass(cl).newInstance();
        }
        catch (Exception e) {
            throw new InstantiationError("Could not create masker instance.");
        }
    }

    private Map<String, String> getPropertyValues() {
        Map<String, String> properties = this.viewInstanceEntity.getPropertyMap();
        HashMap<String, ParameterConfig> parameters = new HashMap<String, ParameterConfig>();
        for (ParameterConfig paramConfig : this.viewEntity.getConfiguration().getParameters()) {
            parameters.put(paramConfig.getName(), paramConfig);
        }
        Cluster cluster = this.getCluster();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            ParameterConfig parameterConfig = (ParameterConfig)parameters.get(propertyName);
            if (parameterConfig != null) {
                String clusterConfig = parameterConfig.getClusterConfig();
                if (clusterConfig != null && cluster != null) {
                    propertyValue = ViewContextImpl.getClusterConfigurationValue(cluster, clusterConfig);
                } else if (parameterConfig.isMasked()) {
                    try {
                        propertyValue = this.masker.unmask(propertyValue);
                    }
                    catch (MaskException e) {
                        LOG.error("Failed to unmask view property", (Throwable)e);
                    }
                }
            }
            properties.put(propertyName, this.evaluatePropertyTemplates(propertyValue));
        }
        return properties;
    }

    private static String getClusterConfigurationValue(Cluster cluster, String clusterConfig) {
        String[] parts;
        if (clusterConfig != null && (parts = clusterConfig.split("/")).length == 2) {
            return cluster.getConfigurationValue(parts[0], parts[1]);
        }
        return null;
    }

    private String evaluatePropertyTemplates(String rawValue) {
        if (rawValue != null) {
            try {
                StringWriter templateWriter = new StringWriter();
                Velocity.evaluate((Context)this.velocityContext, (Writer)templateWriter, (String)rawValue, (String)rawValue);
                return ((Object)templateWriter).toString();
            }
            catch (ParseErrorException e) {
                LOG.warn(String.format("Error during parsing '%s' parameter. Leaving original value.", rawValue));
            }
        }
        return rawValue;
    }

    private VelocityContext initVelocityContext() {
        VelocityContext context = new VelocityContext();
        context.put("username", (Object)new ParameterResolver(){

            @Override
            protected String getValue() {
                return this.viewContext.getUsername();
            }
        });
        context.put("viewName", (Object)new ParameterResolver(){

            @Override
            protected String getValue() {
                return this.viewContext.getViewName();
            }
        });
        context.put("instanceName", (Object)new ParameterResolver(){

            @Override
            protected String getValue() {
                return this.viewContext.getInstanceName();
            }
        });
        context.put("loggedinUser", (Object)new ParameterResolver(){

            @Override
            protected String getValue() {
                return this.viewContext.getLoggedinUser();
            }
        });
        return context;
    }

    private abstract class ParameterResolver {
        protected final ViewContext viewContext;

        private ParameterResolver() {
            this.viewContext = ViewContextImpl.this;
        }

        protected abstract String getValue();

        public String toString() {
            String value = this.getValue();
            return value == null ? "" : value;
        }
    }
}

