/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.view.configuration.ViewConfig;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class ViewClassLoader
extends WebAppClassLoader {
    public ViewClassLoader(ViewConfig viewConfig, URL[] urls) throws IOException {
        this(viewConfig, null, urls);
    }

    public ViewClassLoader(ViewConfig viewConfig, ClassLoader parent, URL[] urls) throws IOException {
        super(parent, (WebAppClassLoader.Context)ViewClassLoader.getInitContext(viewConfig));
        for (URL url : urls) {
            this.addURL(url);
        }
    }

    private static WebAppContext getInitContext(ViewConfig viewConfig) throws IOException {
        String extraClasspath;
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.getSystemClassMatcher().add("id.onyx.obdp.server.");
        webAppContext.getSystemClassMatcher().add("id.onyx.obdp.view.");
        webAppContext.getSystemClassMatcher().add("com.google.inject.");
        webAppContext.getSystemClassMatcher().add("org.slf4j.");
        webAppContext.getSystemClassMatcher().add("com.sun.jersey.");
        webAppContext.getSystemClassMatcher().add("org.apache.velocity.");
        if (viewConfig != null && (extraClasspath = viewConfig.getExtraClasspath()) != null) {
            webAppContext.setExtraClasspath(extraClasspath);
        }
        return webAppContext;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        System.out.println("Attempting to load class: " + name);
        try {
            Class loadedClass = super.loadClass(name);
            System.out.println("Class loaded successfully: " + name + " by " + this);
            return loadedClass;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found in current loader: " + name + ", delegating to parent.");
            if (this.getParent() != null) {
                Class<?> parentLoadedClass = this.getParent().loadClass(name);
                System.out.println("Class loaded successfully by parent: " + name);
                return parentLoadedClass;
            }
            System.out.println("Class not found: " + name + " in both current and parent class loaders.");
            throw e;
        }
    }
}

