/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.view.configuration.ViewConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class ViewArchiveUtility {
    private static final String VIEW_XML = "view.xml";
    private static final String WEB_INF_VIEW_XML = "WEB-INF/classes/view.xml";
    private static final String VIEW_XSD = "view.xsd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewConfig getViewConfigFromArchive(File archiveFile) throws JAXBException, IOException {
        URLClassLoader cl = URLClassLoader.newInstance(new URL[]{archiveFile.toURI().toURL()}, null);
        InputStream configStream = ((ClassLoader)cl).getResourceAsStream(VIEW_XML);
        if (configStream == null && (configStream = ((ClassLoader)cl).getResourceAsStream(WEB_INF_VIEW_XML)) == null) {
            throw new IllegalStateException(String.format("Archive %s doesn't contain a view descriptor.", archiveFile.getAbsolutePath()));
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ViewConfig.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            ViewConfig viewConfig = (ViewConfig)jaxbUnmarshaller.unmarshal(configStream);
            return viewConfig;
        }
        finally {
            configStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewConfig getViewConfigFromExtractedArchive(String archivePath, boolean validate) throws JAXBException, IOException, SAXException {
        File configFile = new File(archivePath + File.separator + VIEW_XML);
        if (!configFile.exists()) {
            configFile = new File(archivePath + File.separator + WEB_INF_VIEW_XML);
        }
        if (validate) {
            this.validateConfig(new FileInputStream(configFile));
        }
        try (FileInputStream configStream = new FileInputStream(configFile);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ViewConfig.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            ViewConfig viewConfig = (ViewConfig)jaxbUnmarshaller.unmarshal((InputStream)configStream);
            return viewConfig;
        }
    }

    public File getFile(String path) {
        return new File(path);
    }

    public FileOutputStream getFileOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    public JarInputStream getJarFileStream(File file) throws IOException {
        return new JarInputStream(new FileInputStream(file));
    }

    protected void validateConfig(InputStream configStream) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = this.getClass().getClassLoader().getResource(VIEW_XSD);
        Schema schema = schemaFactory.newSchema(schemaUrl);
        schema.newValidator().validate(new StreamSource(configStream));
    }
}

