/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPSessionManager;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.proxy.ProxyService;
import id.onyx.obdp.view.AmbariHttpException;
import id.onyx.obdp.view.AmbariStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewAmbariStreamProvider
implements AmbariStreamProvider {
    private final URLStreamProvider streamProvider;
    private final OBDPSessionManager ambariSessionManager;
    private final OBDPManagementController controller;
    private static final Logger LOG = LoggerFactory.getLogger(ViewAmbariStreamProvider.class);

    protected ViewAmbariStreamProvider(URLStreamProvider streamProvider, OBDPSessionManager ambariSessionManager, OBDPManagementController controller) {
        this.streamProvider = streamProvider;
        this.ambariSessionManager = ambariSessionManager;
        this.controller = controller;
    }

    public InputStream readFrom(String path, String requestMethod, String body, Map<String, String> headers) throws IOException, AmbariHttpException {
        return this.getInputStream(path, requestMethod, headers, body == null ? null : body.getBytes());
    }

    public InputStream readFrom(String path, String requestMethod, InputStream body, Map<String, String> headers) throws IOException, AmbariHttpException {
        return this.getInputStream(path, requestMethod, headers, body == null ? null : IOUtils.toByteArray((InputStream)body));
    }

    private InputStream getInputStream(String path, String requestMethod, Map<String, String> headers, byte[] body) throws IOException, AmbariHttpException {
        String sessionId = this.ambariSessionManager.getCurrentSessionId();
        if (sessionId != null) {
            String ambariSessionCookie = this.ambariSessionManager.getSessionCookie() + "=" + sessionId;
            if (headers == null || headers.isEmpty()) {
                headers = Collections.singletonMap("Cookie", ambariSessionCookie);
            } else {
                headers = new HashMap<String, String>(headers);
                String cookies = (String)headers.get("Cookie");
                headers.put("Cookie", URLStreamProvider.appendCookie(cookies, ambariSessionCookie));
            }
        }
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            headerMap.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        return this.getInputStream(this.streamProvider.processURL(this.controller.getAmbariServerURI((String)(path.startsWith("/") ? path : "/" + path)), requestMethod, body, headerMap));
    }

    private InputStream getInputStream(HttpURLConnection connection) throws IOException, AmbariHttpException {
        int responseCode = connection.getResponseCode();
        if (responseCode >= ProxyService.HTTP_ERROR_RANGE_START) {
            String message = connection.getResponseMessage();
            if (connection.getErrorStream() != null) {
                message = IOUtils.toString((InputStream)connection.getErrorStream());
            }
            LOG.error("Got error response for url {}. Response code:{}. {}", new Object[]{connection.getURL(), responseCode, message});
            throw new AmbariHttpException(message, responseCode);
        }
        return connection.getInputStream();
    }
}

