/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.dao.RemoteOBDPClusterDAO;
import id.onyx.obdp.server.orm.entities.RemoteOBDPClusterEntity;
import id.onyx.obdp.server.orm.entities.RemoteOBDPClusterServiceEntity;
import id.onyx.obdp.server.view.RemoteAmbariCluster;
import id.onyx.obdp.view.AmbariHttpException;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class RemoteOBDPClusterRegistry {
    private ConcurrentHashMap<Long, RemoteAmbariCluster> clusterMap = new ConcurrentHashMap();
    @Inject
    private RemoteOBDPClusterDAO remoteOBDPClusterDAO;
    @Inject
    private Configuration configuration;

    public RemoteAmbariCluster get(Long clusterId) throws MalformedURLException, ClusterNotFoundException {
        RemoteAmbariCluster remoteAmbariCluster = this.clusterMap.get(clusterId);
        if (remoteAmbariCluster == null) {
            RemoteAmbariCluster cluster = this.getCluster(clusterId);
            RemoteAmbariCluster oldCluster = this.clusterMap.putIfAbsent(clusterId, cluster);
            remoteAmbariCluster = oldCluster == null ? cluster : oldCluster;
        }
        return remoteAmbariCluster;
    }

    private RemoteAmbariCluster getCluster(Long clusterId) throws MalformedURLException, ClusterNotFoundException {
        RemoteOBDPClusterEntity remoteAmbariClusterEntity = this.remoteOBDPClusterDAO.findById(clusterId);
        if (remoteAmbariClusterEntity == null) {
            throw new ClusterNotFoundException(clusterId);
        }
        RemoteAmbariCluster remoteAmbariCluster = new RemoteAmbariCluster(remoteAmbariClusterEntity, this.configuration);
        return remoteAmbariCluster;
    }

    public void update(RemoteOBDPClusterEntity entity) {
        this.remoteOBDPClusterDAO.update(entity);
        this.clusterMap.remove(entity.getId());
    }

    public void delete(RemoteOBDPClusterEntity entity) {
        this.remoteOBDPClusterDAO.delete(entity);
        this.clusterMap.remove(entity.getId());
    }

    public void saveOrUpdate(RemoteOBDPClusterEntity entity, boolean update) throws IOException, AmbariHttpException {
        RemoteAmbariCluster cluster = new RemoteAmbariCluster(entity, this.configuration);
        Set<String> services = cluster.getServices();
        if (!cluster.isAmbariOrClusterAdmin()) {
            throw new OBDPException("User must be Ambari or Cluster Adminstrator.");
        }
        ArrayList<RemoteOBDPClusterServiceEntity> serviceEntities = new ArrayList<RemoteOBDPClusterServiceEntity>();
        for (String service : services) {
            RemoteOBDPClusterServiceEntity serviceEntity = new RemoteOBDPClusterServiceEntity();
            serviceEntity.setServiceName(service);
            serviceEntity.setCluster(entity);
            serviceEntities.add(serviceEntity);
        }
        entity.setServices(serviceEntities);
        if (update) {
            this.update(entity);
        } else {
            this.remoteOBDPClusterDAO.save(entity);
        }
    }
}

