/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.proxy.ProxyService;
import id.onyx.obdp.view.AmbariHttpException;
import id.onyx.obdp.view.AmbariStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class RemoteAmbariStreamProvider
implements AmbariStreamProvider {
    private String baseUrl;
    private String username;
    private String password;
    private URLStreamProvider urlStreamProvider;

    public RemoteAmbariStreamProvider(String baseUrl, String username, String password, int connectTimeout, int readTimeout) {
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
        ComponentSSLConfiguration sslConfiguration = ComponentSSLConfiguration.instance();
        this.urlStreamProvider = new URLStreamProvider(connectTimeout, readTimeout, sslConfiguration.getTruststorePath(), sslConfiguration.getTruststorePassword(), sslConfiguration.getTruststoreType());
    }

    public InputStream readFrom(String path, String requestMethod, String body, Map<String, String> headers) throws IOException, AmbariHttpException {
        return this.getInputStream(this.urlStreamProvider.processURL(this.getUrl(path), requestMethod, body, this.addHeaders(headers)));
    }

    public InputStream readFrom(String path, String requestMethod, InputStream body, Map<String, String> headers) throws IOException, AmbariHttpException {
        return this.getInputStream(this.urlStreamProvider.processURL(this.getUrl(path), requestMethod, body, this.addHeaders(headers)));
    }

    private InputStream getInputStream(HttpURLConnection connection) throws IOException, AmbariHttpException {
        int responseCode = connection.getResponseCode();
        if (responseCode >= ProxyService.HTTP_ERROR_RANGE_START) {
            throw new AmbariHttpException(IOUtils.toString((InputStream)connection.getErrorStream()), responseCode);
        }
        return connection.getInputStream();
    }

    private String getUrl(String path) {
        String basePath = this.baseUrl;
        return path.startsWith("/") ? basePath + path : basePath + "/" + path;
    }

    private void addRequestedByHeaders(HashMap<String, String> newHeaders) {
        newHeaders.put("X-Requested-By", "OBDP");
    }

    private Map<String, List<String>> modifyHeaders(Map<String, String> headers) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            headerMap.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        return headerMap;
    }

    private Map<String, List<String>> addHeaders(Map<String, String> customHeaders) {
        HashMap<String, String> newHeaders = new HashMap<String, String>();
        if (customHeaders != null) {
            newHeaders.putAll(customHeaders);
        }
        this.addBasicAuthHeaders(newHeaders);
        this.addRequestedByHeaders(newHeaders);
        return this.modifyHeaders(newHeaders);
    }

    private void addBasicAuthHeaders(HashMap<String, String> headers) {
        String authString = this.username + ":" + this.password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        headers.put("Authorization", "Basic " + authStringEnc);
    }
}

