/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.entities.RemoteOBDPClusterEntity;
import id.onyx.obdp.server.view.RemoteAmbariConfigurationReadException;
import id.onyx.obdp.server.view.RemoteAmbariStreamProvider;
import id.onyx.obdp.view.AmbariHttpException;
import id.onyx.obdp.view.AmbariStreamProvider;
import id.onyx.obdp.view.cluster.Cluster;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public class RemoteAmbariCluster
implements Cluster {
    public static final String AMBARI_OR_CLUSTER_ADMIN = "/api/v1/users/%s?privileges/PrivilegeInfo/permission_name=OBDP.ADMINISTRATOR|(privileges/PrivilegeInfo/permission_name=CLUSTER.ADMINISTRATOR&privileges/PrivilegeInfo/cluster_name=%s)";
    private String name;
    private AmbariStreamProvider streamProvider;
    private String clusterPath;
    private String username;
    private final LoadingCache<String, JsonElement> configurationCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, JsonElement>(){

        public JsonElement load(String url) throws Exception {
            return RemoteAmbariCluster.this.readFromUrlJSON(url);
        }
    });

    public RemoteAmbariCluster(RemoteOBDPClusterEntity remoteAmbariClusterEntity, Configuration config) throws MalformedURLException {
        this.name = this.getClusterName(remoteAmbariClusterEntity);
        this.username = remoteAmbariClusterEntity.getUsername();
        URL url = new URL(remoteAmbariClusterEntity.getUrl());
        String portString = url.getPort() == -1 ? "" : ":" + url.getPort();
        String baseUrl = url.getProtocol() + "://" + url.getHost() + portString;
        this.clusterPath = url.getPath();
        this.streamProvider = new RemoteAmbariStreamProvider(baseUrl, remoteAmbariClusterEntity.getUsername(), remoteAmbariClusterEntity.getPassword(), config.getRequestConnectTimeout(), config.getRequestReadTimeout());
    }

    private String getClusterName(RemoteOBDPClusterEntity remoteAmbariClusterEntity) {
        String[] urlSplit = remoteAmbariClusterEntity.getUrl().split("/");
        return urlSplit[urlSplit.length - 1];
    }

    public RemoteAmbariCluster(String name, String clusterPath, AmbariStreamProvider streamProvider) {
        this.name = name;
        this.clusterPath = clusterPath;
        this.streamProvider = streamProvider;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigurationValue(String type, String key) {
        JsonElement config = null;
        try {
            String desiredTag = this.getDesiredConfig(type);
            if (desiredTag != null) {
                config = (JsonElement)this.configurationCache.get((Object)String.format("%s/configurations?(type=%s&tag=%s)", this.clusterPath, type, desiredTag));
            }
        }
        catch (ExecutionException e) {
            throw new RemoteAmbariConfigurationReadException("Can't retrieve configuration from Remote Ambari", e);
        }
        if (config == null || !config.isJsonObject()) {
            return null;
        }
        JsonElement items = config.getAsJsonObject().get("items");
        if (items == null || !items.isJsonArray()) {
            return null;
        }
        JsonElement item = items.getAsJsonArray().get(0);
        if (item == null || !item.isJsonObject()) {
            return null;
        }
        JsonElement properties = item.getAsJsonObject().get("properties");
        if (properties == null || !properties.isJsonObject()) {
            return null;
        }
        JsonElement property = properties.getAsJsonObject().get(key);
        if (property == null || !property.isJsonPrimitive()) {
            return null;
        }
        return property.getAsJsonPrimitive().getAsString();
    }

    public Map<String, String> getConfigByType(String type) {
        JsonElement config = null;
        try {
            String desiredTag = this.getDesiredConfig(type);
            if (desiredTag != null) {
                config = (JsonElement)this.configurationCache.get((Object)String.format("%s/configurations?(type=%s&tag=%s)", this.clusterPath, type, desiredTag));
            }
        }
        catch (ExecutionException e) {
            throw new RemoteAmbariConfigurationReadException("Can't retrieve configuration from Remote Ambari", e);
        }
        if (config == null || !config.isJsonObject()) {
            return null;
        }
        JsonElement items = config.getAsJsonObject().get("items");
        if (items == null || !items.isJsonArray()) {
            return null;
        }
        JsonElement item = items.getAsJsonArray().get(0);
        if (item == null || !item.isJsonObject()) {
            return null;
        }
        JsonElement properties = item.getAsJsonObject().get("properties");
        if (properties == null || !properties.isJsonObject()) {
            return null;
        }
        Map retMap = (Map)new Gson().fromJson(properties, new TypeToken<HashMap<String, String>>(){}.getType());
        return retMap;
    }

    public List<String> getHostsForServiceComponent(String serviceName, String componentName) {
        String url = String.format("%s/services/%s/components/%s?fields=host_components/HostRoles/host_name", this.clusterPath, serviceName, componentName);
        ArrayList<String> hosts = new ArrayList<String>();
        try {
            JsonElement response = (JsonElement)this.configurationCache.get((Object)url);
            if (response == null || !response.isJsonObject()) {
                return hosts;
            }
            JsonElement hostComponents = response.getAsJsonObject().get("host_components");
            if (hostComponents == null || !hostComponents.isJsonArray()) {
                return hosts;
            }
            for (JsonElement element : hostComponents.getAsJsonArray()) {
                JsonElement hostRoles = element.getAsJsonObject().get("HostRoles");
                String hostName = hostRoles.getAsJsonObject().get("host_name").getAsString();
                hosts.add(hostName);
            }
        }
        catch (ExecutionException e) {
            throw new RemoteAmbariConfigurationReadException("Can't retrieve host information from Remote Ambari", e);
        }
        return hosts;
    }

    public Set<String> getServices() throws IOException, AmbariHttpException {
        JsonElement items;
        HashSet<String> services = new HashSet<String>();
        String path = this.clusterPath + "?fields=services/ServiceInfo/service_name";
        JsonElement config = (JsonElement)this.configurationCache.getUnchecked((Object)path);
        if (config != null && config.isJsonObject() && (items = config.getAsJsonObject().get("services")) != null && items.isJsonArray()) {
            for (JsonElement item : items.getAsJsonArray()) {
                JsonElement serviceInfo = item.getAsJsonObject().get("ServiceInfo");
                if (serviceInfo == null || !serviceInfo.isJsonObject()) continue;
                String serviceName = serviceInfo.getAsJsonObject().get("service_name").getAsString();
                services.add(serviceName);
            }
        }
        return services;
    }

    public boolean isAmbariOrClusterAdmin() throws AmbariHttpException {
        JsonElement privileges;
        if (this.username == null) {
            return false;
        }
        String url = String.format(AMBARI_OR_CLUSTER_ADMIN, this.username, this.name);
        JsonElement response = (JsonElement)this.configurationCache.getUnchecked((Object)url);
        return response != null && response.isJsonObject() && (privileges = response.getAsJsonObject().get("privileges")) != null && privileges.isJsonArray() && privileges.getAsJsonArray().size() > 0;
    }

    private String getDesiredConfig(String type) throws ExecutionException {
        JsonElement desiredConfigResponse = (JsonElement)this.configurationCache.get((Object)(this.clusterPath + "?fields=services/ServiceInfo,hosts,Clusters"));
        if (desiredConfigResponse == null || !desiredConfigResponse.isJsonObject()) {
            return null;
        }
        JsonElement clusters = desiredConfigResponse.getAsJsonObject().get("Clusters");
        if (clusters == null || !clusters.isJsonObject()) {
            return null;
        }
        JsonElement desiredConfig = clusters.getAsJsonObject().get("desired_configs");
        if (desiredConfig == null || !desiredConfig.isJsonObject()) {
            return null;
        }
        JsonElement desiredConfigForType = desiredConfig.getAsJsonObject().get(type);
        if (desiredConfigForType == null || !desiredConfigForType.isJsonObject()) {
            return null;
        }
        JsonElement typeJson = desiredConfigForType.getAsJsonObject().get("tag");
        if (typeJson == null || !typeJson.isJsonPrimitive()) {
            return null;
        }
        return typeJson.getAsJsonPrimitive().getAsString();
    }

    private JsonElement readFromUrlJSON(String url) throws IOException, AmbariHttpException {
        InputStream inputStream = this.streamProvider.readFrom(url, "GET", (String)null, null);
        String response = IOUtils.toString((InputStream)inputStream);
        return new JsonParser().parse(response);
    }
}

