/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.proxy.ProxyService;
import id.onyx.obdp.view.HttpImpersonator;
import id.onyx.obdp.view.ImpersonatorSetting;
import id.onyx.obdp.view.ViewContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpImpersonatorImpl
implements HttpImpersonator {
    private ViewContext context;
    private final URLStreamProvider urlStreamProvider;
    private static final Logger LOG = LoggerFactory.getLogger(HttpImpersonatorImpl.class);

    public HttpImpersonatorImpl(ViewContext c) {
        this.context = c;
        ComponentSSLConfiguration configuration = ComponentSSLConfiguration.instance();
        this.urlStreamProvider = new URLStreamProvider(20000, 15000, configuration.getTruststorePath(), configuration.getTruststorePassword(), configuration.getTruststoreType());
    }

    public HttpImpersonatorImpl(ViewContext c, URLStreamProvider urlStreamProvider) {
        this.context = c;
        this.urlStreamProvider = urlStreamProvider;
    }

    public ViewContext getContext() {
        return this.context;
    }

    public String getUsername() {
        return this.getContext().getUsername();
    }

    public HttpURLConnection doAs(HttpURLConnection conn, String type) {
        String username = this.getUsername();
        return this.doAs(conn, type, username, "doAs");
    }

    public HttpURLConnection doAs(HttpURLConnection conn, String type, String username, String doAsParamName) {
        String url = conn.getURL().toString();
        if (url.toLowerCase().contains(doAsParamName.toLowerCase())) {
            throw new IllegalArgumentException("URL cannot contain \"" + doAsParamName + "\" parameter");
        }
        try {
            conn.setRequestMethod(type);
        }
        catch (IOException e) {
            return null;
        }
        conn.setRequestProperty(doAsParamName, username);
        return conn;
    }

    public String requestURL(String url, String requestType, ImpersonatorSetting impersonatorSetting) {
        Object result = "";
        if (url.toLowerCase().contains(impersonatorSetting.getDoAsParamName().toLowerCase())) {
            throw new IllegalArgumentException("URL cannot contain \"" + impersonatorSetting.getDoAsParamName() + "\" parameter");
        }
        try {
            HttpURLConnection connection;
            int responseCode;
            String username = impersonatorSetting.getUsername();
            if (username != null) {
                URIBuilder builder = new URIBuilder(url);
                builder.addParameter(impersonatorSetting.getDoAsParamName(), username);
                url = builder.build().toString();
            }
            InputStream resultInputStream = (responseCode = (connection = this.urlStreamProvider.processURL(url, requestType, (String)null, null)).getResponseCode()) >= ProxyService.HTTP_ERROR_RANGE_START ? connection.getErrorStream() : connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(resultInputStream));
            String line = rd.readLine();
            while (line != null) {
                result = (String)result + line;
                line = rd.readLine();
            }
            rd.close();
        }
        catch (Exception e) {
            LOG.error("Exception caught processing impersonator request.", (Throwable)e);
        }
        return result;
    }
}

