/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import com.google.common.collect.ImmutableMap;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.view.cluster.Cluster;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClusterImpl
implements Cluster {
    private final id.onyx.obdp.server.state.Cluster cluster;

    public ClusterImpl(id.onyx.obdp.server.state.Cluster cluster) {
        this.cluster = cluster;
    }

    public String getName() {
        return this.cluster.getClusterName();
    }

    public String getConfigurationValue(String type, String key) {
        Config config = this.cluster.getDesiredConfigByType(type);
        return config == null ? null : config.getProperties().get(key);
    }

    public Map<String, String> getConfigByType(String type) {
        Config configs = this.cluster.getDesiredConfigByType(type);
        return ImmutableMap.copyOf(configs.getProperties());
    }

    public List<String> getHostsForServiceComponent(String serviceName, String componentName) {
        List<ServiceComponentHost> serviceComponentHosts = this.cluster.getServiceComponentHosts(serviceName, componentName);
        ArrayList<String> hosts = new ArrayList<String>();
        for (ServiceComponentHost serviceComponentHost : serviceComponentHosts) {
            hosts.add(serviceComponentHost.getHostName());
        }
        return hosts;
    }
}

