/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.view;

import com.google.inject.Singleton;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.MDC;

@Singleton
public class AmbariViewsMDCLoggingFilter
implements Filter {
    private static final String patternStr = "/api/v1/views/(.*)/versions/(.*)/instances/([^/]+).*";
    private static final Pattern pattern = Pattern.compile("/api/v1/views/(.*)/versions/(.*)/instances/([^/]+).*");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.buildMDC(servletRequest);
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.clear();
        }
    }

    private void buildMDC(ServletRequest request) {
        String url;
        Matcher matcher;
        if (request instanceof HttpServletRequest && MDC.getMDCAdapter() != null && (matcher = pattern.matcher(url = ((HttpServletRequest)request).getRequestURI())).find()) {
            MDC.put((String)"viewName", (String)matcher.group(1));
            MDC.put((String)"viewVersion", (String)matcher.group(2));
            MDC.put((String)"viewInstanceName", (String)matcher.group(3));
        }
    }

    private void clear() {
        MDC.clear();
    }

    public void destroy() {
    }
}

