/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ThreadPools {
    private static final String AGENT_COMMAND_PUBLISHER_POOL_NAME = "agent-command-publisher";
    private static final String DEFAULT_FORK_JOIN_POOL_NAME = "default-fork-join-pool";
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPools.class);
    private final Configuration configuration;
    private ForkJoinPool agentPublisherCommandsPool;
    private ForkJoinPool defaultForkJoinPool;

    @Inject
    public ThreadPools(Configuration configuration) {
        this.configuration = configuration;
    }

    private void logThreadPoolCreation(String name, int size) {
        LOG.info(String.format("Creating '%s' thread pool with configured size %d", name, size));
    }

    private ForkJoinPool.ForkJoinWorkerThreadFactory createNamedFactory(String name) {
        return pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName(name + "-" + worker.getPoolIndex());
            return worker;
        };
    }

    private Boolean forkJoinPoolShutdown(ForkJoinPool pool, boolean forced) {
        if (pool == null) {
            return true;
        }
        if (forced) {
            pool.shutdownNow();
        } else {
            pool.shutdown();
        }
        return pool.isShutdown();
    }

    public ForkJoinPool getAgentPublisherCommandsPool() {
        if (this.agentPublisherCommandsPool == null) {
            this.logThreadPoolCreation(AGENT_COMMAND_PUBLISHER_POOL_NAME, this.configuration.getAgentCommandPublisherThreadPoolSize());
            this.agentPublisherCommandsPool = new ForkJoinPool(this.configuration.getAgentCommandPublisherThreadPoolSize(), this.createNamedFactory(AGENT_COMMAND_PUBLISHER_POOL_NAME), (t, e) -> {
                LOG.error("Unexpected exception in thread: " + t, e);
                throw new RuntimeException(e);
            }, false);
        }
        return this.agentPublisherCommandsPool;
    }

    public ForkJoinPool getDefaultForkJoinPool() {
        if (this.defaultForkJoinPool == null) {
            this.logThreadPoolCreation(DEFAULT_FORK_JOIN_POOL_NAME, this.configuration.getDefaultForkJoinPoolSize());
            this.defaultForkJoinPool = new ForkJoinPool(this.configuration.getDefaultForkJoinPoolSize(), this.createNamedFactory(DEFAULT_FORK_JOIN_POOL_NAME), (t, e) -> {
                LOG.error("Unexpected exception in thread: " + t, e);
                throw new RuntimeException(e);
            }, false);
        }
        return this.defaultForkJoinPool;
    }

    public void shutdownDefaultForkJoinPool(boolean force) {
        if (this.forkJoinPoolShutdown(this.defaultForkJoinPool, force).booleanValue()) {
            this.defaultForkJoinPool = null;
        }
    }

    public void shutdownAgentPublisherCommandsPool(boolean force) {
        if (this.forkJoinPoolShutdown(this.agentPublisherCommandsPool, force).booleanValue()) {
            this.agentPublisherCommandsPool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void parallelOperation(String factoryName, int threadPoolSize, String operation, List<Callable<T>> tasks, ThreadPoolFutureResult<T> taskResultFunc) throws Exception {
        this.logThreadPoolCreation(factoryName, threadPoolSize);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(factoryName).build();
        ExecutorService executorService = Executors.newFixedThreadPool(threadPoolSize, threadFactory);
        ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
        List futures = tasks.stream().map(completionService::submit).collect(Collectors.toList());
        LOG.info("Processing {} {} concurrently...", (Object)futures.size(), (Object)operation);
        try {
            for (int i = 0; i < futures.size(); ++i) {
                Future future = completionService.take();
                Object t = future.get();
                if (taskResultFunc.waitForNextTask(t).booleanValue()) continue;
                break;
            }
        }
        finally {
            futures.stream().filter(x -> !x.isCancelled() && !x.isDone()).forEach(x -> x.cancel(true));
            executorService.shutdown();
        }
    }

    public static ExecutorService getSingleThreadedExecutor(String threadPoolName) {
        return Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(threadPoolName + "-%d").build());
    }

    protected void finalize() throws Throwable {
        this.shutdownAgentPublisherCommandsPool(true);
        this.shutdownDefaultForkJoinPool(true);
        super.finalize();
    }

    public static interface ThreadPoolFutureResult<T> {
        public Boolean waitForNextTask(T var1);
    }
}

