/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostInstallEvent;
import id.onyx.obdp.server.topology.TopologyManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageUtils {
    public static final Integer DEFAULT_PING_PORT = 8670;
    public static final String DEFAULT_RACK = "/default-rack";
    public static final String DEFAULT_IPV4_ADDRESS = "127.0.0.1";
    private static final Logger LOG = LoggerFactory.getLogger(StageUtils.class);
    protected static final String AMBARI_SERVER_HOST = "ambari_server_host";
    protected static final String AMBARI_SERVER_PORT = "ambari_server_port";
    protected static final String AMBARI_SERVER_USE_SSL = "ambari_server_use_ssl";
    protected static final String HOSTS_LIST = "all_hosts";
    protected static final String PORTS = "all_ping_ports";
    protected static final String RACKS = "all_racks";
    protected static final String IPV4_ADDRESSES = "all_ipv4_ips";
    private static Map<String, String> componentToClusterInfoKeyMap = new HashMap<String, String>();
    private static volatile Gson gson;
    @Inject
    private static StageFactory stageFactory;
    @Inject
    private static TopologyManager topologyManager;
    @Inject
    private static Configuration configuration;
    private static String server_hostname;

    @Inject
    public StageUtils(StageFactory stageFactory) {
        StageUtils.stageFactory = stageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gson getGson() {
        if (gson != null) {
            return gson;
        }
        Logger logger = LOG;
        synchronized (logger) {
            if (gson == null) {
                gson = new Gson();
            }
            return gson;
        }
    }

    public static void setGson(Gson gson) {
        if (gson == null) {
            StageUtils.gson = gson;
        }
    }

    public static void setTopologyManager(TopologyManager topologyManager) {
        StageUtils.topologyManager = topologyManager;
    }

    public static void setConfiguration(Configuration configuration) {
        StageUtils.configuration = configuration;
    }

    private static void put2componentToClusterInfoKeyMap(String component) {
        componentToClusterInfoKeyMap.put(component, StageUtils.getClusterHostInfoKey(component));
    }

    public static String getActionId(long requestId, long stageId) {
        return requestId + "-" + stageId;
    }

    public static long[] getRequestStage(String actionId) {
        String[] fields = actionId.split("-");
        long[] requestStageIds = new long[]{Long.parseLong(fields[0]), Long.parseLong(fields[1])};
        return requestStageIds;
    }

    public static Stage getATestStage(long requestId, long stageId, String commandParamsStage, String hostParamsStage) {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "host-dummy";
        }
        return StageUtils.getATestStage(requestId, stageId, hostname, commandParamsStage, hostParamsStage);
    }

    @Inject
    public static Stage getATestStage(long requestId, long stageId, String hostname, String commandParamsStage, String hostParamsStage) {
        Stage s = stageFactory.createNew(requestId, "/tmp", "cluster1", 1L, "context", commandParamsStage, hostParamsStage);
        s.setStageId(stageId);
        long now = System.currentTimeMillis();
        s.addHostRoleExecutionCommand(hostname, Role.NAMENODE, RoleCommand.INSTALL, (ServiceComponentHostEvent)new ServiceComponentHostInstallEvent("NAMENODE", hostname, now, "HDP-1.2.0"), "cluster1", "HDFS", false, false);
        ExecutionCommand execCmd = s.getExecutionCommandWrapper(hostname, "NAMENODE").getExecutionCommand();
        execCmd.setRequestAndStage(s.getRequestId(), s.getStageId());
        ArrayList<String> slaveHostList = new ArrayList<String>();
        slaveHostList.add(hostname);
        slaveHostList.add("host2");
        TreeMap<String, String> hdfsSite = new TreeMap<String, String>();
        hdfsSite.put("dfs.block.size", "2560000000");
        TreeMap<String, Map<String, String>> configurations = new TreeMap<String, Map<String, String>>();
        configurations.put("hdfs-site", hdfsSite);
        execCmd.setConfigurations(configurations);
        TreeMap configurationAttributes = new TreeMap();
        TreeMap hdfsSiteAttributes = new TreeMap();
        TreeMap<String, String> finalAttribute = new TreeMap<String, String>();
        finalAttribute.put("dfs.block.size", "true");
        hdfsSiteAttributes.put("final", finalAttribute);
        configurationAttributes.put("hdfsSite", hdfsSiteAttributes);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("jdklocation", "/x/y/z");
        params.put("stack_version", "1.2.0");
        params.put("stack_name", "HDP");
        execCmd.setHostLevelParams(params);
        TreeMap<String, String> roleParams = new TreeMap<String, String>();
        roleParams.put("format", "false");
        execCmd.setRoleParams(roleParams);
        TreeMap<String, String> commandParams = new TreeMap<String, String>();
        commandParams.put("command_timeout", "600");
        execCmd.setCommandParams(commandParams);
        return s;
    }

    public static String jaxbToString(Object jaxbObj) throws JAXBException, JsonGenerationException, JsonMappingException, IOException {
        return StageUtils.getGson().toJson(jaxbObj);
    }

    public static <T> T fromJson(String json, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(MapperFeature.USE_ANNOTATIONS, true);
        ByteArrayInputStream is = new ByteArrayInputStream(json.getBytes(Charset.forName("UTF8")));
        return (T)mapper.readValue((InputStream)is, clazz);
    }

    public static Map<String, String> getCommandParamsStage(ActionExecutionContext actionExecContext, String requestContext) throws OBDPException {
        TreeMap<String, String> commandParams;
        TreeMap<String, String> treeMap = commandParams = actionExecContext.getParameters() != null ? actionExecContext.getParameters() : new TreeMap<String, String>();
        if (StringUtils.isNotEmpty((String)requestContext) && requestContext.toLowerCase().contains("rolling-restart")) {
            commandParams.put("rolling_restart", "true");
        }
        return commandParams;
    }

    public static String getClusterHostInfoKey(String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("Component name cannot be null");
        }
        return componentName.toLowerCase() + "_hosts";
    }

    public static Map<String, Set<String>> getClusterHostInfo(Cluster cluster) throws OBDPException {
        LinkedHashSet<String> hostsSet = new LinkedHashSet<String>();
        ArrayList<Integer> portsList = new ArrayList<Integer>();
        ArrayList<String> rackList = new ArrayList<String>();
        ArrayList<Object> ipV4List = new ArrayList<Object>();
        Collection<Host> allHosts = cluster.getHosts();
        for (Host host : allHosts) {
            hostsSet.add(host.getHostName());
            Integer currentPingPort = host.getCurrentPingPort();
            portsList.add(currentPingPort == null ? DEFAULT_PING_PORT : currentPingPort);
            String rackInfo = host.getRackInfo();
            rackList.add(StringUtils.isEmpty((String)rackInfo) ? DEFAULT_RACK : rackInfo);
            Iterator<Map.Entry<String, Collection<String>>> iPv4 = host.getIPv4();
            ipV4List.add(StringUtils.isEmpty((String)((Object)iPv4)) ? DEFAULT_IPV4_ADDRESS : iPv4);
        }
        Map<String, Collection<String>> pendingHostComponents = topologyManager.getPendingHostComponents();
        for (String hostname : pendingHostComponents.keySet()) {
            if (hostsSet.contains(hostname)) continue;
            hostsSet.add(hostname);
            portsList.add(DEFAULT_PING_PORT);
            rackList.add(DEFAULT_RACK);
            ipV4List.add(DEFAULT_IPV4_ADDRESS);
        }
        ArrayList arrayList = new ArrayList(hostsSet);
        HashMap<String, Object> additionalComponentToClusterInfoKeyMap = new HashMap<String, Object>();
        HashMap hostRolesInfo = new HashMap();
        for (Map.Entry entry : cluster.getServices().entrySet()) {
            Service service = (Service)entry.getValue();
            for (Map.Entry<String, ServiceComponent> serviceComponentEntry : service.getServiceComponents().entrySet()) {
                ServiceComponent serviceComponent = serviceComponentEntry.getValue();
                String componentName = serviceComponent.getName();
                Object roleName = componentToClusterInfoKeyMap.get(componentName);
                if (null == roleName) {
                    roleName = (String)additionalComponentToClusterInfoKeyMap.get(componentName);
                }
                if (null == roleName && !serviceComponent.isClientComponent()) {
                    roleName = componentName.toLowerCase() + "_hosts";
                    additionalComponentToClusterInfoKeyMap.put(componentName, roleName);
                }
                if (roleName == null) continue;
                for (String hostName : serviceComponent.getServiceComponentHosts().keySet()) {
                    TreeSet<Integer> hostsForComponentsHost = (TreeSet<Integer>)hostRolesInfo.get(roleName);
                    if (hostsForComponentsHost == null) {
                        hostsForComponentsHost = new TreeSet<Integer>();
                        hostRolesInfo.put(roleName, hostsForComponentsHost);
                    }
                    int hostIndex = arrayList.indexOf(hostName);
                    hostsForComponentsHost.add(hostIndex);
                }
            }
        }
        for (Map.Entry<String, Collection<String>> entry : pendingHostComponents.entrySet()) {
            String string = entry.getKey();
            Collection<String> hostComponents = entry.getValue();
            for (String hostComponent : hostComponents) {
                int hostIndex;
                String roleName = StageUtils.getClusterHostInfoKey(hostComponent);
                TreeSet<Integer> hostsForComponentsHost = (TreeSet<Integer>)hostRolesInfo.get(roleName);
                if (hostsForComponentsHost == null) {
                    hostsForComponentsHost = new TreeSet<Integer>();
                    hostRolesInfo.put(roleName, hostsForComponentsHost);
                }
                if ((hostIndex = arrayList.indexOf(string)) != -1) {
                    if (hostsForComponentsHost.contains(hostIndex)) continue;
                    hostsForComponentsHost.add(hostIndex);
                    continue;
                }
                throw new RuntimeException("Unable to get host index for host: " + string);
            }
        }
        HashMap<String, Set<String>> clusterHostInfo = new HashMap<String, Set<String>>();
        for (Map.Entry entry : hostRolesInfo.entrySet()) {
            TreeSet<Integer> sortedSet = new TreeSet<Integer>((SortedSet)entry.getValue());
            Set<String> replacedRangesSet = StageUtils.replaceRanges(sortedSet);
            clusterHostInfo.put((String)entry.getKey(), replacedRangesSet);
        }
        clusterHostInfo.put(HOSTS_LIST, hostsSet);
        clusterHostInfo.put(PORTS, StageUtils.replaceMappedRanges(portsList));
        clusterHostInfo.put(IPV4_ADDRESSES, StageUtils.replaceMappedRanges(ipV4List));
        clusterHostInfo.put(RACKS, StageUtils.replaceMappedRanges(rackList));
        clusterHostInfo.put(AMBARI_SERVER_HOST, Sets.newHashSet((Object[])new String[]{StageUtils.getHostName()}));
        boolean bl = configuration.getApiSSLAuthentication();
        int n = bl ? configuration.getClientSSLApiPort() : configuration.getClientApiPort();
        clusterHostInfo.put(AMBARI_SERVER_PORT, Sets.newHashSet((Object[])new String[]{Integer.toString(n)}));
        clusterHostInfo.put(AMBARI_SERVER_USE_SSL, Sets.newHashSet((Object[])new String[]{Boolean.toString(bl)}));
        return clusterHostInfo;
    }

    public static Map<String, Set<String>> substituteHostIndexes(Map<String, Set<String>> clusterHostInfo) throws OBDPException {
        HashSet<String> keysToSkip = new HashSet<String>(Arrays.asList(HOSTS_LIST, PORTS, AMBARI_SERVER_HOST, AMBARI_SERVER_PORT, AMBARI_SERVER_USE_SSL, RACKS, IPV4_ADDRESSES));
        String[] allHosts = new String[]{};
        if (clusterHostInfo.get(HOSTS_LIST) != null) {
            allHosts = clusterHostInfo.get(HOSTS_LIST).toArray(new String[clusterHostInfo.get(HOSTS_LIST).size()]);
        }
        Set<String> keys = clusterHostInfo.keySet();
        for (String key : keys) {
            if (keysToSkip.contains(key)) continue;
            HashSet<String> hosts = new HashSet<String>();
            Set<String> currentHostsIndexes = clusterHostInfo.get(key);
            if (currentHostsIndexes == null) continue;
            for (String hostIndexRange : currentHostsIndexes) {
                for (Integer hostIndex : StageUtils.rangeToSet(hostIndexRange)) {
                    try {
                        hosts.add(allHosts[hostIndex]);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new OBDPException("Failed to fill cluster host info  ", (Throwable)ex);
                    }
                }
            }
            clusterHostInfo.put(key, hosts);
        }
        return clusterHostInfo;
    }

    public static Set<String> replaceRanges(SortedSet<Integer> set) {
        if (set == null) {
            return null;
        }
        HashSet<String> rangedSet = new HashSet<String>();
        Integer prevElement = null;
        Integer startOfRange = set.first();
        for (Integer i : set) {
            if (prevElement != null && i - prevElement > 1) {
                String rangeItem = StageUtils.getRangedItem(startOfRange, prevElement);
                rangedSet.add(rangeItem);
                startOfRange = i;
            }
            prevElement = i;
        }
        rangedSet.add(StageUtils.getRangedItem(startOfRange, prevElement));
        return rangedSet;
    }

    public static <T> Set<String> replaceMappedRanges(List<T> values) {
        HashMap<T, TreeSet<Integer>> convolutedValues = new HashMap<T, TreeSet<Integer>>();
        int valueIndex = 0;
        for (T value : values) {
            TreeSet<Integer> correspValues = (TreeSet<Integer>)convolutedValues.get(value);
            if (correspValues == null) {
                correspValues = new TreeSet<Integer>();
                convolutedValues.put(value, correspValues);
            }
            correspValues.add(valueIndex);
            ++valueIndex;
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry entry : convolutedValues.entrySet()) {
            Set<String> replacedRanges = StageUtils.replaceRanges((SortedSet)entry.getValue());
            result.add(entry.getKey() + ":" + Joiner.on((String)",").join(replacedRanges));
        }
        return result;
    }

    public static String getHostName() {
        return server_hostname;
    }

    private static Set<Integer> rangeToSet(String range) {
        int endIndex;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        if (range.contains("-")) {
            startIndex = Integer.parseInt(range.split("-")[0]);
            endIndex = Integer.parseInt(range.split("-")[1]);
        } else if (range.contains(",")) {
            startIndex = Integer.parseInt(range.split(",")[0]);
            endIndex = Integer.parseInt(range.split(",")[1]);
        } else {
            startIndex = endIndex = Integer.parseInt(range);
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            indexSet.add(i);
        }
        return indexSet;
    }

    private static String getRangedItem(Integer startOfRange, Integer endOfRange) {
        String separator = endOfRange - startOfRange > 1 ? "-" : ",";
        String rangeItem = endOfRange.equals(startOfRange) ? endOfRange.toString() : startOfRange + separator + endOfRange;
        return rangeItem;
    }

    public static void useAmbariJdkInCommandParams(Map<String, String> commandParams, Configuration configuration) {
        if (StringUtils.isNotEmpty((String)configuration.getJavaHome()) && !configuration.getJavaHome().equals(configuration.getStackJavaHome())) {
            commandParams.put("ambari_java_home", configuration.getAmbariJavaHome());
            commandParams.put("ambari_java_version", String.valueOf(configuration.getJavaVersion()));
            if (StringUtils.isNotEmpty((String)configuration.getJDKName())) {
                commandParams.put("ambari_jdk_name", configuration.getJDKName());
            }
            if (StringUtils.isNotEmpty((String)configuration.getJCEName())) {
                commandParams.put("ambari_jce_name", configuration.getJCEName());
            }
        }
    }

    public static void useStackJdkIfExists(Map<String, String> hostLevelParams, Configuration configuration) {
        hostLevelParams.put("java_home", configuration.getJavaHome());
        hostLevelParams.put("jdk_name", configuration.getJDKName());
        hostLevelParams.put("jce_name", configuration.getJCEName());
        hostLevelParams.put("java_version", String.valueOf(configuration.getJavaVersion()));
        if (StringUtils.isNotEmpty((String)configuration.getStackJavaHome()) && !configuration.getStackJavaHome().equals(configuration.getJavaHome())) {
            hostLevelParams.put("java_home", configuration.getStackJavaHome());
            if (StringUtils.isNotEmpty((String)configuration.getStackJavaVersion())) {
                hostLevelParams.put("java_version", configuration.getStackJavaVersion());
            }
            if (StringUtils.isNotEmpty((String)configuration.getStackJDKName())) {
                hostLevelParams.put("jdk_name", configuration.getStackJDKName());
            } else {
                hostLevelParams.put("jdk_name", null);
            }
            if (StringUtils.isNotEmpty((String)configuration.getStackJCEName())) {
                hostLevelParams.put("jce_name", configuration.getStackJCEName());
            } else {
                hostLevelParams.put("jce_name", null);
            }
        }
    }

    public static Map<String, String> createComponentHostMap(Collection<String> services, Function<String, Collection<String>> componentsLookup, BiFunction<String, String, Collection<String>> hostAssignmentLookup) {
        HashMap<String, String> componentHostsMap = new HashMap<String, String>();
        for (String service : services) {
            Collection<String> components = componentsLookup.apply(service);
            for (String component : components) {
                Collection<String> hosts = hostAssignmentLookup.apply(service, component);
                componentHostsMap.put(StageUtils.getClusterHostInfoKey(component), StringUtils.join(hosts, (String)","));
            }
        }
        return componentHostsMap;
    }

    static {
        try {
            server_hostname = InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            LOG.warn("Could not find canonical hostname ", (Throwable)e);
            server_hostname = "localhost";
        }
        StageUtils.put2componentToClusterInfoKeyMap("NAMENODE");
        StageUtils.put2componentToClusterInfoKeyMap("JOBTRACKER");
        StageUtils.put2componentToClusterInfoKeyMap("SECONDARY_NAMENODE");
        StageUtils.put2componentToClusterInfoKeyMap("RESOURCEMANAGER");
        StageUtils.put2componentToClusterInfoKeyMap("NODEMANAGER");
        StageUtils.put2componentToClusterInfoKeyMap("HISTORYSERVER");
        StageUtils.put2componentToClusterInfoKeyMap("JOURNALNODE");
        StageUtils.put2componentToClusterInfoKeyMap("ZKFC");
        StageUtils.put2componentToClusterInfoKeyMap("ZOOKEEPER_SERVER");
        StageUtils.put2componentToClusterInfoKeyMap("FLUME_HANDLER");
        StageUtils.put2componentToClusterInfoKeyMap("HBASE_MASTER");
        StageUtils.put2componentToClusterInfoKeyMap("HBASE_REGIONSERVER");
        StageUtils.put2componentToClusterInfoKeyMap("HIVE_SERVER");
        StageUtils.put2componentToClusterInfoKeyMap("HIVE_METASTORE");
        StageUtils.put2componentToClusterInfoKeyMap("OOZIE_SERVER");
        StageUtils.put2componentToClusterInfoKeyMap("WEBHCAT_SERVER");
        StageUtils.put2componentToClusterInfoKeyMap("MYSQL_SERVER");
        StageUtils.put2componentToClusterInfoKeyMap("DASHBOARD");
        StageUtils.put2componentToClusterInfoKeyMap("GANGLIA_SERVER");
        StageUtils.put2componentToClusterInfoKeyMap("DATANODE");
        StageUtils.put2componentToClusterInfoKeyMap("TASKTRACKER");
        StageUtils.put2componentToClusterInfoKeyMap("ACCUMULO_MASTER");
        StageUtils.put2componentToClusterInfoKeyMap("ACCUMULO_MONITOR");
        StageUtils.put2componentToClusterInfoKeyMap("ACCUMULO_GC");
        StageUtils.put2componentToClusterInfoKeyMap("ACCUMULO_TRACER");
        StageUtils.put2componentToClusterInfoKeyMap("ACCUMULO_TSERVER");
    }
}

