/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellCommandUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ShellCommandUtil.class);
    private static final Object WindowsProcessLaunchLock = new Object();
    private static final String PASS_TOKEN = "pass:";
    private static final String KEY_TOKEN = "-key ";
    private static final String OBDP_SUDO = "obdp-sudo.sh";
    private static final int MODE_OWNER_READABLE = 400;
    private static final int MODE_OWNER_WRITABLE = 200;
    private static final int MODE_OWNER_EXECUTABLE = 100;
    private static final int MODE_GROUP_READABLE = 40;
    private static final int MODE_GROUP_WRITABLE = 20;
    private static final int MODE_GROUP_EXECUTABLE = 10;
    private static final int MODE_OTHER_READABLE = 4;
    private static final int MODE_OTHER_WRITABLE = 2;
    private static final int MODE_OTHER_EXECUTABLE = 1;
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    public static final boolean LINUX = System.getProperty("os.name").startsWith("Linux");
    public static final boolean MAC = System.getProperty("os.name").startsWith("Mac");
    public static final boolean UNIX_LIKE = LINUX || MAC;
    public static final String MASK_OWNER_ONLY_RW = "600";
    public static final String MASK_OWNER_ONLY_RWX = "700";
    public static final String MASK_EVERYBODY_RWX = "777";

    public static void logOpenSslExitCode(String command, int exitCode) {
        if (exitCode == 0) {
            LOG.info(ShellCommandUtil.getOpenSslCommandResult(command, exitCode));
        } else {
            LOG.warn(ShellCommandUtil.getOpenSslCommandResult(command, exitCode));
        }
    }

    public static String hideOpenSslPassword(String command) {
        int start;
        if (command.contains(PASS_TOKEN)) {
            start = command.indexOf(PASS_TOKEN) + PASS_TOKEN.length();
        } else if (command.contains(KEY_TOKEN)) {
            start = command.indexOf(KEY_TOKEN) + KEY_TOKEN.length();
        } else {
            return command;
        }
        CharSequence cs = command.subSequence(start, command.indexOf(" ", start));
        return command.replace(cs, "****");
    }

    public static String getOpenSslCommandResult(String command, int exitCode) {
        return "Command " + ShellCommandUtil.hideOpenSslPassword(command) + " was finished with exit code: " + exitCode + " - " + ShellCommandUtil.getOpenSslExitCodeDescription(exitCode);
    }

    private static String getOpenSslExitCodeDescription(int exitCode) {
        switch (exitCode) {
            case 0: {
                return "the operation was completely successfully.";
            }
            case 1: {
                return "an error occurred parsing the command options.";
            }
            case 2: {
                return "one of the input files could not be read.";
            }
            case 3: {
                return "an error occurred creating the PKCS#7 file or when reading the MIME message.";
            }
            case 4: {
                return "an error occurred decrypting or verifying the message.";
            }
            case 5: {
                return "the message was verified correctly but an error occurred writing out the signers certificates.";
            }
        }
        return "unsupported code";
    }

    public static String getUnixFilePermissions(String path) {
        String result = MASK_EVERYBODY_RWX;
        if (LINUX) {
            try {
                result = ShellCommandUtil.runCommand(new String[]{"stat", "-c", "%a", path}).getStdout();
            }
            catch (IOException | InterruptedException e) {
                LOG.warn(String.format("Can not perform stat on %s", path), (Throwable)e);
            }
        } else {
            LOG.debug(String.format("Not performing stat -s \"%%a\" command on file %s because current OS is not Linux. Returning 777", path));
        }
        return result.trim();
    }

    public static void setUnixFilePermissions(String mode, String path) {
        if (LINUX) {
            try {
                ShellCommandUtil.runCommand(new String[]{"chmod", mode, path});
            }
            catch (IOException | InterruptedException e) {
                LOG.warn(String.format("Can not perform chmod %s %s", mode, path), (Throwable)e);
            }
        } else {
            LOG.debug(String.format("Not performing chmod %s command for file %s because current OS is not Linux ", mode, path));
        }
    }

    public static Result setFileOwner(String path, String ownerName) {
        if (LINUX) {
            if (!StringUtils.isEmpty((String)ownerName)) {
                try {
                    return ShellCommandUtil.runCommand(new String[]{"chown", ownerName, path}, null, null, true);
                }
                catch (IOException | InterruptedException e) {
                    LOG.warn(String.format("Can not perform chown %s %s", ownerName, path), (Throwable)e);
                    return new Result(-1, "", "Cannot perform operation: " + e.getLocalizedMessage());
                }
            }
            return new Result(0, "", "");
        }
        LOG.debug(String.format("Not performing chown command for file %s because current OS is not Linux ", path));
        return new Result(-1, "", "Cannot perform operation: The current OS is not Linux");
    }

    public static Result setFileGroup(String path, String groupName) {
        if (LINUX) {
            if (!StringUtils.isEmpty((String)groupName)) {
                try {
                    return ShellCommandUtil.runCommand(new String[]{"chgrp", groupName, path}, null, null, true);
                }
                catch (IOException | InterruptedException e) {
                    LOG.warn(String.format("Can not perform chgrp %s %s", groupName, path), (Throwable)e);
                    return new Result(-1, "", "Cannot perform operation: " + e.getLocalizedMessage());
                }
            }
            return new Result(0, "", "");
        }
        LOG.debug(String.format("Not performing chgrp command for file %s because current OS is not Linux ", path));
        return new Result(-1, "", "Cannot perform operation: The current OS is not Linux");
    }

    public static Result setFileMode(String path, boolean ownerReadable, boolean ownerWritable, boolean ownerExecutable, boolean groupReadable, boolean groupWritable, boolean groupExecutable, boolean otherReadable, boolean otherWritable, boolean otherExecutable) {
        if (LINUX) {
            int modeValue = (ownerReadable ? 400 : 0) + (ownerWritable ? 200 : 0) + (ownerExecutable ? 100 : 0) + (groupReadable ? 40 : 0) + (groupWritable ? 20 : 0) + (groupExecutable ? 10 : 0) + (otherReadable ? 4 : 0) + (otherWritable ? 2 : 0) + (otherExecutable ? 1 : 0);
            String mode = String.format("%04d", modeValue);
            try {
                return ShellCommandUtil.runCommand(new String[]{"chmod", mode, path}, null, null, true);
            }
            catch (IOException | InterruptedException e) {
                LOG.warn(String.format("Can not perform chmod %s %s", mode, path), (Throwable)e);
                return new Result(-1, "", "Cannot perform operation: " + e.getLocalizedMessage());
            }
        }
        LOG.debug(String.format("Not performing chmod command for file %s because current OS is not Linux ", path));
        return new Result(-1, "", "Cannot perform operation: The current OS is not Linux");
    }

    public static Result pathExists(String path, boolean sudo) throws IOException, InterruptedException {
        String[] command = new String[]{WINDOWS ? "dir" : "/bin/ls", path};
        return ShellCommandUtil.runCommand(command, null, null, sudo);
    }

    public static Result mkdir(String directoryPath, boolean sudo) throws IOException, InterruptedException {
        if (ShellCommandUtil.pathExists(directoryPath, sudo).isSuccessful()) {
            return new Result(0, "The directory already exists, skipping.", "");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("/bin/mkdir");
        if (!WINDOWS) {
            command.add("-p");
        }
        command.add(directoryPath);
        return ShellCommandUtil.runCommand(command, null, null, sudo);
    }

    public static Result copyFile(String srcFile, String destFile, boolean force, boolean sudo) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        if (WINDOWS) {
            command.add("copy");
            if (force) {
                command.add("/Y");
            }
        } else {
            command.add("cp");
            command.add("-p");
            if (force) {
                command.add("-f");
            }
        }
        command.add(srcFile);
        command.add(destFile);
        return ShellCommandUtil.runCommand(command, null, null, sudo);
    }

    public static Result delete(String file, boolean force, boolean sudo) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        if (WINDOWS) {
            command.add("del");
            if (force) {
                command.add("/f");
            }
        } else {
            command.add("/bin/rm");
            if (force) {
                command.add("-f");
            }
        }
        command.add(file);
        return ShellCommandUtil.runCommand(command, null, null, sudo);
    }

    public static Result runCommand(List<String> args, Map<String, String> vars, InteractiveHandler interactiveHandler, boolean sudo) throws IOException, InterruptedException {
        return ShellCommandUtil.runCommand(args.toArray(new String[args.size()]), vars, interactiveHandler, sudo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result runCommand(String[] args, Map<String, String> vars, InteractiveHandler interactiveHandler, boolean sudo) throws IOException, InterruptedException {
        Process process;
        Object[] processArgs;
        if (sudo) {
            processArgs = new String[args.length + 1];
            processArgs[0] = OBDP_SUDO;
            System.arraycopy(args, 0, processArgs, 1, args.length);
        } else {
            processArgs = args;
        }
        ProcessBuilder builder = new ProcessBuilder((String[])processArgs);
        if (vars != null) {
            Map<String, String> env = builder.environment();
            env.putAll(vars);
        }
        LOG.debug("Executing the command {}", (Object)Arrays.toString(processArgs));
        if (WINDOWS) {
            Object object = WindowsProcessLaunchLock;
            synchronized (object) {
                process = builder.start();
            }
        } else {
            process = builder.start();
        }
        InputStream inputStream = process.getInputStream();
        if (interactiveHandler != null) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            interactiveHandler.start();
            try {
                while (!interactiveHandler.done()) {
                    StringBuilder query = new StringBuilder();
                    while (reader.ready()) {
                        query.append((char)reader.read());
                    }
                    String response = interactiveHandler.getResponse(query.toString());
                    if (response == null) continue;
                    writer.write(response);
                    writer.newLine();
                    writer.flush();
                }
            }
            catch (IOException query) {
            }
            finally {
                writer.close();
            }
        }
        process.waitFor();
        String stdout = ShellCommandUtil.streamToString(inputStream);
        String stderr = ShellCommandUtil.streamToString(process.getErrorStream());
        int exitCode = process.exitValue();
        return new Result(exitCode, stdout, stderr);
    }

    public static Result runCommand(String[] args, Map<String, String> vars) throws IOException, InterruptedException {
        return ShellCommandUtil.runCommand(args, vars, null, false);
    }

    public static Result runCommand(String[] args) throws IOException, InterruptedException {
        return ShellCommandUtil.runCommand(args, null);
    }

    private static String streamToString(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    public static class Result {
        private final int exitCode;
        private final String stdout;
        private final String stderr;

        public Result(int exitCode, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public boolean isSuccessful() {
            return this.exitCode == 0;
        }
    }

    public static interface InteractiveHandler {
        public boolean done();

        public String getResponse(String var1);

        public void start();
    }
}

