/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SetUtils {
    public static <T> List<Set<T>> split(Set<T> original, int subsetSize) {
        if (subsetSize <= 0) {
            throw new IllegalArgumentException("Incorrect max size");
        }
        if (original == null || original.isEmpty()) {
            return Collections.emptyList();
        }
        int subsetCount = (int)Math.ceil((double)original.size() / (double)subsetSize);
        ArrayList<Set<T>> subsets = new ArrayList<Set<T>>(subsetCount);
        Iterator<T> iterator = original.iterator();
        for (int i = 0; i < subsetCount; ++i) {
            LinkedHashSet<T> subset = new LinkedHashSet<T>(subsetSize);
            for (int j = 0; j < subsetSize && iterator.hasNext(); ++j) {
                subset.add(iterator.next());
            }
            subsets.add(subset);
        }
        return subsets;
    }
}

