/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.PropertyInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@StaticallyInject
public class SecretReference {
    private static final String secretPrefix = "SECRET";
    private String configType;
    private Long version;
    private String value;
    private static final String PASSWORD_TEXT = "password";
    private static final String PASSWD_TEXT = "passwd";
    @Inject
    private static Gson gson;

    public SecretReference(String reference, Cluster cluster) throws OBDPException {
        String[] values = reference.split(":");
        this.configType = values[1];
        this.version = Long.valueOf(values[2]);
        String propertyName = values[3];
        String clusterName = cluster.getClusterName();
        Config refConfig = cluster.getConfigByVersion(this.configType, this.version);
        if (refConfig == null) {
            throw new OBDPException(String.format("Error when parsing secret reference. Cluster: %s does not contain ConfigType: %s ConfigVersion: %s", clusterName, this.configType, this.version));
        }
        Map<String, String> refProperties = refConfig.getProperties();
        if (!refProperties.containsKey(propertyName)) {
            throw new OBDPException(String.format("Error when parsing secret reference. Cluster: %s ConfigType: %s ConfigVersion: %s does not contain property '%s'", clusterName, this.configType, this.version, propertyName));
        }
        this.value = refProperties.get(propertyName);
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean isSecret(String value) {
        String[] values = value.split(":");
        return values.length == 4 && values[0].equals(secretPrefix);
    }

    public static String generateStub(String configType, Long configVersion, String propertyName) {
        return "SECRET:" + configType + ":" + configVersion + ":" + propertyName;
    }

    public static String maskPasswordInPropertyMap(String propertyMap) {
        if (null == propertyMap) {
            return null;
        }
        Map map = (Map)gson.fromJson(propertyMap, new TypeToken<Map<String, String>>(){}.getType());
        return gson.toJson(SecretReference.maskPasswordInPropertyMap(map));
    }

    public static Map<String, String> maskPasswordInPropertyMap(Map<String, String> propertyMap) {
        if (null == propertyMap) {
            return null;
        }
        HashMap<String, String> maskedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> property : propertyMap.entrySet()) {
            String value = SecretReference.isPassword(property.getKey()) ? secretPrefix : property.getValue();
            maskedMap.put(property.getKey(), value);
        }
        return maskedMap;
    }

    private static final boolean isPassword(String propertyName) {
        return propertyName.toLowerCase().contains(PASSWORD_TEXT) || propertyName.toLowerCase().contains(PASSWD_TEXT);
    }

    public static void replaceReferencesWithPasswords(Map<String, String> targetMap, Cluster cluster) throws OBDPException {
        if (cluster != null) {
            for (Map.Entry<String, String> propertyValueEntry : targetMap.entrySet()) {
                String key = propertyValueEntry.getKey();
                String value = propertyValueEntry.getValue();
                if (value == null || !SecretReference.isSecret(value)) continue;
                SecretReference ref = new SecretReference(value, cluster);
                targetMap.put(key, ref.getValue());
            }
        }
    }

    public static void replacePasswordsWithReferences(Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes, Map<String, String> propertiesMap, String configType, Long configVersion) {
        if (propertiesTypes != null && propertiesTypes.containsKey((Object)PropertyInfo.PropertyType.PASSWORD)) {
            for (String pwdPropertyName : propertiesTypes.get((Object)PropertyInfo.PropertyType.PASSWORD)) {
                if (!propertiesMap.containsKey(pwdPropertyName) || propertiesMap.get(pwdPropertyName).equals("")) continue;
                String stub = SecretReference.generateStub(configType, configVersion, pwdPropertyName);
                propertiesMap.put(pwdPropertyName, stub);
            }
        }
    }

    public static void replacePasswordsWithReferencesForCustomProperties(Map<String, Map<String, String>> configAttributes, Map<String, String> propertiesMap, String configType, Long configVersion) {
        if (configAttributes != null && configAttributes.containsKey(PASSWORD_TEXT)) {
            for (String pwdPropertyName : configAttributes.get(PASSWORD_TEXT).keySet()) {
                if (!propertiesMap.containsKey(pwdPropertyName) || propertiesMap.get(pwdPropertyName).equals("")) continue;
                String stub = SecretReference.generateStub(configType, configVersion, pwdPropertyName);
                propertiesMap.put(pwdPropertyName, stub);
            }
        }
    }
}

