/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorCompletionService<V>
extends ExecutorCompletionService<V> {
    private final ScheduledExecutorService scheduledExecutor;
    private final BlockingQueue<Future<V>> queue;

    public ScheduledExecutorCompletionService(ScheduledExecutorService scheduledExecutor, BlockingQueue<Future<V>> queue) {
        super(scheduledExecutor, queue);
        this.scheduledExecutor = scheduledExecutor;
        this.queue = queue;
    }

    public Future<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<V> f = this.newTaskFor(task);
        this.scheduledExecutor.schedule(new QueueingFuture(f), delay, unit);
        return f;
    }

    private RunnableFuture<V> newTaskFor(Callable<V> task) {
        return new FutureTask<V>(task);
    }

    private class QueueingFuture
    extends FutureTask<Void> {
        private final Future<V> task;

        QueueingFuture(RunnableFuture<V> task) {
            super(task, null);
            this.task = task;
        }

        @Override
        protected void done() {
            ScheduledExecutorCompletionService.this.queue.add(this.task);
        }
    }
}

