/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RetryHelper.class);
    private static Clusters s_clusters;
    private static ThreadLocal<Set<Cluster>> affectedClusters;
    private static int operationsRetryAttempts;

    public static void init(Clusters clusters, int operationsRetryAttempts) {
        s_clusters = clusters;
        RetryHelper.operationsRetryAttempts = operationsRetryAttempts;
    }

    public static void addAffectedCluster(Cluster cluster) {
        if (operationsRetryAttempts > 0) {
            affectedClusters.get().add(cluster);
        }
    }

    public static Set<Cluster> getAffectedClusters() {
        return Collections.unmodifiableSet(affectedClusters.get());
    }

    public static void clearAffectedClusters() {
        if (operationsRetryAttempts > 0) {
            affectedClusters.get().clear();
        }
    }

    public static int getOperationsRetryAttempts() {
        return operationsRetryAttempts;
    }

    public static boolean isDatabaseException(Throwable ex) {
        do {
            if (!(ex instanceof DatabaseException)) continue;
            return true;
        } while ((ex = ex.getCause()) != null);
        return false;
    }

    public static void invalidateAffectedClusters() {
        for (Cluster cluster : affectedClusters.get()) {
            s_clusters.invalidate(cluster);
            affectedClusters.get().remove(cluster);
        }
    }

    public static <T> T executeWithRetry(Callable<T> command) throws OBDPException {
        RetryHelper.clearAffectedClusters();
        int retryAttempts = RetryHelper.getOperationsRetryAttempts();
        while (true) {
            try {
                return command.call();
            }
            catch (Exception e) {
                if (RetryHelper.isDatabaseException(e)) {
                    RetryHelper.invalidateAffectedClusters();
                    if (retryAttempts > 0) {
                        LOG.error("Ignoring database exception to perform operation retry, attempts remaining: " + retryAttempts, (Throwable)e);
                        --retryAttempts;
                        continue;
                    }
                    RetryHelper.clearAffectedClusters();
                    throw new OBDPException(e.getMessage(), (Throwable)e);
                }
                RetryHelper.clearAffectedClusters();
                throw new OBDPException(e.getMessage(), (Throwable)e);
            }
            break;
        }
    }

    static {
        affectedClusters = new ThreadLocal<Set<Cluster>>(){

            @Override
            protected Set<Cluster> initialValue() {
                return new HashSet<Cluster>();
            }
        };
        operationsRetryAttempts = 0;
    }
}

