/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import com.google.common.collect.ImmutableSet;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;

public class RequestUtils {
    private static Set<String> headersToCheck = ImmutableSet.copyOf(Arrays.asList("X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"));

    public static String getRemoteAddress(HttpServletRequest request) {
        String header;
        String ip = null;
        Iterator<String> iterator = headersToCheck.iterator();
        while (iterator.hasNext() && RequestUtils.isRemoteAddressUnknown(ip = request.getHeader(header = iterator.next()))) {
        }
        if (RequestUtils.isRemoteAddressUnknown(ip)) {
            ip = request.getRemoteAddr();
        }
        if (RequestUtils.containsMultipleRemoteAddresses(ip)) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public static String getRemoteAddress() {
        if (RequestUtils.hasValidRequest()) {
            return RequestUtils.getRemoteAddress(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest());
        }
        return null;
    }

    private static boolean isRemoteAddressUnknown(String ip) {
        return ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip);
    }

    private static boolean containsMultipleRemoteAddresses(String ip) {
        return ip != null && ip.indexOf(",") > 0;
    }

    private static boolean hasValidRequest() {
        return RequestContextHolder.getRequestAttributes() != null && RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes && ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest() != null;
    }

    public static void logRequestHeadersAndQueryParams(HttpServletRequest request, Logger logger) {
        if (logger != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n##### HEADERS #######");
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    builder.append("\n\t");
                    builder.append(name);
                    builder.append(" = ");
                    builder.append(value);
                }
            }
            builder.append("\n#####################");
            builder.append("\n##### PARAMETERS ####");
            MultiValueMap<String, String> queryParams = RequestUtils.getQueryStringParameters(request);
            if (queryParams != null) {
                for (Map.Entry entry : queryParams.entrySet()) {
                    String name = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    for (String value : values) {
                        builder.append("\n\t");
                        builder.append(name);
                        builder.append(" = ");
                        builder.append(value);
                    }
                }
            }
            builder.append("\n#####################");
            logger.info(builder.toString());
        }
    }

    public static MultiValueMap<String, String> getQueryStringParameters(HttpServletRequest request) {
        String queryString = request.getQueryString();
        return StringUtils.isEmpty((String)queryString) ? null : UriComponentsBuilder.newInstance().query(queryString).build().getQueryParams();
    }

    public static List<String> getQueryStringParameterValues(HttpServletRequest request, String parameterName) {
        MultiValueMap<String, String> valueMap = RequestUtils.getQueryStringParameters(request);
        return valueMap == null || !valueMap.containsKey((Object)parameterName) ? null : (List)valueMap.get((Object)parameterName);
    }

    public static String getQueryStringParameterValue(HttpServletRequest request, String parameterName) {
        MultiValueMap<String, String> valueMap = RequestUtils.getQueryStringParameters(request);
        return valueMap == null || !valueMap.containsKey((Object)parameterName) ? null : (String)valueMap.getFirst((Object)parameterName);
    }
}

