/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.encryption.CredentialProvider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordUtils.class);
    private static final Lock LOCK = new ReentrantLock();
    private static final PasswordUtils INSTANCE = new PasswordUtils();
    @Inject
    private static Configuration configuration;
    private volatile CredentialProvider credentialProvider = null;

    private PasswordUtils() {
    }

    public static PasswordUtils getInstance() {
        return INSTANCE;
    }

    public String readPassword(String passwordProperty, String defaultPassword) {
        if (StringUtils.isNotBlank((String)passwordProperty)) {
            if (CredentialProvider.isAliasString(passwordProperty)) {
                return this.readPasswordFromStore(passwordProperty);
            }
            return this.readPasswordFromFile(passwordProperty, defaultPassword);
        }
        return defaultPassword;
    }

    public String readPasswordFromFile(String filePath, String defaultPassword) {
        if (StringUtils.isBlank((String)filePath) || !this.fileExistsAndCanBeRead(filePath)) {
            LOG.debug("DB password file not specified or does not exist/can not be read - using default");
            return defaultPassword;
        }
        LOG.debug("Reading password from file {}", (Object)filePath);
        String password = null;
        try {
            password = FileUtils.readFileToString((File)new File(filePath), (Charset)Charset.defaultCharset());
            return StringUtils.chomp((String)password);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read password from file [" + filePath + "]", e);
        }
    }

    private boolean fileExistsAndCanBeRead(String filePath) {
        File passwordFile = new File(filePath);
        return passwordFile.exists() && passwordFile.canRead() && passwordFile.isFile();
    }

    private String readPasswordFromStore(String aliasStr) {
        return this.readPasswordFromStore(aliasStr, configuration);
    }

    public String readPasswordFromStore(String aliasStr, Configuration configuration) {
        String password = null;
        this.loadCredentialProvider(configuration);
        if (this.credentialProvider != null) {
            char[] result = null;
            try {
                result = this.credentialProvider.getPasswordForAlias(aliasStr);
            }
            catch (OBDPException e) {
                LOG.error("Error reading from credential store.", (Throwable)e);
            }
            if (result != null) {
                password = new String(result);
            } else if (CredentialProvider.isAliasString(aliasStr)) {
                LOG.error("Cannot read password for alias = " + aliasStr);
            } else {
                LOG.warn("Raw password provided, not an alias. It cannot be read from credential store.");
            }
        }
        return password;
    }

    private void loadCredentialProvider(Configuration configuration) {
        if (this.credentialProvider == null) {
            try {
                LOCK.lock();
                this.credentialProvider = new CredentialProvider(null, configuration);
            }
            catch (Exception e) {
                LOG.info("Credential provider creation failed", (Throwable)e);
                this.credentialProvider = null;
            }
            finally {
                LOCK.unlock();
            }
        }
    }
}

