/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpackVersion
implements Comparable<MpackVersion> {
    private static final String VERSION_WITH_HOTFIX_AND_BUILD_PATTERN = "^([0-9]+).([0-9]+).([0-9]+)-h([0-9]+)-b([0-9]+)";
    private static final String VERSION_WITH_BUILD_PATTERN = "^([0-9]+).([0-9]+).([0-9]+)-b([0-9]+)";
    private static final String LEGACY_STACK_VERSION_PATTERN = "^([0-9]+).([0-9]+).([0-9]+).([0-9]+)-([0-9]+)";
    private static final String FORMAT_VERSION_PATTERN = "^([0-9]+)(\\.)?([0-9]+)?(\\.)?([0-9]+)?(-h)?([0-9]+)?(-b)?([0-9]+)?";
    private static final Pattern PATTERN_WITH_HOTFIX = Pattern.compile("^([0-9]+).([0-9]+).([0-9]+)-h([0-9]+)-b([0-9]+)");
    private static final Pattern PATTERN_LEGACY_STACK_VERSION = Pattern.compile("^([0-9]+).([0-9]+).([0-9]+).([0-9]+)-([0-9]+)");
    private static final Pattern PATTERN_WITHOUT_HOTFIX = Pattern.compile("^([0-9]+).([0-9]+).([0-9]+)-b([0-9]+)");
    private static final Pattern PATTERN_FORMAT_VERSION = Pattern.compile("^([0-9]+)(\\.)?([0-9]+)?(\\.)?([0-9]+)?(-h)?([0-9]+)?(-b)?([0-9]+)?");
    private static final Logger LOG = LoggerFactory.getLogger(MpackVersion.class);
    private int major;
    private int minor;
    private int maint;
    private int hotfix;
    private int build;

    public MpackVersion(int major, int minor, int maint, int hotfix, int build) {
        this.major = major;
        this.minor = minor;
        this.maint = maint;
        this.hotfix = hotfix;
        this.build = build;
    }

    public static MpackVersion parse(String mpackVersion) {
        return MpackVersion.parse(mpackVersion, true);
    }

    public static MpackVersion parse(String mpackVersion, boolean strict) {
        Matcher versionMatcher;
        if (!strict) {
            mpackVersion = MpackVersion.format(mpackVersion);
        }
        if ((versionMatcher = MpackVersion.validateMpackVersion(mpackVersion)).pattern().pattern().equals(VERSION_WITH_BUILD_PATTERN)) {
            return new MpackVersion(Integer.parseInt(versionMatcher.group(1)), Integer.parseInt(versionMatcher.group(2)), Integer.parseInt(versionMatcher.group(3)), 0, Integer.parseInt(versionMatcher.group(4)));
        }
        if (versionMatcher.pattern().pattern().equals(VERSION_WITH_HOTFIX_AND_BUILD_PATTERN)) {
            return new MpackVersion(Integer.parseInt(versionMatcher.group(1)), Integer.parseInt(versionMatcher.group(2)), Integer.parseInt(versionMatcher.group(3)), Integer.parseInt(versionMatcher.group(4)), Integer.parseInt(versionMatcher.group(5)));
        }
        throw new IllegalArgumentException("Wrong format for mpack version");
    }

    public static String format(String mpackVersion) {
        Matcher m = PATTERN_FORMAT_VERSION.matcher(mpackVersion);
        if (m.matches()) {
            String majorVersion = m.group(1);
            String minorVersion = m.group(3);
            String maintVersion = m.group(5);
            String hotfixNum = m.group(7);
            String buildNum = m.group(9);
            if (!(hotfixNum == null && buildNum == null || minorVersion != null && maintVersion != null)) {
                throw new IllegalArgumentException("Wrong format for mpack version");
            }
            minorVersion = minorVersion != null ? minorVersion : "0";
            maintVersion = maintVersion != null ? maintVersion : "0";
            hotfixNum = hotfixNum != null ? hotfixNum : "0";
            buildNum = buildNum != null ? buildNum : "0";
            String formattedMpackVersion = String.format("%s.%s.%s-h%s-b%s", majorVersion, minorVersion, maintVersion, hotfixNum, buildNum);
            return formattedMpackVersion;
        }
        throw new IllegalArgumentException("Wrong format for mpack version");
    }

    public static MpackVersion parseStackVersion(String stackVersion) {
        Matcher versionMatcher = MpackVersion.validateStackVersion(stackVersion);
        if (versionMatcher.pattern().pattern().equals(LEGACY_STACK_VERSION_PATTERN)) {
            return new MpackVersion(Integer.parseInt(versionMatcher.group(1)), Integer.parseInt(versionMatcher.group(2)), Integer.parseInt(versionMatcher.group(3)), Integer.parseInt(versionMatcher.group(4)), Integer.parseInt(versionMatcher.group(5)));
        }
        throw new IllegalArgumentException("Wrong format for mpack version");
    }

    private static Matcher validateStackVersion(String version) {
        if (StringUtils.isEmpty((String)version)) {
            throw new IllegalArgumentException("Stack version can't be empty or null");
        }
        String stackVersion = StringUtils.trim((String)version);
        Matcher versionMatcher = PATTERN_LEGACY_STACK_VERSION.matcher(stackVersion);
        if (!versionMatcher.find()) {
            throw new IllegalArgumentException("Wrong format for stack version, should be N.N.N.N-N or N.N.N-hN-bN");
        }
        return versionMatcher;
    }

    private static Matcher validateMpackVersion(String version) {
        if (StringUtils.isEmpty((String)version)) {
            throw new IllegalArgumentException("Mpack version can't be empty or null");
        }
        String mpackVersion = StringUtils.trim((String)version);
        Matcher versionMatcher = PATTERN_WITH_HOTFIX.matcher(mpackVersion);
        if (!versionMatcher.find() && !(versionMatcher = PATTERN_WITHOUT_HOTFIX.matcher(mpackVersion)).find()) {
            throw new IllegalArgumentException("Wrong format for mpack version, should be N.N.N-bN or N.N.N-hN-bN");
        }
        return versionMatcher;
    }

    @Override
    public int compareTo(MpackVersion other) {
        int result = this.major - other.major;
        if (result == 0 && (result = this.minor - other.minor) == 0 && (result = this.maint - other.maint) == 0 && (result = this.hotfix - other.hotfix) == 0) {
            result = this.build - other.build;
        }
        return result > 0 ? 1 : (result < 0 ? -1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MpackVersion that = (MpackVersion)o;
        if (this.build != that.build) {
            return false;
        }
        if (this.hotfix != that.hotfix) {
            return false;
        }
        if (this.maint != that.maint) {
            return false;
        }
        if (this.major != that.major) {
            return false;
        }
        return this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.maint;
        result = 31 * result + this.hotfix;
        result = 31 * result + this.build;
        return result;
    }
}

