/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ModuleVersion
implements Comparable<ModuleVersion> {
    private static final String VERSION_WITH_HOTFIX_AND_BUILD_PATTERN = "^([0-9]+).([0-9]+).([0-9]+).([0-9]+)-h([0-9]+)-b([0-9]+)";
    private static final String VERSION_WITH_BUILD_PATTERN = "^([0-9]+).([0-9]+).([0-9]+).([0-9]+)-b([0-9]+)";
    private static final Pattern PATTERN_WITH_HOTFIX = Pattern.compile("^([0-9]+).([0-9]+).([0-9]+).([0-9]+)-h([0-9]+)-b([0-9]+)");
    private static final Pattern PATTERN_WITHOUT_HOTFIX = Pattern.compile("^([0-9]+).([0-9]+).([0-9]+).([0-9]+)-b([0-9]+)");
    private int apacheMajor;
    private int apacheMinor;
    private int internalMinor;
    private int internalMaint;
    private int hotfix;
    private int build;

    public ModuleVersion(int apacheMajor, int apacheMinor, int internalMinor, int internalMaint, int hotfix, int build) {
        this.apacheMajor = apacheMajor;
        this.apacheMinor = apacheMinor;
        this.internalMinor = internalMinor;
        this.internalMaint = internalMaint;
        this.hotfix = hotfix;
        this.build = build;
    }

    public static ModuleVersion parse(String moduleVersion) {
        Matcher versionMatcher = ModuleVersion.validateModuleVersion(moduleVersion);
        ModuleVersion result = null;
        result = versionMatcher.pattern().pattern().equals(VERSION_WITH_HOTFIX_AND_BUILD_PATTERN) ? new ModuleVersion(Integer.parseInt(versionMatcher.group(1)), Integer.parseInt(versionMatcher.group(2)), Integer.parseInt(versionMatcher.group(3)), Integer.parseInt(versionMatcher.group(4)), Integer.parseInt(versionMatcher.group(5)), Integer.parseInt(versionMatcher.group(6))) : new ModuleVersion(Integer.parseInt(versionMatcher.group(1)), Integer.parseInt(versionMatcher.group(2)), Integer.parseInt(versionMatcher.group(3)), Integer.parseInt(versionMatcher.group(4)), 0, Integer.parseInt(versionMatcher.group(5)));
        return result;
    }

    private static Matcher validateModuleVersion(String version) {
        if (StringUtils.isEmpty((String)version)) {
            throw new IllegalArgumentException("Module version can't be empty or null");
        }
        String moduleVersion = StringUtils.trim((String)version);
        Matcher versionMatcher = PATTERN_WITH_HOTFIX.matcher(moduleVersion);
        if (!versionMatcher.find() && !(versionMatcher = PATTERN_WITHOUT_HOTFIX.matcher(moduleVersion)).find()) {
            throw new IllegalArgumentException("Wrong format for module version, should be N.N.N.N-bN or N.N.N-hN-bN");
        }
        return versionMatcher;
    }

    @Override
    public int compareTo(ModuleVersion other) {
        int result = this.apacheMajor - other.apacheMajor;
        if (result == 0 && (result = this.apacheMinor - other.apacheMinor) == 0 && (result = this.internalMinor - other.internalMinor) == 0 && (result = this.internalMaint - other.internalMaint) == 0 && (result = this.hotfix - other.hotfix) == 0) {
            result = this.build - other.build;
        }
        return result > 0 ? 1 : (result < 0 ? -1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleVersion that = (ModuleVersion)o;
        if (this.apacheMajor != that.apacheMajor) {
            return false;
        }
        if (this.apacheMinor != that.apacheMinor) {
            return false;
        }
        if (this.build != that.build) {
            return false;
        }
        if (this.hotfix != that.hotfix) {
            return false;
        }
        if (this.internalMaint != that.internalMaint) {
            return false;
        }
        return this.internalMinor == that.internalMinor;
    }

    public int hashCode() {
        int result = this.apacheMajor;
        result = 31 * result + this.apacheMinor;
        result = 31 * result + this.internalMinor;
        result = 31 * result + this.internalMaint;
        result = 31 * result + this.hotfix;
        result = 31 * result + this.build;
        return result;
    }
}

